/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.yungscavebiomes.module.TrimPatternsModule;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7157;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8055;
import net.minecraft.class_8056;

public class DebugSpawnArmorTrimsCommand {
    private static final Map<Pair<class_1741, class_1304>, class_1792> MATERIAL_AND_SLOT_TO_ITEM = (Map)class_156.method_654((Object)Maps.newHashMap(), $$0 -> {
        $$0.put(Pair.of((Object)class_1740.field_7887, (Object)class_1304.field_6169), class_1802.field_8283);
        $$0.put(Pair.of((Object)class_1740.field_7887, (Object)class_1304.field_6174), class_1802.field_8873);
        $$0.put(Pair.of((Object)class_1740.field_7887, (Object)class_1304.field_6172), class_1802.field_8218);
        $$0.put(Pair.of((Object)class_1740.field_7887, (Object)class_1304.field_6166), class_1802.field_8313);
        $$0.put(Pair.of((Object)class_1740.field_7892, (Object)class_1304.field_6169), class_1802.field_8743);
        $$0.put(Pair.of((Object)class_1740.field_7892, (Object)class_1304.field_6174), class_1802.field_8523);
        $$0.put(Pair.of((Object)class_1740.field_7892, (Object)class_1304.field_6172), class_1802.field_8396);
        $$0.put(Pair.of((Object)class_1740.field_7892, (Object)class_1304.field_6166), class_1802.field_8660);
        $$0.put(Pair.of((Object)class_1740.field_7895, (Object)class_1304.field_6169), class_1802.field_8862);
        $$0.put(Pair.of((Object)class_1740.field_7895, (Object)class_1304.field_6174), class_1802.field_8678);
        $$0.put(Pair.of((Object)class_1740.field_7895, (Object)class_1304.field_6172), class_1802.field_8416);
        $$0.put(Pair.of((Object)class_1740.field_7895, (Object)class_1304.field_6166), class_1802.field_8753);
        $$0.put(Pair.of((Object)class_1740.field_21977, (Object)class_1304.field_6169), class_1802.field_22027);
        $$0.put(Pair.of((Object)class_1740.field_21977, (Object)class_1304.field_6174), class_1802.field_22028);
        $$0.put(Pair.of((Object)class_1740.field_21977, (Object)class_1304.field_6172), class_1802.field_22029);
        $$0.put(Pair.of((Object)class_1740.field_21977, (Object)class_1304.field_6166), class_1802.field_22030);
        $$0.put(Pair.of((Object)class_1740.field_7889, (Object)class_1304.field_6169), class_1802.field_8805);
        $$0.put(Pair.of((Object)class_1740.field_7889, (Object)class_1304.field_6174), class_1802.field_8058);
        $$0.put(Pair.of((Object)class_1740.field_7889, (Object)class_1304.field_6172), class_1802.field_8348);
        $$0.put(Pair.of((Object)class_1740.field_7889, (Object)class_1304.field_6166), class_1802.field_8285);
        $$0.put(Pair.of((Object)class_1740.field_7890, (Object)class_1304.field_6169), class_1802.field_8090);
    });
    private static final List<class_5321<class_8056>> TRIM_PATTERNS = List.of(TrimPatternsModule.ANCIENT);
    private static final List<class_5321<class_8054>> TRIM_MATERIALS = List.of(class_8055.field_42004, class_8055.field_42005, class_8055.field_42006, class_8055.field_42007, class_8055.field_42008, class_8055.field_42009, class_8055.field_42010, class_8055.field_42011, class_8055.field_42012, class_8055.field_42013);
    private static final ToIntFunction<class_5321<class_8056>> TRIM_PATTERN_ORDER = class_156.method_43658(TRIM_PATTERNS);
    private static final ToIntFunction<class_5321<class_8054>> TRIM_MATERIAL_ORDER = class_156.method_43658(TRIM_MATERIALS);

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 ctx, class_2170.class_5364 selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ycb_armor_trims").requires(source -> source.method_9259(2))).executes(context -> DebugSpawnArmorTrimsCommand.spawnArmorTrims((class_2168)context.getSource(), (class_1657)((class_2168)context.getSource()).method_9207())));
    }

    private static int spawnArmorTrims(class_2168 source, class_1657 player) {
        class_1937 level = player.method_37908();
        class_2371 armorTrims = class_2371.method_10211();
        class_2378 patternRegistry = level.method_30349().method_30530(class_7924.field_42082);
        class_2378 materialRegistry = level.method_30349().method_30530(class_7924.field_42083);
        patternRegistry.method_10220().filter(pattern -> pattern.comp_1213().method_12836().equals("yungscavebiomes")).sorted(Comparator.comparing(p -> TRIM_PATTERN_ORDER.applyAsInt((class_5321<class_8056>)((class_5321)patternRegistry.method_29113(p).orElse(null))))).forEachOrdered(p -> materialRegistry.method_10220().sorted(Comparator.comparing(m -> TRIM_MATERIAL_ORDER.applyAsInt((class_5321<class_8054>)((class_5321)materialRegistry.method_29113(m).orElse(null))))).forEachOrdered(m -> armorTrims.add((Object)new class_8053(materialRegistry.method_47983(m), patternRegistry.method_47983(p)))));
        class_2338 pos = player.method_24515().method_10079(player.method_5735(), 5);
        int numMats = class_1740.values().length - 1;
        double $$8 = 3.0;
        int trimIndex = 0;
        int materialIndex = 0;
        for (class_8053 trim : armorTrims) {
            for (class_1740 material : class_1740.values()) {
                if (material == class_1740.field_7897) continue;
                double x = (double)pos.method_10263() + 0.5 - (double)(trimIndex % materialRegistry.method_10204()) * 3.0;
                double y = (double)pos.method_10264() + 0.5 + (double)(materialIndex % numMats) * 3.0;
                double z = (double)pos.method_10260() + 0.5 + (double)(trimIndex / materialRegistry.method_10204() * 10);
                class_1531 armorStand = new class_1531(level, x, y, z);
                armorStand.method_36456(180.0f);
                armorStand.method_5875(true);
                for (class_1304 slot : class_1304.values()) {
                    class_1738 $$20;
                    class_1792 armorItem = MATERIAL_AND_SLOT_TO_ITEM.get(Pair.of((Object)material, (Object)slot));
                    if (armorItem == null) continue;
                    class_1799 armorItemStack = new class_1799((class_1935)armorItem);
                    class_8053.method_48429((class_5455)level.method_30349(), (class_1799)armorItemStack, (class_8053)trim);
                    armorStand.method_5673(slot, armorItemStack);
                    if (armorItem instanceof class_1738 && ($$20 = (class_1738)armorItem).method_7686() == class_1740.field_7890) {
                        armorStand.method_5665((class_2561)((class_8056)trim.method_48424().comp_349()).method_48446(trim.method_48431()).method_27661().method_27693(" ").method_10852(((class_8054)trim.method_48431().comp_349()).comp_1212()));
                        armorStand.method_5880(true);
                        continue;
                    }
                    armorStand.method_5648(true);
                }
                level.method_8649((class_1297)armorStand);
                ++materialIndex;
            }
            ++trimIndex;
        }
        source.method_9226(() -> class_2561.method_43470((String)"Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }
}

