/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.ice_cube;

import com.yungnickyoung.minecraft.yungscavebiomes.block.IceSheetBlock;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.ice_cube.goal.IceCubeAttackGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.ice_cube.goal.IceCubeLeapGoal;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1545;
import net.minecraft.class_1588;
import net.minecraft.class_1589;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;

public class IceCubeEntity
extends class_1588 {
    private static final class_2940<Boolean> IS_LEAPING = class_2945.method_12791(IceCubeEntity.class, (class_2941)class_2943.field_13323);
    private boolean wasOnGround;
    public float targetSquish;
    public float squish;
    public float oSquish;
    private int leapTicks;
    private final class_1335 slimeMoveControl;
    private final class_1335 slidingMoveControl;

    public IceCubeEntity(class_1299<? extends IceCubeEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.method_35054(true);
        this.field_6194 = 12;
        this.slimeMoveControl = new IceCubeSlimeMoveControl(this);
        this.slidingMoveControl = new class_1335((class_1308)this);
        this.field_6207 = this.slimeMoveControl;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1589.class, 6.0f, 1.0, 1.2));
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1545.class, 6.0f, 1.0, 1.2));
        this.field_6201.method_6277(4, (class_1352)new IceCubeLeapGoal(this, 0.4f));
        this.field_6201.method_6277(5, (class_1352)new IceCubeAttackGoal((class_1314)this, 1.0, 1.0f, false));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 32.0).method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23724, 2.0);
    }

    public void method_5652(@NotNull class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10556("wasOnGround", this.wasOnGround);
    }

    public void method_5749(@NotNull class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.wasOnGround = compoundTag.method_10577("wasOnGround");
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_LEAPING, (Object)false);
    }

    public void setLeaping(boolean leaping) {
        this.field_6011.method_12778(IS_LEAPING, (Object)leaping);
        this.leapTicks = leaping ? 15 : 0;
    }

    public boolean getLeaping() {
        return (Boolean)this.field_6011.method_12789(IS_LEAPING);
    }

    public void method_5773() {
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.oSquish = this.squish;
        super.method_5773();
        if (this.method_24828() && !this.wasOnGround) {
            for (int j = 0; j < 24; ++j) {
                float f = this.field_5974.method_43057() * ((float)Math.PI * 2);
                float g = this.field_5974.method_43057() * 0.5f + 0.5f;
                float xOffset = class_3532.method_15374((float)f) * 3.0f * 0.5f * g;
                float zOffset = class_3532.method_15362((float)f) * 3.0f * 0.5f * g;
                this.method_37908().method_8406(this.getParticleType(), this.method_23317() + (double)xOffset, this.method_23318(), this.method_23321() + (double)zOffset, 0.0, 0.0, 0.0);
                this.targetSquish = -0.5f;
            }
            this.method_5783(class_3417.field_15095, this.method_6107(), ((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f) / 0.8f);
        } else if (!this.method_24828() && this.wasOnGround) {
            this.targetSquish = 1.0f;
        }
        this.wasOnGround = this.method_24828();
        this.decreaseSquish();
        this.field_6207 = this.method_5968() == null || this.method_5858((class_1297)this.method_5968()) > 100.0 || Math.abs(this.method_23318() - this.method_5968().method_23318()) / this.method_5649(this.method_5968().method_23317(), this.method_23318(), this.method_5968().method_23321()) > 0.5 ? this.slimeMoveControl : this.slidingMoveControl;
    }

    private void decreaseSquish() {
        this.targetSquish *= 0.6f;
    }

    public void method_6007() {
        if (this.method_5805()) {
            // empty if block
        }
        if (!this.method_37908().method_8608() && this.getLeaping() && this.leapTicks-- <= 0) {
            this.setLeaping(false);
        }
        super.method_6007();
        IceSheetBlock iceSheet = (IceSheetBlock)((Object)BlockModule.ICE_SHEET.get());
        for (int i = 0; i < 4; ++i) {
            class_2680 updatedBlockState;
            int x = class_3532.method_15357((double)(this.method_23317() + (double)((float)(i % 2 * 2 - 1) * 0.25f)));
            int y = class_3532.method_15357((double)this.method_23318());
            int z = class_3532.method_15357((double)(this.method_23321() + (double)((float)(i / 2 % 2 * 2 - 1) * 0.25f)));
            class_2338 blockPos = new class_2338(x, y, z);
            class_2680 blockState = this.method_37908().method_8320(blockPos);
            if (!blockState.method_26215() || (updatedBlockState = iceSheet.method_33362(blockState, (class_1922)this.method_37908(), blockPos, class_2350.field_11033)) == null) continue;
            this.method_37908().method_8501(blockPos, updatedBlockState);
            this.method_37908().method_43276(class_5712.field_28164, blockPos, class_5712.class_7397.method_43286((class_1297)this, (class_2680)updatedBlockState));
        }
    }

    protected void method_6043() {
        class_243 vec3 = this.method_18798();
        this.method_18800(vec3.field_1352, this.method_6106(), vec3.field_1350);
        this.field_6007 = true;
    }

    public void method_5694(@NotNull class_1657 player) {
        this.dealDamage((class_1309)player);
    }

    protected void method_5623(double $$0, boolean $$1, class_2680 $$2, class_2338 $$3) {
    }

    public void method_32317(int $$0) {
    }

    public int getJumpDelay() {
        return this.field_5974.method_43048(20) + 10;
    }

    public void method_18382() {
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        super.method_18382();
        this.method_5814(d, e, f);
    }

    public void method_5674(@NotNull class_2940<?> entityDataAccessor) {
        this.method_18382();
        this.method_36456(this.field_6241);
        this.field_6283 = this.field_6241;
        if (this.method_5799() && this.field_5974.method_43048(20) == 0) {
            this.method_5746();
        }
        super.method_5674(entityDataAccessor);
    }

    protected void dealDamage(class_1309 livingEntity) {
        if (this.method_5805() && this.method_5858((class_1297)livingEntity) < 2.5 && this.method_6057((class_1297)livingEntity) && livingEntity.method_5643(this.method_48923().method_48812((class_1309)this), this.getAttackDamage())) {
            this.method_5783(class_3417.field_14863, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
            this.method_5723((class_1309)this, (class_1297)livingEntity);
            livingEntity.method_32317(livingEntity.method_32312() + 200);
        }
    }

    @ParametersAreNonnullByDefault
    protected float method_18394(class_4050 pose, class_4048 entityDimensions) {
        return 0.15f;
    }

    protected float getAttackDamage() {
        return (float)this.method_26825(class_5134.field_23721);
    }

    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return class_3417.field_15014;
    }

    float getSoundPitch() {
        return ((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f) * 0.8f;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14763;
    }

    protected class_3414 getStepSound() {
        return class_3417.field_14769;
    }

    public class_3414 getJumpSound() {
        return class_3417.field_14919;
    }

    public int method_5978() {
        return 0;
    }

    protected class_2394 getParticleType() {
        return class_2398.field_28013;
    }

    private static class IceCubeSlimeMoveControl
    extends class_1335 {
        private float yRot;
        private int jumpDelay;
        private final IceCubeEntity iceCube;
        private boolean isAggressive;

        public IceCubeSlimeMoveControl(IceCubeEntity iceCube) {
            super((class_1308)iceCube);
            this.iceCube = iceCube;
            this.yRot = 180.0f * iceCube.method_36454() / (float)Math.PI;
        }

        public void setDirection(float yRot, boolean isAggressive) {
            this.yRot = yRot;
            this.isAggressive = isAggressive;
        }

        public void setWantedMovement(double speedModifier) {
            this.field_6372 = speedModifier;
            this.field_6374 = class_1335.class_1336.field_6378;
        }

        public void method_6240() {
            this.field_6371.method_36456(this.method_6238(this.field_6371.method_36454(), this.yRot, 90.0f));
            this.field_6371.field_6241 = this.field_6371.method_36454();
            this.field_6371.field_6283 = this.field_6371.method_36454();
            if (this.field_6374 != class_1335.class_1336.field_6378) {
                this.field_6371.method_5930(0.0f);
            } else {
                this.field_6374 = class_1335.class_1336.field_6377;
                if (this.field_6371.method_24828()) {
                    this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_26825(class_5134.field_23719)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.iceCube.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.iceCube.method_5993().method_6233();
                        this.iceCube.method_5783(this.iceCube.getJumpSound(), this.iceCube.method_6107(), this.iceCube.getSoundPitch());
                    } else {
                        this.iceCube.field_6212 = 0.0f;
                        this.iceCube.field_6250 = 0.0f;
                        this.field_6371.method_6125(0.0f);
                    }
                } else {
                    this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_26825(class_5134.field_23719)));
                }
            }
        }
    }
}

