/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal;

import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.SandSnapperEntity;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.ISandstormServerDataProvider;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.SandstormServerData;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4051;

public class EmergeGoal
extends class_1352 {
    private final SandSnapperEntity sandSnapper;
    private final float minDistanceFromPlayer;
    private final float minDistanceFromPlayerDuringSandstorm;
    private final float lookAtPlayerRange;
    private final int cooldown;
    private int ticksRunning;
    private int lastUseTime;

    public EmergeGoal(SandSnapperEntity sandSnapper, float minDistanceFromPlayer, float minDistanceFromPlayerDuringSandstorm, float lookAtPlayerRange, int cooldown) {
        this.sandSnapper = sandSnapper;
        this.minDistanceFromPlayer = minDistanceFromPlayer;
        this.minDistanceFromPlayerDuringSandstorm = minDistanceFromPlayerDuringSandstorm;
        this.lookAtPlayerRange = lookAtPlayerRange;
        this.cooldown = cooldown;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
    }

    public void method_6268() {
        ++this.ticksRunning;
        class_1657 nearestPlayer = this.sandSnapper.method_37908().method_18460((class_1297)this.sandSnapper, (double)this.lookAtPlayerRange);
        if (this.sandSnapper.isLookingAtPlayer() && nearestPlayer != null) {
            this.sandSnapper.method_5988().method_35111((class_1297)nearestPlayer);
        }
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6269() {
        this.ticksRunning = 0;
        this.sandSnapper.setEmerging(true);
        this.sandSnapper.setLookingAtPlayer(!this.getPlayersInRange(this.lookAtPlayerRange).isEmpty());
        this.sandSnapper.method_5942().method_6340();
    }

    public void method_6270() {
        float dist;
        this.sandSnapper.setEmerging(false);
        this.sandSnapper.setDiving(true);
        this.lastUseTime = this.sandSnapper.field_6012;
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.method_37908()).getSandstormServerData();
        float f = dist = sandstormServerData.isSandstormActive() ? this.minDistanceFromPlayerDuringSandstorm : this.minDistanceFromPlayer;
        if (!this.getPlayersInRange(dist).isEmpty()) {
            this.sandSnapper.tryPlayPanicSound();
        }
    }

    public boolean method_6264() {
        class_243 endPos;
        if (!this.sandSnapper.isSubmerged() || !this.sandSnapper.canMove()) {
            return false;
        }
        if (this.sandSnapper.field_6012 - this.lastUseTime < this.cooldown) {
            return false;
        }
        float halfWidth = 0.8f;
        class_243 startPos = new class_243(this.sandSnapper.method_23317() - (double)halfWidth, this.sandSnapper.method_23318() - 2.0, this.sandSnapper.method_23321() - (double)halfWidth);
        boolean intersectsAir = class_2338.method_29715((class_238)new class_238(startPos, endPos = new class_243(this.sandSnapper.method_23317() + (double)halfWidth, this.sandSnapper.method_23318() - (double)0.6f, this.sandSnapper.method_23321() + (double)halfWidth))).anyMatch(pos -> this.sandSnapper.method_37908().method_8320(pos).method_26215());
        if (intersectsAir) {
            return false;
        }
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.method_37908()).getSandstormServerData();
        float dist = sandstormServerData.isSandstormActive() ? this.minDistanceFromPlayerDuringSandstorm : this.minDistanceFromPlayer;
        return this.getPlayersInRange(dist).isEmpty();
    }

    public boolean method_6266() {
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.method_37908()).getSandstormServerData();
        float dist = sandstormServerData.isSandstormActive() ? this.minDistanceFromPlayerDuringSandstorm : this.minDistanceFromPlayer;
        return this.getPlayersInRange(dist).isEmpty() && this.ticksRunning <= 57;
    }

    public boolean method_6267() {
        return false;
    }

    private List<class_1657> getPlayersInRange(float range) {
        class_238 searchBox = this.sandSnapper.method_5829().method_1009((double)range, 4.0, (double)range);
        return this.sandSnapper.method_37908().method_18464(class_4051.field_18092, (class_1309)this.sandSnapper, searchBox);
    }
}

