/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.sandstorm;

import com.google.common.hash.Hashing;
import com.yungnickyoung.minecraft.yungscavebiomes.YungsCaveBiomesCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.mixin.accessor.ServerLevelAccessor;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BiomeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.CriteriaModule;
import com.yungnickyoung.minecraft.yungscavebiomes.services.Services;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class SandstormServerData
extends class_18 {
    private static final int SYNC_INTERVAL = 60;
    private final class_3218 serverLevel;
    private int timeSinceSync;
    private boolean isSandstormActive = false;
    private int currSandstormTicks;
    private int cooldownTicks;
    private int totalSandstormDurationTicks;
    private int totalSandstormCooldownTicks;
    private long sandstormSeed;

    public SandstormServerData(class_3218 serverLevel) {
        this.serverLevel = serverLevel;
        this.resetSandstormTimeAndTotalDuration();
        this.resetSandstormCooldownAndTotalCoolDown();
        this.method_80();
    }

    public SandstormServerData(class_3218 serverLevel, class_2487 compoundTag) {
        this(serverLevel);
        this.isSandstormActive = compoundTag.method_10577("isSandstormActive");
        this.sandstormSeed = compoundTag.method_10537("sandstormSeed");
        this.currSandstormTicks = compoundTag.method_10550("sandstormTime");
        this.cooldownTicks = compoundTag.method_10550("sandstormCooldown");
        this.totalSandstormDurationTicks = compoundTag.method_10550("totalSandstormDuration");
        this.totalSandstormCooldownTicks = compoundTag.method_10550("totalSandstormCooldown");
    }

    public void start() {
        YungsCaveBiomesCommon.LOGGER.debug("Starting sandstorm in {}", (Object)this.serverLevel.method_27983().method_29177());
        this.resetSandstormTimeAndTotalDuration();
        this.sandstormSeed = Hashing.sha256().hashLong(this.sandstormSeed + ((ServerLevelAccessor)this.serverLevel).getServerLevelData().method_188()).asLong();
        this.isSandstormActive = true;
        this.syncToClients();
    }

    public void stop() {
        YungsCaveBiomesCommon.LOGGER.debug("STOPPING SANDSTORM in {}", (Object)this.serverLevel.method_27983().method_29177());
        this.resetSandstormCooldownAndTotalCoolDown();
        this.isSandstormActive = false;
        this.serverLevel.method_18456().forEach(player -> {
            if (!player.method_7325() && this.serverLevel.method_23753(player.method_24515()).method_40225(BiomeModule.LOST_CAVES)) {
                CriteriaModule.SANDSTORM_END.trigger((class_3222)player);
            }
        });
        this.syncToClients();
    }

    public void tick() {
        if (YungsCaveBiomesCommon.DEBUG_LOG) {
            YungsCaveBiomesCommon.LOGGER.info("Sandstorm {} >> {} / {} time, {} / {} cooldown", (Object)this.serverLevel.method_27983().method_29177(), (Object)this.currSandstormTicks, (Object)this.totalSandstormDurationTicks, (Object)this.cooldownTicks, (Object)this.totalSandstormCooldownTicks);
        }
        ++this.timeSinceSync;
        if (this.isSandstormActive) {
            --this.currSandstormTicks;
            if (this.currSandstormTicks <= 0) {
                this.stop();
            }
        } else {
            --this.cooldownTicks;
            if (this.cooldownTicks <= 0) {
                this.start();
            }
        }
        if (this.timeSinceSync > 60) {
            this.syncToClients();
            if (YungsCaveBiomesCommon.DEBUG_LOG) {
                YungsCaveBiomesCommon.LOGGER.info("Force syncing sandstorm...");
            }
        }
    }

    public class_2487 method_75(class_2487 compoundTag) {
        compoundTag.method_10556("isSandstormActive", this.isSandstormActive);
        compoundTag.method_10544("sandstormSeed", this.sandstormSeed);
        compoundTag.method_10569("sandstormTime", this.currSandstormTicks);
        compoundTag.method_10569("sandstormCooldown", this.cooldownTicks);
        compoundTag.method_10569("totalSandstormDuration", this.totalSandstormDurationTicks);
        compoundTag.method_10569("totalSandstormCooldown", this.totalSandstormCooldownTicks);
        return compoundTag;
    }

    private void resetSandstormTimeAndTotalDuration() {
        this.currSandstormTicks = this.totalSandstormDurationTicks = class_3532.method_32751((class_5819)this.serverLevel.method_8409(), (int)YungsCaveBiomesCommon.CONFIG.lostCaves.minSandstormDuration, (int)YungsCaveBiomesCommon.CONFIG.lostCaves.maxSandstormDuration) * 20;
    }

    private void resetSandstormCooldownAndTotalCoolDown() {
        this.cooldownTicks = this.totalSandstormCooldownTicks = class_3532.method_32751((class_5819)this.serverLevel.method_8409(), (int)YungsCaveBiomesCommon.CONFIG.lostCaves.minTimeBetweenSandstorms, (int)YungsCaveBiomesCommon.CONFIG.lostCaves.maxTimeBetweenSandstorms) * 20;
    }

    private void syncToClients() {
        Services.PLATFORM.syncSandstormDataToClients(this);
        this.timeSinceSync = 0;
        this.method_80();
    }

    public class_3218 getServerLevel() {
        return this.serverLevel;
    }

    public boolean isSandstormActive() {
        return this.isSandstormActive;
    }

    public int getCurrSandstormTicks() {
        return this.currSandstormTicks;
    }

    public long getSeed() {
        return this.sandstormSeed;
    }

    public int getTotalSandstormDurationTicks() {
        return this.totalSandstormDurationTicks;
    }
}

