/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.services;

import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.EntityTypeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.NetworkModuleFabric;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.SandstormServerData;
import com.yungnickyoung.minecraft.yungscavebiomes.services.IPlatformHelper;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2362;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3619;
import net.minecraft.class_4970;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public void sendIcicleProjectileShatterS2CPacket(class_3218 level, class_243 pos) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(pos.method_10216());
        buf.writeDouble(pos.method_10214());
        buf.writeDouble(pos.method_10215());
        for (class_3222 player : PlayerLookup.tracking((class_3218)level, (class_2338)class_2338.method_49638((class_2374)pos))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkModuleFabric.ICICLE_SHATTER_ID, (class_2540)buf);
        }
    }

    @Override
    public void syncSandstormDataToClients(SandstormServerData sandstormServerData) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(sandstormServerData.isSandstormActive());
        buf.writeInt(sandstormServerData.getCurrSandstormTicks());
        buf.writeLong(sandstormServerData.getSeed());
        buf.writeInt(sandstormServerData.getTotalSandstormDurationTicks());
        PlayerLookup.world((class_3218)sandstormServerData.getServerLevel()).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkModuleFabric.SANDSTORM_SYNC_ID, (class_2540)buf));
    }

    @Override
    public void syncSandstormDataToPlayer(SandstormServerData sandstormServerData, class_3222 serverPlayer) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeBoolean(sandstormServerData.isSandstormActive());
        buf.writeInt(sandstormServerData.getCurrSandstormTicks());
        buf.writeLong(sandstormServerData.getSeed());
        buf.writeInt(sandstormServerData.getTotalSandstormDurationTicks());
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)NetworkModuleFabric.SANDSTORM_SYNC_ID, (class_2540)buf);
    }

    @Override
    public Supplier<class_1792> getIceCubeSpawnEggItem() {
        return () -> new class_1826((class_1299)EntityTypeModule.ICE_CUBE.get(), 10798332, 15002876, new class_1792.class_1793());
    }

    @Override
    public Supplier<class_1792> getSandSnapperSpawnEggItem() {
        return () -> new class_1826((class_1299)EntityTypeModule.SAND_SNAPPER.get(), 12223791, 13610069, new class_1792.class_1793());
    }

    @Override
    public class_2248 getPottedPricklyPeachCactusBlock() {
        return new class_2362((class_2248)BlockModule.PRICKLY_PEACH_CACTUS.get(), class_4970.class_2251.method_9637().method_9618().method_22488().method_50012(class_3619.field_15971));
    }
}

