/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.world.noise.OpenSimplex2S;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3175;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class PillarRockFeature
extends class_3031<class_3175> {
    private static final int RADIUS_MIN = 5;
    private static final int RADIUS_MAX = 10;
    private static final float HEIGHT_RELATIVE_TO_RADIUS_MIN = 1.5f;
    private static final float HEIGHT_RELATIVE_TO_RADIUS_MAX = 2.0f;
    private static final float TOP_HEIGHT_PROPORTION = 0.3f;
    private static final float TOP_START_HEMISPHERE_OFFSET_MIN = 0.875f;
    private static final float TOP_START_HEMISPHERE_OFFSET_MAX = 0.9375f;
    private static final float BOTTOM_START_HEMISPHERE_OFFSET_MIN = 0.25f;
    private static final float BOTTOM_START_HEMISPHERE_OFFSET_MAX = 0.5f;
    private static final double NOISE_FREQUENCY_XZ = 0.1;
    private static final double NOISE_FREQUENCY_Y = 0.08333333333333334;
    public static final float NOISE_MODULATION_AMOUNT = 0.6f;
    private static final long NOISE_SEED_FLIP_MASK = 4187418520378946841L;

    public PillarRockFeature(Codec<class_3175> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3175> context) {
        class_5281 level = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 random = context.method_33654();
        class_3175 config = (class_3175)context.method_33656();
        class_2680 state = config.comp_156().method_23455(random, context.method_33655());
        long noiseSeed = level.method_8412() ^ 0x3A1CB2F559143519L;
        float radXZ = class_3532.method_27285((float)random.method_43057()) * 5.0f + 5.0f;
        float height = class_3532.method_15344((class_5819)random, (float)1.5f, (float)2.0f) * radXZ;
        float topHeight = radXZ * 0.3f;
        float bottomHeight = height - topHeight;
        float creasePositionY = height * 0.5f - topHeight;
        float topStartHemisphereOffset = class_3532.method_15344((class_5819)random, (float)0.875f, (float)0.9375f);
        float bottomStartHemisphereOffset = class_3532.method_15344((class_5819)random, (float)0.25f, (float)0.5f);
        float dyTopMultiplier = (1.0f - topStartHemisphereOffset) / topHeight;
        float dyBottomMultiplier = (bottomStartHemisphereOffset - 1.0f) / bottomHeight;
        float dyTopOffset = topStartHemisphereOffset - dyTopMultiplier * creasePositionY;
        float dyBottomOffset = bottomStartHemisphereOffset - dyBottomMultiplier * creasePositionY;
        float dySqTopAtCrease = class_3532.method_27285((float)(creasePositionY * dyTopMultiplier + dyTopOffset));
        float dySqBottomAtCrease = class_3532.method_27285((float)(creasePositionY * dyBottomMultiplier + dyBottomOffset));
        float topStartDistSqXZCorrection = (1.0f - dySqTopAtCrease) / (radXZ * radXZ);
        float bottomStartDistSqXZCorrection = (1.0f - dySqBottomAtCrease) / (radXZ * radXZ);
        float falloffCurveTopMultiplier = -1.0f / (1.0f - dySqTopAtCrease);
        float falloffCurveBottomMultiplier = -1.0f / (1.0f - dySqBottomAtCrease);
        float falloffCurveTopOffset = 1.0f - falloffCurveTopMultiplier * dySqTopAtCrease;
        float falloffCurveBottomOffset = 1.0f - falloffCurveBottomMultiplier * dySqBottomAtCrease;
        int radYBound = class_3532.method_15386((float)(height * 0.5f));
        int radXZBound = class_3532.method_15386((float)radXZ);
        for (int dy = -radYBound; dy <= radYBound; ++dy) {
            boolean isTop = (float)dy >= creasePositionY;
            float dySq = isTop ? class_3532.method_27285((float)((float)dy * dyTopMultiplier + dyTopOffset)) : class_3532.method_27285((float)((float)dy * dyBottomMultiplier + dyBottomOffset));
            for (int dz = -radXZBound; dz <= radXZBound; ++dz) {
                for (int dx = -radXZBound; dx <= radXZBound; ++dx) {
                    boolean isInRange;
                    float distSqXZ = (float)(dx * dx + dz * dz) * (isTop ? topStartDistSqXZCorrection : bottomStartDistSqXZCorrection);
                    float distSq = distSqXZ + dySq;
                    float baseDensityHere = isTop ? distSq * falloffCurveTopMultiplier + falloffCurveTopOffset : distSq * falloffCurveBottomMultiplier + falloffCurveBottomOffset;
                    boolean bl = isInRange = baseDensityHere >= 0.6f;
                    if (!isInRange) {
                        float noiseHere = OpenSimplex2S.noise3_ImproveXZ(noiseSeed, (double)(dx + origin.method_10263()) * 0.1, (double)(dy + origin.method_10264()) * 0.08333333333333334, (double)(dz + origin.method_10260()) * 0.1) * 0.3f + 0.3f;
                        float densityHere = baseDensityHere - noiseHere;
                        boolean bl2 = isInRange = densityHere > 0.0f;
                    }
                    if (!isInRange) continue;
                    class_2338 local = origin.method_10069(dx, dy, dz);
                    level.method_8652(local, state, 3);
                }
            }
        }
        return false;
    }
}

