/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.birds;

import dev.hybridlabs.birds.config.EntitySpawnConfig;
import dev.hybridlabs.birds.config.HybridBirdsConfig;
import dev.hybridlabs.birds.config.HybridBirdsConfigHandler;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1311;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Ldev/hybridlabs/birds/HybridBirds;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "initializeConfig", "Ldev/hybridlabs/birds/config/HybridBirdsConfig;", "config", "registerBiomeModifications", "(Ldev/hybridlabs/birds/config/HybridBirdsConfig;)V", "", "MOD_ID", "Ljava/lang/String;", "MOD_NAME", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "Ljava/nio/file/Path;", "configFile", "Ljava/nio/file/Path;", "Ldev/hybridlabs/birds/config/HybridBirdsConfigHandler;", "configHandler", "Ldev/hybridlabs/birds/config/HybridBirdsConfigHandler;", "hybrid-birds"})
@SourceDebugExtension(value={"SMAP\nHybridBirds.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HybridBirds.kt\ndev/hybridlabs/birds/HybridBirds\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1869#2,2:86\n*S KotlinDebug\n*F\n+ 1 HybridBirds.kt\ndev/hybridlabs/birds/HybridBirds\n*L\n80#1:86,2\n*E\n"})
public final class HybridBirds
implements ModInitializer {
    @NotNull
    public static final HybridBirds INSTANCE = new HybridBirds();
    @NotNull
    public static final String MOD_ID = "hybrid-birds";
    @NotNull
    private static final String MOD_NAME = "Hybrid Birds";
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Path configFile;
    @NotNull
    private static final HybridBirdsConfigHandler configHandler;

    private HybridBirds() {
    }

    public void onInitialize() {
        logger.info("Initializing Hybrid Birds");
        this.initializeConfig();
        this.registerBiomeModifications(configHandler.getConfig());
    }

    private final void initializeConfig() {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(configFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            logger.info("Hybrid Birds config file did not exist, creating one");
            configHandler.save();
        } else {
            logger.info("Loading Hybrid Birds config file");
            configHandler.load();
            HybridBirdsConfig defaultConfig = configHandler.getDefaultConfig();
            HybridBirdsConfig config = configHandler.getConfig();
            if (config.getDataVersion() < defaultConfig.getDataVersion()) {
                logger.info("Old Hybrid Birds config file found, upgrading");
                configHandler.backup();
                configHandler.setConfig(defaultConfig);
                configHandler.save();
                logger.info("Hybrid Birds config reset, the old config has been backed up to \"" + configHandler.getBackupFile() + "\"");
            }
        }
    }

    private final void registerBiomeModifications(HybridBirdsConfig config) {
        Iterable $this$forEach$iv = config.getEntitySpawnConfig();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntitySpawnConfig config2 = (EntitySpawnConfig)element$iv;
            boolean bl = false;
            BiomeModifications.addSpawn((Predicate)BiomeSelectors.tag(config2.getBiomes()), (class_1311)config2.getGroup(), config2.getType(), (int)config2.getWeight(), (int)config2.getMinGroupSize(), (int)config2.getMaxGroupSize());
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)MOD_ID);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        HybridBirds.logger = logger;
        Path path = FabricLoader.getInstance().getConfigDir().resolve("hybrid-birds.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        configFile = path;
        File file = configFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        configHandler = new HybridBirdsConfigHandler(file, null, 2, null);
    }
}

