/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal;

import com.yungnickyoung.minecraft.yungscavebiomes.block.PricklyPeachCactusBlock;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.SandSnapperEntity;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.ISandstormServerDataProvider;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.SandstormServerData;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class EatPricklyPeachCactusGoal
extends Goal {
    private final SandSnapperEntity sandSnapper;
    private final int horizontalRange;
    private final int verticalRange;
    private final float playerDist;
    private final float eatRange;
    private Vec3 cactusPos;
    private int eatingTimer;
    private static final int EAT_LENGTH = 31;

    public EatPricklyPeachCactusGoal(SandSnapperEntity sandSnapper, int horizontalRange, int verticalRange, float playerDist, float eatRange) {
        this.sandSnapper = sandSnapper;
        this.horizontalRange = horizontalRange;
        this.verticalRange = verticalRange;
        this.playerDist = playerDist;
        this.eatRange = eatRange;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public void start() {
        this.sandSnapper.setSubmerged(false);
        this.sandSnapper.setSubmergeLocked(true);
        this.sandSnapper.getNavigation().moveTo(this.cactusPos.x, this.cactusPos.y, this.cactusPos.z, 1.0);
    }

    public void stop() {
        this.sandSnapper.setEating(false);
        this.sandSnapper.setSubmergeLocked(false);
        if (this.sandSnapper.cactusEatCooldownTimer <= 0) {
            this.sandSnapper.cactusEatCooldownTimer = 200;
        }
    }

    public void tick() {
        if (this.sandSnapper.distanceToSqr(this.cactusPos) > (double)(this.eatRange * this.eatRange) && this.sandSnapper.getNavigation().isDone()) {
            if (this.sandSnapper.isEating()) {
                this.sandSnapper.setEating(false);
            }
            this.sandSnapper.getNavigation().moveTo(this.cactusPos.x, this.cactusPos.y, this.cactusPos.z, 1.0);
        } else if (this.sandSnapper.distanceToSqr(this.cactusPos) <= (double)(this.eatRange * this.eatRange) && !this.sandSnapper.isEating()) {
            this.sandSnapper.setEating(true);
            this.eatingTimer = 31;
        }
        if (this.sandSnapper.isEating()) {
            --this.eatingTimer;
            if (this.eatingTimer <= 0) {
                this.sandSnapper.setEating(false);
                this.sandSnapper.eatCactus(BlockPos.containing((Position)this.cactusPos));
                this.sandSnapper.cactusEatCooldownTimer = 6000;
            }
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean canUse() {
        if (this.sandSnapper.isOnCactusEatCooldown()) {
            return false;
        }
        ArrayList cactusPositions = new ArrayList();
        BlockPos.betweenClosed((int)(this.sandSnapper.blockPosition().getX() - this.horizontalRange), (int)(this.sandSnapper.blockPosition().getY() - this.verticalRange), (int)(this.sandSnapper.blockPosition().getZ() - this.horizontalRange), (int)(this.sandSnapper.blockPosition().getX() + this.horizontalRange), (int)(this.sandSnapper.blockPosition().getY() + this.verticalRange), (int)(this.sandSnapper.blockPosition().getZ() + this.horizontalRange)).forEach(p -> {
            BlockState state = this.sandSnapper.level().getBlockState(p);
            if (state.is((Block)BlockModule.PRICKLY_PEACH_CACTUS.get()) && ((Boolean)state.getValue((Property)PricklyPeachCactusBlock.FRUIT)).booleanValue()) {
                cactusPositions.add(new BlockPos((Vec3i)p));
            }
        });
        if (cactusPositions.isEmpty()) {
            return false;
        }
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.level()).getSandstormServerData();
        if (!sandstormServerData.isSandstormActive()) {
            for (BlockPos pos : cactusPositions) {
                Player nearestPlayer = this.sandSnapper.level().getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)this.playerDist, true);
                if (nearestPlayer != null) continue;
                this.cactusPos = Vec3.atCenterOf((Vec3i)pos);
                return true;
            }
        } else {
            this.cactusPos = Vec3.atCenterOf((Vec3i)((Vec3i)cactusPositions.get(0)));
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.sandSnapper.isOnCactusEatCooldown()) {
            return false;
        }
        BlockState state = this.sandSnapper.level().getBlockState(BlockPos.containing((Position)this.cactusPos));
        if (!state.is((Block)BlockModule.PRICKLY_PEACH_CACTUS.get()) || !((Boolean)state.getValue((Property)PricklyPeachCactusBlock.FRUIT)).booleanValue()) {
            return false;
        }
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.level()).getSandstormServerData();
        if (!sandstormServerData.isSandstormActive()) {
            Player nearestPlayer = this.sandSnapper.level().getNearestPlayer(this.cactusPos.x(), this.cactusPos.y(), this.cactusPos.z(), (double)this.playerDist, true);
            return nearestPlayer == null;
        }
        return true;
    }

    public boolean isInterruptable() {
        return false;
    }
}

