/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.util.DripstoneIceUtils;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DripstoneClusterConfiguration;

public class IcicleClusterFeature
extends Feature<DripstoneClusterConfiguration> {
    public IcicleClusterFeature(Codec<DripstoneClusterConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<DripstoneClusterConfiguration> featurePlaceContext) {
        WorldGenLevel worldGenLevel = featurePlaceContext.level();
        BlockPos origin = featurePlaceContext.origin();
        DripstoneClusterConfiguration config = (DripstoneClusterConfiguration)featurePlaceContext.config();
        RandomSource random = featurePlaceContext.random();
        if (!DripstoneIceUtils.isEmpty((LevelAccessor)worldGenLevel, origin)) {
            return false;
        }
        int height = config.height.sample(random);
        float wetness = config.wetness.sample(random);
        float density = config.density.sample(random);
        int uRadius = config.radius.sample(random);
        int vRadius = config.radius.sample(random);
        int uvRadiusMax = Math.max(uRadius, vRadius);
        float angle = random.nextFloat() * ((float)Math.PI * 2);
        float rx = Mth.cos((float)angle);
        float rz = Mth.sin((float)angle);
        float ux = rx / (float)uRadius;
        float uz = rz / (float)uRadius;
        float vx = rz / (float)vRadius;
        float vz = -rx / (float)vRadius;
        for (int xOffset = -uvRadiusMax; xOffset <= uvRadiusMax; ++xOffset) {
            for (int zOffset = -uvRadiusMax; zOffset <= uvRadiusMax; ++zOffset) {
                float ellipseDensity = Mth.square((float)((float)xOffset * ux + (float)zOffset * uz)) + Mth.square((float)((float)xOffset * vx + (float)zOffset * vz));
                if (ellipseDensity >= 1.0f) continue;
                float chanceOfStalagmiteOrStalactite = this.getChanceOfStalagmiteOrStalactite(ellipseDensity, uvRadiusMax, config);
                BlockPos blockPos2 = origin.offset(xOffset, 0, zOffset);
                this.placeColumn(worldGenLevel, random, blockPos2, xOffset, zOffset, wetness, chanceOfStalagmiteOrStalactite, height, density, config);
            }
        }
        return true;
    }

    private void placeColumn(WorldGenLevel worldGenLevel, RandomSource random, BlockPos blockPos, int xOffset, int zOffset, float wetness, double chance, int height, float density, DripstoneClusterConfiguration config) {
        Optional columnOptional = Column.scan((LevelSimulatedReader)worldGenLevel, (BlockPos)blockPos, (int)config.floorToCeilingSearchRange, DripstoneUtils::isEmptyOrWater, DripstoneUtils::isDripstoneBaseOrLava);
        if (columnOptional.isEmpty()) {
            return;
        }
        OptionalInt ceilingOptional = ((Column)columnOptional.get()).getCeiling();
        OptionalInt floorOptional = ((Column)columnOptional.get()).getFloor();
        if (ceilingOptional.isPresent() || floorOptional.isPresent()) {
            boolean q;
            int w;
            int p;
            int m;
            boolean n;
            int o;
            boolean bl2;
            Column column;
            boolean isWet;
            boolean bl = isWet = random.nextFloat() < wetness;
            if (isWet && floorOptional.isPresent() && this.canPlacePool(worldGenLevel, blockPos.atY(floorOptional.getAsInt()))) {
                int floor = floorOptional.getAsInt();
                column = ((Column)columnOptional.get()).withFloor(OptionalInt.of(floor - 1));
                worldGenLevel.setBlock(blockPos.atY(floor), Blocks.WATER.defaultBlockState(), 2);
            } else {
                column = (Column)columnOptional.get();
            }
            OptionalInt adjustedFloorOptional = column.getFloor();
            boolean bl3 = bl2 = random.nextDouble() < chance;
            if (ceilingOptional.isPresent() && bl2 && !this.isLava((LevelReader)worldGenLevel, blockPos.atY(ceilingOptional.getAsInt()))) {
                int thickness = config.dripstoneBlockLayerThickness.sample(random);
                this.replaceBlocksWithPackedIce(worldGenLevel, blockPos.atY(ceilingOptional.getAsInt()), thickness, Direction.UP);
                int n2 = adjustedFloorOptional.isPresent() ? Math.min(height, ceilingOptional.getAsInt() - adjustedFloorOptional.getAsInt()) : height;
                o = this.getDripstoneHeight(random, xOffset, zOffset, density, n2, config);
            } else {
                o = 0;
            }
            boolean bl4 = n = random.nextDouble() < chance;
            if (adjustedFloorOptional.isPresent() && n && !this.isLava((LevelReader)worldGenLevel, blockPos.atY(adjustedFloorOptional.getAsInt()))) {
                int thickness = config.dripstoneBlockLayerThickness.sample(random);
                this.replaceBlocksWithPackedIce(worldGenLevel, blockPos.atY(adjustedFloorOptional.getAsInt()), thickness, Direction.DOWN);
                m = ceilingOptional.isPresent() ? Math.max(0, o + Mth.randomBetweenInclusive((RandomSource)random, (int)(-config.maxStalagmiteStalactiteHeightDiff), (int)config.maxStalagmiteStalactiteHeightDiff)) : this.getDripstoneHeight(random, xOffset, zOffset, density, height, config);
            } else {
                m = 0;
            }
            if (ceilingOptional.isPresent() && adjustedFloorOptional.isPresent() && ceilingOptional.getAsInt() - o <= adjustedFloorOptional.getAsInt() + m) {
                int adjustedFloor = adjustedFloorOptional.getAsInt();
                int adjustedCeiling = ceilingOptional.getAsInt();
                int s = Math.max(adjustedCeiling - o, adjustedFloor + 1);
                int t = Math.min(adjustedFloor + m, adjustedCeiling - 1);
                int u = Mth.randomBetweenInclusive((RandomSource)random, (int)s, (int)(t + 1));
                int v = u - 1;
                p = adjustedCeiling - u;
                w = v - adjustedFloor;
            } else {
                p = o;
                w = m;
            }
            boolean bl5 = q = random.nextBoolean() && p > 0 && w > 0 && column.getHeight().isPresent() && p + w == column.getHeight().getAsInt();
            if (ceilingOptional.isPresent()) {
                DripstoneIceUtils.growIcicle((LevelAccessor)worldGenLevel, blockPos.atY(ceilingOptional.getAsInt() - 1), Direction.DOWN, p, q);
            }
        }
    }

    private boolean isLava(LevelReader levelReader, BlockPos blockPos) {
        return levelReader.getBlockState(blockPos).is(Blocks.LAVA);
    }

    private int getDripstoneHeight(RandomSource random, int xOffset, int zOffset, float density, int height, DripstoneClusterConfiguration config) {
        if (random.nextFloat() > density) {
            return 0;
        }
        int l = Math.abs(xOffset) + Math.abs(zOffset);
        float g = (float)Mth.clampedMap((double)l, (double)0.0, (double)config.maxDistanceFromCenterAffectingHeightBias, (double)((double)height / 2.0), (double)0.0);
        return (int)IcicleClusterFeature.randomBetweenBiased(random, 0.0f, height, g, config.heightDeviation);
    }

    private boolean canPlacePool(WorldGenLevel worldGenLevel, BlockPos blockPos) {
        BlockState blockState = worldGenLevel.getBlockState(blockPos);
        if (!(blockState.is(Blocks.WATER) || blockState.is(Blocks.DRIPSTONE_BLOCK) || blockState.is(Blocks.POINTED_DRIPSTONE))) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (this.canBeAdjacentToWater((LevelAccessor)worldGenLevel, blockPos.relative(direction))) continue;
                return false;
            }
            return this.canBeAdjacentToWater((LevelAccessor)worldGenLevel, blockPos.below());
        }
        return false;
    }

    private boolean canBeAdjacentToWater(LevelAccessor levelAccessor, BlockPos blockPos) {
        BlockState blockState = levelAccessor.getBlockState(blockPos);
        return blockState.is(BlockTags.BASE_STONE_OVERWORLD) || blockState.getFluidState().is(FluidTags.WATER);
    }

    private void replaceBlocksWithPackedIce(WorldGenLevel worldGenLevel, BlockPos blockPos, int length, Direction direction) {
        BlockPos.MutableBlockPos mutableBlockPos = blockPos.mutable();
        for (int i = 0; i < length; ++i) {
            if (!DripstoneIceUtils.placePackedIceIfPossible((LevelAccessor)worldGenLevel, (BlockPos)mutableBlockPos)) {
                return;
            }
            mutableBlockPos.move(direction);
        }
    }

    private float getChanceOfStalagmiteOrStalactite(float ellipseDensity, float uvRadiusMax, DripstoneClusterConfiguration config) {
        return Mth.clampedMap((float)(ellipseDensity * (uvRadiusMax * uvRadiusMax)), (float)(uvRadiusMax * uvRadiusMax), (float)config.maxDistanceFromEdgeAffectingChanceOfDripstoneColumn, (float)config.chanceOfDripstoneColumnAtMaxDistanceFromCenter, (float)1.0f);
    }

    private static float randomBetweenBiased(RandomSource random, float f, float g, float h, float i) {
        return ClampedNormalFloat.sample((RandomSource)random, (float)h, (float)i, (float)f, (float)g);
    }
}

