/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.client.render.sandstorm;

import com.yungnickyoung.minecraft.yungscavebiomes.YungsCaveBiomesCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BiomeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.ParticleTypeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.util.DistributionUtils;
import com.yungnickyoung.minecraft.yungscavebiomes.world.noise.OpenSimplex2S;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class SandstormClientData {
    private static final double SANDSTORM_NOISE_FREQUENCY_Y_RELATIVE = 0.3333333333333333;
    private static final double SANDSTORM_NOISE_FREQUENCY_XZ = 0.0078125;
    private static final double SANDSTORM_NOISE_FREQUENCY_Y = 0.0026041666666666665;
    private static final double SANDSTORM_NOISE_FREQUENCY_TIME = 0.0013020833333333333;
    private static final float SANDSTORM_PARTICLE_SPEED_SCALAR_Y_RELATIVE = 0.33333334f;
    private static final float SANDSTORM_PARTICLE_SPEED_SCALAR_XZ = 0.9f;
    private static final float SANDSTORM_PARTICLE_SPEED_SCALAR_Y = 0.3f;
    private static final long SEED_2_OFFSET = 7160011195410019394L;
    private boolean isSandstormActive = false;
    private int sandstormTime = 0;
    private int totalSandstormDuration = 0;
    private long sandstormSeed;

    public Vector3f getSandstormParticleSpeedVector(double worldX, double worldY, double worldZ, Vector3f prevParticleSpeedVector) {
        Vector3f output = new Vector3f((Vector3fc)prevParticleSpeedVector);
        Vector4f noise4GradientA = new Vector4f();
        Vector4f noise4GradientB = new Vector4f();
        OpenSimplex2S.noise4Grad_ImproveXYZ_ImproveXZ(this.sandstormSeed, worldX * 0.0078125, worldY * 0.0026041666666666665, worldZ * 0.0078125, (double)this.sandstormTime * 0.0013020833333333333, noise4GradientA);
        OpenSimplex2S.noise4Grad_ImproveXYZ_ImproveXZ(this.sandstormSeed + 7160011195410019394L, worldX * 0.0078125, worldY * 0.0026041666666666665, worldZ * 0.0078125, (double)this.sandstormTime * 0.0013020833333333333, noise4GradientB);
        output.set(noise4GradientA.y() * noise4GradientB.z() - noise4GradientA.z() * noise4GradientB.y(), noise4GradientA.z() * noise4GradientB.x() - noise4GradientA.x() * noise4GradientB.z(), noise4GradientA.x() * noise4GradientB.y() - noise4GradientA.y() * noise4GradientB.x());
        output.mul(0.9f, 0.3f, 0.9f);
        output.normalize();
        output.mul(0.9f, 0.3f, 0.9f);
        if (this.sandstormTime > this.totalSandstormDuration - 20) {
            output.mul((float)(this.totalSandstormDuration - this.sandstormTime) / 20.0f, (float)(this.totalSandstormDuration - this.sandstormTime) / 20.0f, (float)(this.totalSandstormDuration - this.sandstormTime) / 20.0f);
        }
        return output;
    }

    public void tick() {
        if (YungsCaveBiomesCommon.DEBUG_LOG) {
            YungsCaveBiomesCommon.LOGGER.info("Sandstorm CLIENT {} / {} time", (Object)this.sandstormTime, (Object)this.totalSandstormDuration);
        }
        if (this.isSandstormActive) {
            if (this.sandstormTime > 0) {
                --this.sandstormTime;
            } else {
                this.isSandstormActive = false;
            }
        }
    }

    public void addSandstormParticles(class_638 clientLevel, int x, int y, int z, int maxDistance, class_5819 random, class_2338.class_2339 pos) {
        if (!this.isSandstormActive) {
            return;
        }
        double chance = class_3532.method_15350((double)class_3532.method_16436((double)((double)(this.totalSandstormDuration - this.sandstormTime) / 20.0), (double)0.0, (double)0.03), (double)0.0, (double)0.03);
        if (random.method_43058() > chance) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        boolean isPlayerInLostCaves = clientLevel.method_23753(player.method_24515()).method_40225(BiomeModule.LOST_CAVES);
        if (!isPlayerInLostCaves) {
            return;
        }
        this.addSandstormParticle(clientLevel, x, y, z, false, maxDistance, random, pos);
    }

    public void addExtraSandstormParticles(class_638 clientLevel, int x, int y, int z) {
        if (!YungsCaveBiomesCommon.CONFIG.lostCaves.extraSandstormParticles) {
            return;
        }
        if (!this.isSandstormActive) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        boolean isPlayerInLostCaves = clientLevel.method_23753(player.method_24515()).method_40225(BiomeModule.LOST_CAVES);
        if (!isPlayerInLostCaves) {
            return;
        }
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int i = 0; i < 667; ++i) {
            double chance = class_3532.method_15350((double)class_3532.method_16436((double)((double)(this.totalSandstormDuration - this.sandstormTime) / 20.0), (double)0.0, (double)0.03), (double)0.0, (double)0.03);
            if (clientLevel.method_8409().method_43058() > chance) continue;
            this.addSandstormParticle(clientLevel, x, y, z, true, 64, clientLevel.method_8409(), mutable);
        }
    }

    private void addSandstormParticle(class_638 clientLevel, int x, int y, int z, boolean overrideLimiter, int maxDistance, class_5819 random, class_2338.class_2339 pos) {
        Vector3d particlePos = DistributionUtils.ellipsoidCenterBiasedSpread(maxDistance, maxDistance, random, Vector3d::new);
        particlePos.x += (double)x;
        particlePos.y += (double)y;
        particlePos.z += (double)z;
        pos.method_10103(class_3532.method_15357((double)particlePos.x), class_3532.method_15357((double)particlePos.y), class_3532.method_15357((double)particlePos.z));
        class_2680 blockState = clientLevel.method_8320((class_2338)pos);
        if (blockState.method_26215()) {
            clientLevel.method_8466((class_2394)ParticleTypeModule.SANDSTORM.get(), overrideLimiter, particlePos.x, particlePos.y, particlePos.z, 0.0, 0.0, 0.0);
        }
    }

    public boolean isSandstormActive() {
        return this.isSandstormActive;
    }

    public void setSandstormActive(boolean sandstormActive) {
        this.isSandstormActive = sandstormActive;
    }

    public void setSandstormTime(int time) {
        this.sandstormTime = time;
    }

    public void setSandstormSeed(long sandstormSeed) {
        this.sandstormSeed = sandstormSeed;
    }

    public void setTotalSandstormDuration(int totalSandstormDuration) {
        this.totalSandstormDuration = totalSandstormDuration;
    }
}

