/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.yungscavebiomes.module.TrimPatternsModule;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8055;
import net.minecraft.class_8056;
import net.minecraft.class_9334;

public class DebugSpawnArmorTrimsCommand {
    private static final Map<Pair<class_6880<class_1741>, class_1304>, class_1792> MATERIAL_AND_SLOT_TO_ITEM = (Map)class_156.method_654((Object)Maps.newHashMap(), $$0 -> {
        $$0.put(Pair.of((Object)class_1740.field_7887, (Object)class_1304.field_6169), class_1802.field_8283);
        $$0.put(Pair.of((Object)class_1740.field_7887, (Object)class_1304.field_6174), class_1802.field_8873);
        $$0.put(Pair.of((Object)class_1740.field_7887, (Object)class_1304.field_6172), class_1802.field_8218);
        $$0.put(Pair.of((Object)class_1740.field_7887, (Object)class_1304.field_6166), class_1802.field_8313);
        $$0.put(Pair.of((Object)class_1740.field_7892, (Object)class_1304.field_6169), class_1802.field_8743);
        $$0.put(Pair.of((Object)class_1740.field_7892, (Object)class_1304.field_6174), class_1802.field_8523);
        $$0.put(Pair.of((Object)class_1740.field_7892, (Object)class_1304.field_6172), class_1802.field_8396);
        $$0.put(Pair.of((Object)class_1740.field_7892, (Object)class_1304.field_6166), class_1802.field_8660);
        $$0.put(Pair.of((Object)class_1740.field_7895, (Object)class_1304.field_6169), class_1802.field_8862);
        $$0.put(Pair.of((Object)class_1740.field_7895, (Object)class_1304.field_6174), class_1802.field_8678);
        $$0.put(Pair.of((Object)class_1740.field_7895, (Object)class_1304.field_6172), class_1802.field_8416);
        $$0.put(Pair.of((Object)class_1740.field_7895, (Object)class_1304.field_6166), class_1802.field_8753);
        $$0.put(Pair.of((Object)class_1740.field_21977, (Object)class_1304.field_6169), class_1802.field_22027);
        $$0.put(Pair.of((Object)class_1740.field_21977, (Object)class_1304.field_6174), class_1802.field_22028);
        $$0.put(Pair.of((Object)class_1740.field_21977, (Object)class_1304.field_6172), class_1802.field_22029);
        $$0.put(Pair.of((Object)class_1740.field_21977, (Object)class_1304.field_6166), class_1802.field_22030);
        $$0.put(Pair.of((Object)class_1740.field_7889, (Object)class_1304.field_6169), class_1802.field_8805);
        $$0.put(Pair.of((Object)class_1740.field_7889, (Object)class_1304.field_6174), class_1802.field_8058);
        $$0.put(Pair.of((Object)class_1740.field_7889, (Object)class_1304.field_6172), class_1802.field_8348);
        $$0.put(Pair.of((Object)class_1740.field_7889, (Object)class_1304.field_6166), class_1802.field_8285);
        $$0.put(Pair.of((Object)class_1740.field_7890, (Object)class_1304.field_6169), class_1802.field_8090);
    });
    private static final Map<class_1741, Map<class_1304, class_1792>> MAP = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
        Map chainMap = (Map)class_156.method_654((Object)Maps.newHashMap(), m -> {
            m.put(class_1304.field_6169, class_1802.field_8283);
            m.put(class_1304.field_6174, class_1802.field_8873);
            m.put(class_1304.field_6172, class_1802.field_8218);
            m.put(class_1304.field_6166, class_1802.field_8313);
        });
        map.put((class_1741)class_1740.field_7887.comp_349(), chainMap);
        Map ironMap = (Map)class_156.method_654((Object)Maps.newHashMap(), m -> {
            m.put(class_1304.field_6169, class_1802.field_8743);
            m.put(class_1304.field_6174, class_1802.field_8523);
            m.put(class_1304.field_6172, class_1802.field_8396);
            m.put(class_1304.field_6166, class_1802.field_8660);
        });
        map.put((class_1741)class_1740.field_7892.comp_349(), ironMap);
        Map goldMap = (Map)class_156.method_654((Object)Maps.newHashMap(), m -> {
            m.put(class_1304.field_6169, class_1802.field_8862);
            m.put(class_1304.field_6174, class_1802.field_8678);
            m.put(class_1304.field_6172, class_1802.field_8416);
            m.put(class_1304.field_6166, class_1802.field_8753);
        });
        map.put((class_1741)class_1740.field_7895.comp_349(), goldMap);
        Map netheriteMap = (Map)class_156.method_654((Object)Maps.newHashMap(), m -> {
            m.put(class_1304.field_6169, class_1802.field_22027);
            m.put(class_1304.field_6174, class_1802.field_22028);
            m.put(class_1304.field_6172, class_1802.field_22029);
            m.put(class_1304.field_6166, class_1802.field_22030);
        });
        map.put((class_1741)class_1740.field_21977.comp_349(), netheriteMap);
        Map diamondMap = (Map)class_156.method_654((Object)Maps.newHashMap(), m -> {
            m.put(class_1304.field_6169, class_1802.field_8805);
            m.put(class_1304.field_6174, class_1802.field_8058);
            m.put(class_1304.field_6172, class_1802.field_8348);
            m.put(class_1304.field_6166, class_1802.field_8285);
        });
        map.put((class_1741)class_1740.field_7889.comp_349(), diamondMap);
        Map turtleMap = (Map)class_156.method_654((Object)Maps.newHashMap(), m -> m.put(class_1304.field_6169, class_1802.field_8090));
        map.put((class_1741)class_1740.field_7890.comp_349(), turtleMap);
    });
    private static final List<class_5321<class_8056>> TRIM_PATTERNS = List.of(TrimPatternsModule.ANCIENT);
    private static final List<class_5321<class_8054>> TRIM_MATERIALS = List.of(class_8055.field_42004, class_8055.field_42005, class_8055.field_42006, class_8055.field_42007, class_8055.field_42008, class_8055.field_42009, class_8055.field_42010, class_8055.field_42011, class_8055.field_42012, class_8055.field_42013);
    private static final ToIntFunction<class_5321<class_8056>> TRIM_PATTERN_ORDER = class_156.method_43658(TRIM_PATTERNS);
    private static final ToIntFunction<class_5321<class_8054>> TRIM_MATERIAL_ORDER = class_156.method_43658(TRIM_MATERIALS);

    private static class_1792 getArmorItem(class_1741 material, class_1304 slot) {
        Map<class_1304, class_1792> slotMap = MAP.get(material);
        if (slotMap != null) {
            return slotMap.get(slot);
        }
        return null;
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 ctx, class_2170.class_5364 selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ycb_armor_trims").requires(source -> source.method_9259(2))).executes(context -> DebugSpawnArmorTrimsCommand.spawnArmorTrims((class_2168)context.getSource(), (class_1657)((class_2168)context.getSource()).method_9207())));
    }

    private static int spawnArmorTrims(class_2168 source, class_1657 player) {
        class_1937 level = player.method_37908();
        class_2371 armorTrims = class_2371.method_10211();
        class_2378 trimPatternRegistry = level.method_30349().method_30530(class_7924.field_42082);
        class_2378 trimMaterialRegistry = level.method_30349().method_30530(class_7924.field_42083);
        trimPatternRegistry.method_10220().filter(pattern -> pattern.comp_1213().method_12836().equals("yungscavebiomes")).sorted(Comparator.comparing(p -> TRIM_PATTERN_ORDER.applyAsInt((class_5321<class_8056>)((class_5321)trimPatternRegistry.method_29113(p).orElse(null))))).forEachOrdered(p -> trimMaterialRegistry.method_10220().sorted(Comparator.comparing(m -> TRIM_MATERIAL_ORDER.applyAsInt((class_5321<class_8054>)((class_5321)trimMaterialRegistry.method_29113(m).orElse(null))))).forEachOrdered(m -> armorTrims.add((Object)new class_8053(trimMaterialRegistry.method_47983(m), trimPatternRegistry.method_47983(p)))));
        class_2338 pos = player.method_24515().method_10079(player.method_5735(), 5);
        class_2378 armorMaterialRegistry = source.method_30497().method_30530(class_7924.field_48977);
        int numMats = armorMaterialRegistry.method_10204() - 1;
        double $$8 = 3.0;
        int trimIndex = 0;
        int materialIndex = 0;
        for (class_8053 trim : armorTrims) {
            for (class_1741 material : armorMaterialRegistry) {
                if (material == class_1740.field_7897.comp_349()) continue;
                double x = (double)pos.method_10263() + 0.5 - (double)(trimIndex % trimMaterialRegistry.method_10204()) * 3.0;
                double y = (double)pos.method_10264() + 0.5 + (double)(materialIndex % numMats) * 3.0;
                double z = (double)pos.method_10260() + 0.5 + (double)(trimIndex / trimMaterialRegistry.method_10204() * 10);
                class_1531 armorStand = new class_1531(level, x, y, z);
                armorStand.method_36456(180.0f);
                armorStand.method_5875(true);
                for (class_1304 slot : class_1304.values()) {
                    class_1738 $$20;
                    class_1792 armorItem = DebugSpawnArmorTrimsCommand.getArmorItem(material, slot);
                    if (armorItem == null) continue;
                    class_1799 armorItemStack = new class_1799((class_1935)armorItem);
                    armorItemStack.method_57379(class_9334.field_49607, (Object)trim);
                    armorStand.method_5673(slot, armorItemStack);
                    if (armorItem instanceof class_1738 && ($$20 = (class_1738)armorItem).method_7686() == class_1740.field_7890) {
                        armorStand.method_5665((class_2561)((class_8056)trim.method_48424().comp_349()).method_48446(trim.method_48431()).method_27661().method_27693(" ").method_10852(((class_8054)trim.method_48431().comp_349()).comp_1212()));
                        armorStand.method_5880(true);
                        continue;
                    }
                    armorStand.method_5648(true);
                }
                level.method_8649((class_1297)armorStand);
                ++materialIndex;
            }
            ++trimIndex;
        }
        source.method_9226(() -> class_2561.method_43470((String)"Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }
}

