/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.util.DripstoneIceUtils;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5721;
import net.minecraft.class_5726;
import net.minecraft.class_5731;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5861;

public class IcicleClusterFeature
extends class_3031<class_5731> {
    public IcicleClusterFeature(Codec<class_5731> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_5731> featurePlaceContext) {
        class_5281 worldGenLevel = featurePlaceContext.method_33652();
        class_2338 origin = featurePlaceContext.method_33655();
        class_5731 config = (class_5731)featurePlaceContext.method_33656();
        class_5819 random = featurePlaceContext.method_33654();
        if (!DripstoneIceUtils.isEmpty((class_1936)worldGenLevel, origin)) {
            return false;
        }
        int height = config.field_28215.method_35008(random);
        float wetness = config.field_28221.method_33920(random);
        float density = config.field_28220.method_33920(random);
        int uRadius = config.field_28216.method_35008(random);
        int vRadius = config.field_28216.method_35008(random);
        int uvRadiusMax = Math.max(uRadius, vRadius);
        float angle = random.method_43057() * ((float)Math.PI * 2);
        float rx = class_3532.method_15362((float)angle);
        float rz = class_3532.method_15374((float)angle);
        float ux = rx / (float)uRadius;
        float uz = rz / (float)uRadius;
        float vx = rz / (float)vRadius;
        float vz = -rx / (float)vRadius;
        for (int xOffset = -uvRadiusMax; xOffset <= uvRadiusMax; ++xOffset) {
            for (int zOffset = -uvRadiusMax; zOffset <= uvRadiusMax; ++zOffset) {
                float ellipseDensity = class_3532.method_27285((float)((float)xOffset * ux + (float)zOffset * uz)) + class_3532.method_27285((float)((float)xOffset * vx + (float)zOffset * vz));
                if (ellipseDensity >= 1.0f) continue;
                float chanceOfStalagmiteOrStalactite = this.getChanceOfStalagmiteOrStalactite(ellipseDensity, uvRadiusMax, config);
                class_2338 blockPos2 = origin.method_10069(xOffset, 0, zOffset);
                this.placeColumn(worldGenLevel, random, blockPos2, xOffset, zOffset, wetness, chanceOfStalagmiteOrStalactite, height, density, config);
            }
        }
        return true;
    }

    private void placeColumn(class_5281 worldGenLevel, class_5819 random, class_2338 blockPos, int xOffset, int zOffset, float wetness, double chance, int height, float density, class_5731 config) {
        Optional columnOptional = class_5721.method_32982((class_3746)worldGenLevel, (class_2338)blockPos, (int)config.field_28214, class_5726::method_33014, class_5726::method_33387);
        if (columnOptional.isEmpty()) {
            return;
        }
        OptionalInt ceilingOptional = ((class_5721)columnOptional.get()).method_32985();
        OptionalInt floorOptional = ((class_5721)columnOptional.get()).method_32987();
        if (ceilingOptional.isPresent() || floorOptional.isPresent()) {
            boolean q;
            int w;
            int p;
            int m;
            boolean n;
            int o;
            boolean bl2;
            class_5721 column;
            boolean isWet;
            boolean bl = isWet = random.method_43057() < wetness;
            if (isWet && floorOptional.isPresent() && this.canPlacePool(worldGenLevel, blockPos.method_33096(floorOptional.getAsInt()))) {
                int floor = floorOptional.getAsInt();
                column = ((class_5721)columnOptional.get()).method_32983(OptionalInt.of(floor - 1));
                worldGenLevel.method_8652(blockPos.method_33096(floor), class_2246.field_10382.method_9564(), 2);
            } else {
                column = (class_5721)columnOptional.get();
            }
            OptionalInt adjustedFloorOptional = column.method_32987();
            boolean bl3 = bl2 = random.method_43058() < chance;
            if (ceilingOptional.isPresent() && bl2 && !this.isLava((class_4538)worldGenLevel, blockPos.method_33096(ceilingOptional.getAsInt()))) {
                int thickness = config.field_28219.method_35008(random);
                this.replaceBlocksWithPackedIce(worldGenLevel, blockPos.method_33096(ceilingOptional.getAsInt()), thickness, class_2350.field_11036);
                int n2 = adjustedFloorOptional.isPresent() ? Math.min(height, ceilingOptional.getAsInt() - adjustedFloorOptional.getAsInt()) : height;
                o = this.getDripstoneHeight(random, xOffset, zOffset, density, n2, config);
            } else {
                o = 0;
            }
            boolean bl4 = n = random.method_43058() < chance;
            if (adjustedFloorOptional.isPresent() && n && !this.isLava((class_4538)worldGenLevel, blockPos.method_33096(adjustedFloorOptional.getAsInt()))) {
                int thickness = config.field_28219.method_35008(random);
                this.replaceBlocksWithPackedIce(worldGenLevel, blockPos.method_33096(adjustedFloorOptional.getAsInt()), thickness, class_2350.field_11033);
                m = ceilingOptional.isPresent() ? Math.max(0, o + class_3532.method_32751((class_5819)random, (int)(-config.field_28217), (int)config.field_28217)) : this.getDripstoneHeight(random, xOffset, zOffset, density, height, config);
            } else {
                m = 0;
            }
            if (ceilingOptional.isPresent() && adjustedFloorOptional.isPresent() && ceilingOptional.getAsInt() - o <= adjustedFloorOptional.getAsInt() + m) {
                int adjustedFloor = adjustedFloorOptional.getAsInt();
                int adjustedCeiling = ceilingOptional.getAsInt();
                int s = Math.max(adjustedCeiling - o, adjustedFloor + 1);
                int t = Math.min(adjustedFloor + m, adjustedCeiling - 1);
                int u = class_3532.method_32751((class_5819)random, (int)s, (int)(t + 1));
                int v = u - 1;
                p = adjustedCeiling - u;
                w = v - adjustedFloor;
            } else {
                p = o;
                w = m;
            }
            boolean bl5 = q = random.method_43056() && p > 0 && w > 0 && column.method_33385().isPresent() && p + w == column.method_33385().getAsInt();
            if (ceilingOptional.isPresent()) {
                DripstoneIceUtils.growIcicle((class_1936)worldGenLevel, blockPos.method_33096(ceilingOptional.getAsInt() - 1), class_2350.field_11033, p, q);
            }
        }
    }

    private boolean isLava(class_4538 levelReader, class_2338 blockPos) {
        return levelReader.method_8320(blockPos).method_27852(class_2246.field_10164);
    }

    private int getDripstoneHeight(class_5819 random, int xOffset, int zOffset, float density, int height, class_5731 config) {
        if (random.method_43057() > density) {
            return 0;
        }
        int l = Math.abs(xOffset) + Math.abs(zOffset);
        float g = (float)class_3532.method_32854((double)l, (double)0.0, (double)config.field_28226, (double)((double)height / 2.0), (double)0.0);
        return (int)IcicleClusterFeature.randomBetweenBiased(random, 0.0f, height, g, config.field_28218);
    }

    private boolean canPlacePool(class_5281 worldGenLevel, class_2338 blockPos) {
        class_2680 blockState = worldGenLevel.method_8320(blockPos);
        if (!(blockState.method_27852(class_2246.field_10382) || blockState.method_27852(class_2246.field_28049) || blockState.method_27852(class_2246.field_28048))) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                if (this.canBeAdjacentToWater((class_1936)worldGenLevel, blockPos.method_10093(direction))) continue;
                return false;
            }
            return this.canBeAdjacentToWater((class_1936)worldGenLevel, blockPos.method_10074());
        }
        return false;
    }

    private boolean canBeAdjacentToWater(class_1936 levelAccessor, class_2338 blockPos) {
        class_2680 blockState = levelAccessor.method_8320(blockPos);
        return blockState.method_26164(class_3481.field_25806) || blockState.method_26227().method_15767(class_3486.field_15517);
    }

    private void replaceBlocksWithPackedIce(class_5281 worldGenLevel, class_2338 blockPos, int length, class_2350 direction) {
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        for (int i = 0; i < length; ++i) {
            if (!DripstoneIceUtils.placePackedIceIfPossible((class_1936)worldGenLevel, (class_2338)mutableBlockPos)) {
                return;
            }
            mutableBlockPos.method_10098(direction);
        }
    }

    private float getChanceOfStalagmiteOrStalactite(float ellipseDensity, float uvRadiusMax, class_5731 config) {
        return class_3532.method_37958((float)(ellipseDensity * (uvRadiusMax * uvRadiusMax)), (float)(uvRadiusMax * uvRadiusMax), (float)config.field_28225, (float)config.field_28224, (float)1.0f);
    }

    private static float randomBetweenBiased(class_5819 random, float f, float g, float h, float i) {
        return class_5861.method_33903((class_5819)random, (float)h, (float)i, (float)f, (float)g);
    }
}

