/*
 * Decompiled with CFR 0.152.
 */
package bre.ufex;

import bre.ufex.FontPixels;
import bre.ufex.FontRendererHook;
import bre.ufex.FontTextureManager;
import bre.ufex.FontUtils;
import bre.ufex.ModConfig;
import bre.ufex.util.Logger;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.CharUtils;

public class FontRasterizer {
    private static FontRasterizer INSTANCE = new FontRasterizer();
    private int fontRes;
    private int fontGap;
    private Font font;
    private boolean antiAlias;
    private boolean fractionalMetrics;
    private int fontDouble;
    private Font secondaryFont;
    private Font defaultFont;
    private BufferedImage[] fontImageCache = new BufferedImage[256];
    private byte[][] fontPngImageCache = new byte[256][];
    private BufferedImage blankImage;
    public static final float fontSizeAdjustmentRate = 0.05f;

    public FontRasterizer() {
        if (ModConfig.useOSFont) {
            this.setFont(ModConfig.fontName, ModConfig.secondaryFontName, FontUtils.getFontRes(ModConfig.fontResIndex), ModConfig.fontGap, ModConfig.fontSizeAdjustment, ModConfig.fontAntiAliasEx, ModConfig.fontDouble);
        }
    }

    public void setFont(String fontName, String secondaryFontName, int fontRes, int fontGap, int fontSizeAdjustment, int antiAlias, int fontDouble) {
        this.antiAlias = antiAlias >= 1;
        this.fractionalMetrics = antiAlias >= 2;
        this.fontDouble = fontDouble;
        this.fontGap = fontGap;
        this.fontRes = fontRes;
        this.font = new Font(fontName, 0, fontRes);
        float pointSize = this.getMaxPointSize(this.font, fontRes);
        pointSize += pointSize * 0.05f * (float)fontSizeAdjustment;
        this.font = this.font.deriveFont(pointSize);
        this.secondaryFont = new Font(secondaryFontName, 0, fontRes);
        pointSize = this.getMaxPointSize(this.secondaryFont, fontRes);
        pointSize += pointSize * 0.05f * (float)fontSizeAdjustment;
        this.secondaryFont = this.secondaryFont.deriveFont(pointSize);
        this.defaultFont = new Font("SansSerif", 0, fontRes);
        pointSize = this.getMaxPointSize(this.defaultFont, fontRes);
        pointSize += pointSize * 0.05f * (float)fontSizeAdjustment;
        this.defaultFont = this.defaultFont.deriveFont(pointSize);
        int border = FontUtils.getBorderWidth(fontRes);
        int imageWidth = (fontRes + border) * 16;
        this.blankImage = new BufferedImage(imageWidth, imageWidth, 12);
        this.clearFontCache();
        FontTextureManager.getInstance().clearMapTextureObjects();
        this.createFontCacheAll();
    }

    public void clearFontCache() {
        for (int i = 0; i < 256; ++i) {
            this.fontImageCache[i] = null;
            this.fontPngImageCache[i] = null;
        }
    }

    public void createFontCacheAll() {
        this.clearFontCache();
        for (int i = 0; i < 256; ++i) {
            this.getFontImage(i);
        }
    }

    public static FontRasterizer getInstance() {
        return INSTANCE;
    }

    private float getMaxPointSize(Font font, int pixelSize) {
        float pointSize;
        if (ModConfig.fontAutoSizing) {
            BufferedImage testImage = new BufferedImage(128, 128, 6);
            Graphics2D g2 = testImage.createGraphics();
            g2.setFont(font);
            FontMetrics fm = g2.getFontMetrics();
            FontPixels fp = new FontPixels(font, fm, this.antiAlias, this.fractionalMetrics);
            pointSize = fp.getFittedSize(pixelSize);
            g2.dispose();
        } else {
            pointSize = pixelSize;
        }
        return pointSize;
    }

    public BufferedImage getFontImage(int page) {
        BufferedImage fontImage;
        if (!ModConfig.compressCache) {
            if (this.fontImageCache[page] != null) {
                return this.fontImageCache[page];
            }
        } else if (this.fontPngImageCache[page] != null) {
            return this.getImageFromBytes(this.fontPngImageCache[page]);
        }
        float scaleFactor = (float)this.fontRes / 16.0f;
        int border = FontUtils.getBorderWidth(this.fontRes);
        int imageWidth = (this.fontRes + border) * 16;
        byte[] glyphWidth = FontTextureManager.getInstance().getGlyphWidth();
        if (this.antiAlias || ModConfig.debug) {
            fontImage = new BufferedImage(imageWidth, imageWidth, 6);
        } else {
            byte[] r = new byte[]{-1, -1};
            byte[] g = new byte[]{-1, -1};
            byte[] b = new byte[]{-1, -1};
            byte[] a = new byte[]{0, -1};
            IndexColorModel icm = new IndexColorModel(1, 2, r, g, b, a);
            fontImage = new BufferedImage(imageWidth, imageWidth, 12, icm);
        }
        Graphics2D g2 = fontImage.createGraphics();
        this.setAntiAlias(g2);
        g2.setFont(this.secondaryFont);
        FontMetrics secondaryFontMetrics = g2.getFontMetrics();
        FontPixels secondaryFp = new FontPixels(this.secondaryFont, secondaryFontMetrics, this.antiAlias, this.fractionalMetrics);
        float secondaryBaseY = (float)secondaryFp.getAscent();
        g2.setFont(this.defaultFont);
        FontMetrics defaultFontMetrics = g2.getFontMetrics();
        FontPixels defaultFp = new FontPixels(this.defaultFont, defaultFontMetrics, this.antiAlias, this.fractionalMetrics);
        float defaultBaseY = (float)defaultFp.getAscent();
        g2.setFont(this.font);
        FontMetrics fm = g2.getFontMetrics();
        FontPixels fp = new FontPixels(this.font, fm, this.antiAlias, this.fractionalMetrics);
        float baseY = (float)fp.getAscent();
        int leftMargin = 0;
        int startColumn = 0;
        int endColumn = 0;
        int zeroSideMargin = border / 2;
        float sizeMargin = (float)(-this.fontRes * ModConfig.fontSizeAdjustment) * 0.05f / 2.0f;
        float fontGapAdjWidth = (float)(-this.fontGap) * (float)this.fontRes / 16.0f;
        int noFontCnt = 0;
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, this.antiAlias, this.fractionalMetrics);
        int chBase = page << 8;
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                GlyphMetrics gm;
                float chWidth;
                float posY = baseY;
                g2.setFont(this.font);
                char ch = (char)(chBase + y * 16 + x);
                Font fontWork = this.font;
                if (!this.font.canDisplay(ch)) {
                    if (this.secondaryFont.canDisplay(ch)) {
                        g2.setFont(this.secondaryFont);
                        posY = secondaryBaseY;
                        fontWork = this.secondaryFont;
                    } else {
                        g2.setFont(this.defaultFont);
                        posY = defaultBaseY;
                        fontWork = this.defaultFont;
                        if (!this.defaultFont.canDisplay(ch)) {
                            ++noFontCnt;
                        }
                    }
                }
                if ((chWidth = (gm = fontWork.createGlyphVector(frc, String.valueOf(ch)).getGlyphMetrics(0)).getAdvanceX()) != 0.0f) {
                    if ((chWidth -= fontGapAdjWidth) < 0.01f) {
                        chWidth = 0.01f;
                    }
                    switch (this.fontRes) {
                        case 10: {
                            leftMargin = chWidth > 3.0f ? 0 : 5;
                            break;
                        }
                        case 12: 
                        case 24: 
                        case 48: {
                            leftMargin = (int)(((float)this.fontRes - chWidth) / 2.0f / 3.0f) * 3;
                            break;
                        }
                        case 32: {
                            leftMargin = (int)(((float)this.fontRes - chWidth) / 2.0f / 2.0f) * 2;
                            break;
                        }
                        case 64: {
                            leftMargin = (int)(((float)this.fontRes - chWidth) / 2.0f / 4.0f) * 4;
                            break;
                        }
                        default: {
                            leftMargin = (int)(((float)this.fontRes - chWidth) / 2.0f);
                        }
                    }
                    posY = (int)posY;
                    g2.drawString(String.valueOf(ch), leftMargin + (this.fontRes + border) * x + zeroSideMargin - Math.round(fontGapAdjWidth / 2.0f - (this.fontRes == 8 ? 0.1f : 0.0f)), (int)(posY + (float)((this.fontRes + border) * y) + (float)zeroSideMargin + sizeMargin));
                    if (this.fontDouble == 1 && CharUtils.isAscii((char)ch) || this.fontDouble == 2 && !CharUtils.isAscii((char)ch) || this.fontDouble == 3) {
                        g2.drawString(String.valueOf(ch), leftMargin + (this.fontRes + border) * x + zeroSideMargin - Math.round(fontGapAdjWidth / 2.0f - (this.fontRes == 8 ? 0.1f : 0.0f)), (int)(posY + (float)((this.fontRes + border) * y) + (float)zeroSideMargin + sizeMargin));
                    }
                    if (ModConfig.debug) {
                        g2.setColor(Color.RED);
                        g2.drawLine(leftMargin + (this.fontRes + border) * x + zeroSideMargin, (int)(posY + (float)((this.fontRes + border) * y) + (float)zeroSideMargin + sizeMargin), leftMargin + (this.fontRes + border) * x + zeroSideMargin, (int)(posY + (float)((this.fontRes + border) * y) + (float)zeroSideMargin + sizeMargin));
                        g2.setColor(Color.GREEN);
                        g2.drawLine(leftMargin + (this.fontRes + border) * x + zeroSideMargin + (int)chWidth, (int)(posY + (float)((this.fontRes + border) * y) + (float)zeroSideMargin + sizeMargin), leftMargin + (this.fontRes + border) * x + zeroSideMargin + (int)chWidth, (int)(posY + (float)((this.fontRes + border) * y) + (float)zeroSideMargin + sizeMargin));
                        g2.setColor(Color.WHITE);
                    }
                    startColumn = (int)((float)leftMargin / scaleFactor);
                    endColumn = (int)(((float)leftMargin + chWidth) / scaleFactor);
                    startColumn = startColumn < 0 ? 0 : startColumn;
                    endColumn = endColumn > 15 ? 15 : endColumn;
                    glyphWidth[ch] = (byte)(startColumn << 4 | endColumn & 0xF);
                    FontRendererHook.glyphWidthFloat[ch] = chWidth / scaleFactor;
                    FontRendererHook.glyphBaselineGap[ch] = ((defaultBaseY - posY) / scaleFactor + 1.0f) / 2.0f;
                    continue;
                }
                glyphWidth[ch] = 0;
                FontRendererHook.glyphWidthFloat[ch] = 0.0f;
                FontRendererHook.glyphBaselineGap[ch] = 0.0f;
            }
        }
        g2.dispose();
        if (noFontCnt == 256) {
            fontImage = this.blankImage;
        }
        if (!ModConfig.compressCache) {
            this.fontImageCache[page] = fontImage;
        } else {
            this.fontPngImageCache[page] = this.getBytesFromImage(fontImage);
        }
        Logger.debug("Font cache page-" + page + " was created.");
        return fontImage;
    }

    private void setAntiAlias(Graphics2D g2) {
        if (this.antiAlias) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (this.fractionalMetrics) {
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            }
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytesFromImage(BufferedImage image) {
        String[] formats = ImageIO.getWriterFormatNames();
        byte[] bytes = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedOutputStream bufout = new BufferedOutputStream(out);
        image.flush();
        try {
            ImageIO.write((RenderedImage)image, "png", bufout);
            bufout.flush();
            bufout.close();
            bytes = out.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImageFromBytes(byte[] bytes) {
        BufferedImage image = null;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            image = ImageIO.read(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return image;
    }

    public int getFontRes() {
        if (ModConfig.useOSFont) {
            return this.fontRes;
        }
        int texSize = FontTextureManager.getInstance().textureSizeArray[0];
        return texSize == 0 ? 16 : texSize;
    }
}

