/*
 * Decompiled with CFR 0.152.
 */
package bre.ufex.asm;

import bre.ufex.asm.AsmHelper;
import bre.ufex.asm.CorePlugin;
import bre.ufex.asm.Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.AdviceAdapter;

public class UfexAdapter {
    static String className;
    static String transformedName;

    public static class GuiIngameForge {

        public static class RenderExperienceAdapter
        extends MethodVisitor {
            static boolean transCond = false;
            static int aload0Num = 0;
            static int popNum = 0;

            public RenderExperienceAdapter(MethodVisitor mv) {
                super(262144, mv);
            }

            public void visitIntInsn(int opcode, int var) {
                if (opcode == 16 && var == 31) {
                    transCond = true;
                }
                super.visitIntInsn(opcode, var);
            }

            public void visitVarInsn(int opcode, int var) {
                if (transCond) {
                    if (opcode == 25 && var == 0 && aload0Num < 4) {
                        ++aload0Num;
                    }
                    if (aload0Num == popNum + 1) {
                        return;
                    }
                }
                super.visitVarInsn(opcode, var);
            }

            public void visitInsn(int opcode) {
                if (transCond) {
                    if (opcode == 87 && popNum < 4) {
                        if (++popNum == 4) {
                            transCond = false;
                            super.visitVarInsn(25, 0);
                            super.visitFieldInsn(180, "net/minecraftforge/client/GuiIngameForge", "fontrenderer", "Lnet/minecraft/client/gui/FontRenderer;");
                            super.visitVarInsn(25, 7);
                            super.visitVarInsn(21, 8);
                            super.visitInsn(134);
                            super.visitVarInsn(21, 9);
                            super.visitInsn(134);
                            super.visitMethodInsn(184, "bre/ufex/GuiIngameForgeHook", "renderExperienceHook", "(Lnet/minecraft/client/gui/FontRenderer;Ljava/lang/String;FF)V", false);
                            AsmHelper.logger.info("Modified renderExperience method.");
                            GuiIngameForgeMethods.RENDER_EXPERIENCE.setTransformed();
                        }
                        return;
                    }
                    if (aload0Num == popNum + 1) {
                        return;
                    }
                }
                super.visitInsn(opcode);
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (transCond && aload0Num == popNum + 1) {
                    return;
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (transCond && aload0Num == popNum + 1) {
                    return;
                }
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }

    public static class TextureManager {

        public static class LoadTextureAdapter
        extends AdviceAdapter {
            public LoadTextureAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodExit(int opcode) {
                super.visitVarInsn(25, 1);
                super.visitMethodInsn(184, "bre/ufex/TextureManagerHook", "loadTextureExitHook", "(Lnet/minecraft/util/ResourceLocation;)V", false);
                AsmHelper.logger.info("Inserted the ExitHook in loadTexture() method.");
                TextureManagerMethods.LOAD_TEXTURE.setTransformed();
            }
        }
    }

    public static class ScaledResolution {

        public static class ConstructorAdapter
        extends MethodVisitor {
            public ConstructorAdapter(MethodVisitor mv) {
                super(262144, mv);
            }

            public void visitVarInsn(int opcode, int var) {
                super.visitVarInsn(opcode, var);
                if (opcode == 54 && var == 2) {
                    super.visitVarInsn(21, 2);
                    super.visitMethodInsn(184, "bre/ufex/ScaledResolutionHook", "modifyFlag", "(Z)Z", false);
                    super.visitVarInsn(54, 2);
                    AsmHelper.logger.info("Inserted the hook in ScaledResolution.<init>.");
                    ScaledResolutionMethods.INIT.setTransformed();
                }
            }
        }
    }

    public static class FontRenderer {

        public static class GetCharWidthFloatAdapter
        extends MethodVisitor {
            private boolean skip = false;

            public GetCharWidthFloatAdapter(MethodVisitor mv) {
                super(262144, mv);
            }

            public void visitInsn(int opcode) {
                if (opcode == 5) {
                    this.skip = true;
                    super.visitInsn(134);
                    super.visitInsn(13);
                    super.visitInsn(110);
                    super.visitInsn(12);
                    super.visitInsn(98);
                    super.visitInsn(174);
                }
                if (!this.skip) {
                    super.visitInsn(opcode);
                }
                if (this.skip && opcode == 174) {
                    this.skip = false;
                    AsmHelper.logger.info("Modified getCharWidthFloat method.");
                    FontRendererMethods.GET_CHAR_WIDTH_FLOAT.setTransformed();
                }
            }
        }

        public static class SizeStringToWidthAdapter
        extends AdviceAdapter {
            public SizeStringToWidthAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                super.visitVarInsn(25, 1);
                super.visitVarInsn(21, 2);
                super.visitMethodInsn(182, "bre/ufex/FontRendererHook", "sizeStringToWidthFloatHook", "(Ljava/lang/String;I)I", false);
                super.visitInsn(172);
                AsmHelper.logger.info("Inserted the EnterHook in sizeStringToWidth method.");
                FontRendererMethods.SIZE_STRING_TO_WIDTH.setTransformed();
            }
        }

        public static class SetUnicodeFlagAdapter
        extends AdviceAdapter {
            public SetUnicodeFlagAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodExit(int opcode) {
                super.visitVarInsn(25, 0);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                super.visitVarInsn(21, 1);
                super.visitMethodInsn(182, "bre/ufex/FontRendererHook", "setUnicodeFlagHook", "(Z)Z", false);
                super.visitFieldInsn(181, "net/minecraft/client/gui/FontRenderer", "field_78293_l", "Z");
                AsmHelper.logger.info("Inserted the ExitHook in setUnicodeFlag method.");
                FontRendererMethods.SET_UNICODE_FLAG.setTransformed();
            }
        }

        public static class TrimStringToWidthAdapter
        extends AdviceAdapter {
            public TrimStringToWidthAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                super.visitVarInsn(25, 1);
                super.visitVarInsn(21, 2);
                super.visitVarInsn(21, 3);
                super.visitMethodInsn(182, "bre/ufex/FontRendererHook", "trimStringToWidthFloatHook", "(Ljava/lang/String;IZ)Ljava/lang/String;", false);
                super.visitInsn(176);
                AsmHelper.logger.info("Inserted the EnterHook in trimStringToWidth method.");
                FontRendererMethods.TRIM_STRING_TO_WIDTH.setTransformed();
            }
        }

        public static class GetStringWidthAdapter
        extends AdviceAdapter {
            public GetStringWidthAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                super.visitVarInsn(25, 1);
                super.visitMethodInsn(182, "bre/ufex/FontRendererHook", "getStringWidthFloatHook", "(Ljava/lang/String;)I", false);
                super.visitInsn(172);
                AsmHelper.logger.info("Inserted the EnterHook in getStringWidth method.");
                FontRendererMethods.GET_STRING_WIDTH.setTransformed();
            }
        }

        public static class DoDrawAdapter
        extends MethodVisitor {
            boolean targetFound = false;
            boolean skip = false;

            public DoDrawAdapter(MethodVisitor mv) {
                super(262144, mv);
            }

            public void visitInsn(int opcode) {
                if (opcode == 89) {
                    this.targetFound = true;
                }
                if (this.targetFound && this.skip) {
                    if (opcode == 98) {
                        this.targetFound = false;
                        this.skip = false;
                        super.visitVarInsn(25, 0);
                        super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                        super.visitVarInsn(23, 1);
                        super.visitMethodInsn(182, "bre/ufex/FontRendererHook", "doDrawHook", "(F)F", false);
                        super.visitInsn(98);
                        AsmHelper.logger.info("Modified doDraw method.");
                        FontRendererMethods.DO_DRAW.setTransformed();
                    }
                    return;
                }
                super.visitInsn(opcode);
            }

            public void visitVarInsn(int opcode, int var) {
                if (this.targetFound && opcode == 23 && var == 1) {
                    this.skip = true;
                    return;
                }
                super.visitVarInsn(opcode, var);
            }
        }

        public static class RenderStringAtPosAdapter
        extends AdviceAdapter {
            private boolean transformed1 = false;
            private boolean transformed2 = false;
            boolean flag1 = false;
            int posX = 0;

            public RenderStringAtPosAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                super.visitVarInsn(25, 1);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78293_l", "Z");
                super.visitMethodInsn(182, "bre/ufex/FontRendererHook", "renderStringAtPosEnterHook", "(Ljava/lang/String;Z)V", false);
                super.visitVarInsn(25, 0);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78295_j", "F");
                super.visitVarInsn(21, 2);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78293_l", "Z");
                super.visitMethodInsn(182, "bre/ufex/FontRendererHook", "renderStringAtPosHookAdjustShadow", "(FZZ)F", false);
                super.visitFieldInsn(181, "net/minecraft/client/gui/FontRenderer", "field_78295_j", "F");
                super.visitVarInsn(25, 0);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78296_k", "F");
                super.visitVarInsn(21, 2);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78293_l", "Z");
                super.visitMethodInsn(182, "bre/ufex/FontRendererHook", "renderStringAtPosHookAdjustShadow", "(FZZ)F", false);
                super.visitFieldInsn(181, "net/minecraft/client/gui/FontRenderer", "field_78296_k", "F");
                AsmHelper.logger.info("Inserted the EnterHook in renderStringAtPos method.");
                this.transformed1 = true;
            }

            public void onMethodExit(int opcode) {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78293_l", "Z");
                super.visitMethodInsn(182, "bre/ufex/FontRendererHook", "renderStringAtPosExitHook", "(Z)V", false);
                AsmHelper.logger.info("Inserted the ExitHook in renderStringAtPos method.");
                if (this.transformed1 && this.transformed2) {
                    FontRendererMethods.RENDER_STRING_AT_POS.setTransformed();
                }
            }

            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                super.visitFieldInsn(opcode, owner, name, desc);
                if (opcode == 180 && "field_78302_t".equals(AsmHelper.mapFieldName(owner, name, desc))) {
                    this.flag1 = true;
                }
                if (this.flag1 && opcode == 181 && "field_78295_j".equals(AsmHelper.mapFieldName(owner, name, desc))) {
                    ++this.posX;
                    if (this.posX == 1) {
                        super.visitVarInsn(25, 0);
                        super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                        super.visitInsn(4);
                        super.visitFieldInsn(181, "bre/ufex/FontRendererHook", "boldFlag", "Z");
                    }
                    if (this.posX == 3) {
                        super.visitVarInsn(25, 0);
                        super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                        super.visitInsn(3);
                        super.visitFieldInsn(181, "bre/ufex/FontRendererHook", "boldFlag", "Z");
                        this.flag1 = false;
                        AsmHelper.logger.info("Inserted boldFlag related code in renderStringAtPos().");
                        this.transformed2 = true;
                    }
                }
            }
        }

        public static class RenderUnicodeCharAdapter
        extends AdviceAdapter {
            public RenderUnicodeCharAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                super.visitVarInsn(21, 1);
                super.visitVarInsn(21, 2);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78287_e", "[B");
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78295_j", "F");
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "field_78296_k", "F");
                super.visitMethodInsn(182, "bre/ufex/FontRendererHook", "renderUnicodeCharHook", "(CZ[BFF)F", false);
                super.visitInsn(174);
                AsmHelper.logger.info("Inserted the EnterHook in renderUnicodeChar() method.");
                FontRendererMethods.RENDER_UNICODE_CHAR.setTransformed();
            }
        }

        public static class ReadGlyphSizesAdapter
        extends AdviceAdapter {
            public ReadGlyphSizesAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodExit(int opcode) {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                super.visitMethodInsn(182, "bre/ufex/FontRendererHook", "readGlyphSizesExitHook", "()V", false);
                AsmHelper.logger.info("Inserted the ExitHook in readGlyphSizes method.");
                FontRendererMethods.READ_GLYPH_SIZES.setTransformed();
            }
        }

        public static class ConstructorAdapter
        extends AdviceAdapter {
            private boolean transformed1 = false;

            public ConstructorAdapter(MethodVisitor mv, int access, String name, String desc) {
                super(262144, mv, access, name, desc);
            }

            public void onMethodEnter() {
                super.visitVarInsn(25, 0);
                super.visitTypeInsn(187, "bre/ufex/FontRendererHook");
                super.visitInsn(89);
                super.visitVarInsn(25, 0);
                super.visitMethodInsn(183, "bre/ufex/FontRendererHook", "<init>", "(Lnet/minecraft/client/gui/FontRenderer;)V", false);
                super.visitFieldInsn(181, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                AsmHelper.logger.info("Inserted the EnterHook in constructor.");
                this.transformed1 = true;
            }

            public void onMethodExit(int opcode) {
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, "net/minecraft/client/gui/FontRenderer", "fontRendererHook", "Lbre/ufex/FontRendererHook;");
                super.visitMethodInsn(182, "bre/ufex/FontRendererHook", "fontRendererExitHook", "()V", false);
                AsmHelper.logger.info("Inserted the ExitHook in constructor.");
                if (this.transformed1) {
                    FontRendererMethods.INIT.setTransformed();
                }
            }
        }
    }

    public static class ClassAdapter
    extends ClassVisitor {
        public ClassAdapter(ClassVisitor cv) {
            super(262144, cv);
        }

        public ClassAdapter(ClassVisitor cv, String className, String transformedName) {
            this(cv);
            UfexAdapter.className = className;
            UfexAdapter.transformedName = transformedName;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (transformedName.equals(Transformer.TARGETS[0])) {
                if ("<init>".equals(AsmHelper.mapMethodName(Transformer.TARGETS[0], name, desc))) {
                    return new FontRenderer.ConstructorAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_98306_d".equals(AsmHelper.mapMethodName(Transformer.TARGETS[0], name, desc))) {
                    return new FontRenderer.ReadGlyphSizesAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_78277_a".equals(AsmHelper.mapMethodName(Transformer.TARGETS[0], name, desc))) {
                    return new FontRenderer.RenderUnicodeCharAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_78255_a".equals(AsmHelper.mapMethodName(Transformer.TARGETS[0], name, desc))) {
                    return new FontRenderer.RenderStringAtPosAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("doDraw".equals(AsmHelper.mapMethodName(Transformer.TARGETS[0], name, desc))) {
                    return new FontRenderer.DoDrawAdapter(super.visitMethod(access, name, desc, signature, exceptions));
                }
                if ("func_78256_a".equals(AsmHelper.mapMethodName(Transformer.TARGETS[0], name, desc))) {
                    return new FontRenderer.GetStringWidthAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_78262_a".equals(AsmHelper.mapMethodName(Transformer.TARGETS[0], name, desc))) {
                    return new FontRenderer.TrimStringToWidthAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_78264_a".equals(AsmHelper.mapMethodName(Transformer.TARGETS[0], name, desc))) {
                    return new FontRenderer.SetUnicodeFlagAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("func_78259_e".equals(AsmHelper.mapMethodName(Transformer.TARGETS[0], name, desc))) {
                    return new FontRenderer.SizeStringToWidthAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
                }
                if ("getCharWidthFloat".equals(AsmHelper.mapMethodName(Transformer.TARGETS[0], name, desc))) {
                    return new FontRenderer.GetCharWidthFloatAdapter(super.visitMethod(access, name, desc, signature, exceptions));
                }
            }
            if (transformedName.equals(Transformer.TARGETS[1]) && "<init>".equals(AsmHelper.mapMethodName(Transformer.TARGETS[1], name, desc))) {
                return new ScaledResolution.ConstructorAdapter(super.visitMethod(access, name, desc, signature, exceptions));
            }
            if (transformedName.equals(Transformer.TARGETS[2]) && "func_110579_a".equals(AsmHelper.mapMethodName(Transformer.TARGETS[2], name, desc))) {
                return new TextureManager.LoadTextureAdapter(super.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
            }
            if (transformedName.equals(Transformer.TARGETS[3]) && "renderExperience".equals(AsmHelper.mapMethodName(Transformer.TARGETS[3], name, desc))) {
                return new GuiIngameForge.RenderExperienceAdapter(super.visitMethod(access, name, desc, signature, exceptions));
            }
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        public void visitEnd() {
            boolean transformedAll;
            super.visitEnd();
            if (transformedName.equals(Transformer.TARGETS[0])) {
                transformedAll = true;
                for (Enum enum_ : FontRendererMethods.values()) {
                    AsmHelper.logger.info(enum_.name() + ":" + ((FontRendererMethods)enum_).getTransformed());
                    if (!CorePlugin.optifineExist && enum_ == FontRendererMethods.GET_CHAR_WIDTH_FLOAT) continue;
                    transformedAll &= ((FontRendererMethods)enum_).getTransformed();
                }
                if (transformedAll) {
                    AsmHelper.logger.info("** FontRenderer was completely transformed.");
                }
                assert (transformedAll) : "FontRenderer was not completely transformed.";
            }
            if (transformedName.equals(Transformer.TARGETS[1])) {
                transformedAll = true;
                for (Enum enum_ : ScaledResolutionMethods.values()) {
                    AsmHelper.logger.info(enum_.name() + ":" + ((ScaledResolutionMethods)enum_).getTransformed());
                    transformedAll &= ((ScaledResolutionMethods)enum_).getTransformed();
                }
                if (transformedAll) {
                    AsmHelper.logger.info("** ScaledResolution was completely transformed.");
                }
                assert (transformedAll) : "ScaledResolution was not completely transformed.";
            }
            if (transformedName.equals(Transformer.TARGETS[2])) {
                transformedAll = true;
                for (Enum enum_ : TextureManagerMethods.values()) {
                    AsmHelper.logger.info(enum_.name() + ":" + ((TextureManagerMethods)enum_).getTransformed());
                    transformedAll &= ((TextureManagerMethods)enum_).getTransformed();
                }
                if (transformedAll) {
                    AsmHelper.logger.info("** TextureManager was completely transformed.");
                }
                assert (transformedAll) : "TextureManager was not completely transformed.";
            }
            if (transformedName.equals(Transformer.TARGETS[3])) {
                transformedAll = true;
                for (Enum enum_ : GuiIngameForgeMethods.values()) {
                    AsmHelper.logger.info(enum_.name() + ":" + ((GuiIngameForgeMethods)enum_).getTransformed());
                    transformedAll &= ((GuiIngameForgeMethods)enum_).getTransformed();
                }
                if (transformedAll) {
                    AsmHelper.logger.info("** GuiIngameForge was completely transformed.");
                }
                assert (transformedAll) : "GuiIngameForge was not completely transformed.";
            }
        }
    }

    private static enum GuiIngameForgeMethods {
        RENDER_EXPERIENCE;

        private boolean transformed = false;

        public void setTransformed() {
            this.transformed = true;
        }

        public boolean getTransformed() {
            return this.transformed;
        }
    }

    private static enum TextureManagerMethods {
        LOAD_TEXTURE;

        private boolean transformed = false;

        public void setTransformed() {
            this.transformed = true;
        }

        public boolean getTransformed() {
            return this.transformed;
        }
    }

    private static enum ScaledResolutionMethods {
        INIT;

        private boolean transformed = false;

        public void setTransformed() {
            this.transformed = true;
        }

        public boolean getTransformed() {
            return this.transformed;
        }
    }

    private static enum FontRendererMethods {
        INIT,
        READ_GLYPH_SIZES,
        RENDER_UNICODE_CHAR,
        RENDER_STRING_AT_POS,
        DO_DRAW,
        GET_STRING_WIDTH,
        TRIM_STRING_TO_WIDTH,
        SET_UNICODE_FLAG,
        SIZE_STRING_TO_WIDTH,
        GET_CHAR_WIDTH_FLOAT;

        private boolean transformed = false;

        public void setTransformed() {
            this.transformed = true;
        }

        public boolean getTransformed() {
            return this.transformed;
        }
    }
}

