/*
 * Decompiled with CFR 0.152.
 */
package bre.ufex;

import bre.ufex.ModConfig;
import bre.ufex.util.Logger;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import net.minecraft.client.resources.I18n;

public class FontPixels {
    private Font font;
    private FontMetrics fm;
    private boolean antiAlias;
    private boolean fractionalMetrics;
    private double height;
    private double ascent;
    private double decent;
    private double leading;

    public FontPixels(Font font, FontMetrics fm, boolean antiAlias, boolean fractionalMetrics) {
        this.font = font;
        this.fm = fm;
        this.antiAlias = antiAlias;
        this.fractionalMetrics = fractionalMetrics;
        String charsAlphabet = "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{}~";
        String charsLocal = I18n.func_135052_a((String)"language.name", (Object[])new Object[0]);
        String testString = font.canDisplayUpTo(charsLocal) == -1 ? charsAlphabet + charsLocal + ModConfig.heightAdjustChars : charsAlphabet + ModConfig.heightAdjustChars;
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, this.antiAlias, this.fractionalMetrics);
        GlyphVector gv = font.createGlyphVector(frc, testString);
        Rectangle2D rectangle = gv.getVisualBounds();
        this.height = rectangle.getHeight();
        this.ascent = Math.abs(rectangle.getY());
        this.decent = this.height - this.ascent;
    }

    public double getHeight() {
        return this.height;
    }

    public double getAscent() {
        return this.ascent;
    }

    public double getDecent() {
        return this.decent;
    }

    public float getFittedSize(int pixelSize) {
        Font workFont;
        FontPixels fp;
        float step = 0.5f;
        float size = 0.0f;
        while ((fp = new FontPixels(workFont = this.font.deriveFont(size + 0.5f), this.fm, this.antiAlias, this.fractionalMetrics)).getHeight() < (double)pixelSize) {
            size += 0.5f;
        }
        Logger.info("Suitable font size is " + size + " (" + this.font.getFontName() + ")");
        return size;
    }

    @Deprecated
    public double getCharWidth(char ch) {
        GlyphVector gv = this.font.createGlyphVector(this.fm.getFontRenderContext(), String.valueOf(ch));
        Rectangle rectangle = gv.getPixelBounds(null, 0.0f, 0.0f);
        return ((RectangularShape)rectangle).getWidth();
    }

    @Deprecated
    public double getCharWidth2(char ch) {
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        double width = this.font.getStringBounds(String.valueOf(ch), frc).getWidth();
        return width;
    }
}

