/*
 * Decompiled with CFR 0.152.
 */
package bre.ufex;

import bre.ufex.FontTexture;
import bre.ufex.util.Logger;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;

public class FontTextureManager
implements IResourceManagerReloadListener {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static FontTextureManager INSTANCE = new FontTextureManager();
    private final Map<ResourceLocation, ITextureObject> mapTextureObjects = Maps.newHashMap();
    private IResourceManager theResourceManager;
    private byte[] glyphWidthTable = new byte[65536];
    private byte[] glyphWidthOrig = null;
    public List<FontRenderer> fontRendererList = new ArrayList<FontRenderer>();
    public int[] textureSizeArray = new int[256];
    public float[] borderWidthRateArray = new float[256];

    public FontTextureManager() {
        this.theResourceManager = mc.func_110442_L();
        ((IReloadableResourceManager)mc.func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    public static FontTextureManager getInstance() {
        return INSTANCE;
    }

    public void saveGlyphWidthOrig(byte[] gw) {
        if (this.glyphWidthOrig == null) {
            this.glyphWidthOrig = new byte[65536];
            for (int i = 0; i < 65536; ++i) {
                this.glyphWidthOrig[i] = gw[i];
            }
        }
    }

    private void adjustGlyphWidthTable() {
        for (int i = 0; i < 65536; ++i) {
            if (this.glyphWidthOrig[i] != 0) continue;
            this.glyphWidthTable[i] = 0;
        }
    }

    public byte[] getGlyphWidthOrig() {
        return this.glyphWidthOrig;
    }

    public byte[] getGlyphWidth() {
        return this.glyphWidthTable;
    }

    public void restoreGlyphWidthAll() {
        for (FontRenderer renderer : this.fontRendererList) {
            this.restoreGlyphWidth(renderer.field_78287_e);
        }
    }

    public void restoreGlyphWidth(byte[] gw) {
        this.adjustGlyphWidthTable();
        for (int i = 0; i < 65536; ++i) {
            gw[i] = this.glyphWidthTable[i];
        }
    }

    public void bindTexture(ResourceLocation resource, int page) {
        Object itextureobject = this.mapTextureObjects.get(resource);
        if (itextureobject == null) {
            itextureobject = new FontTexture(resource, page);
            this.loadTexture(resource, (ITextureObject)itextureobject);
        }
        GlStateManager.func_179144_i((int)itextureobject.func_110552_b());
    }

    public boolean loadTexture(ResourceLocation textureLocation, ITextureObject textureObj) {
        boolean flag = true;
        try {
            textureObj.func_110551_a(this.theResourceManager);
        }
        catch (Exception e) {
            Logger.error("Failed to load texture: " + textureLocation);
            e.printStackTrace();
            textureObj = TextureUtil.field_111001_a;
            this.mapTextureObjects.put(textureLocation, textureObj);
            flag = false;
        }
        this.mapTextureObjects.put(textureLocation, textureObj);
        return flag;
    }

    public void func_110549_a(IResourceManager iresourceManager) {
        this.clearMapTextureObjects();
        for (int i = 0; i < 256; ++i) {
            this.textureSizeArray[i] = 0;
            this.borderWidthRateArray[i] = 0.0f;
        }
        for (FontRenderer fr : this.fontRendererList) {
            fr.func_98306_d();
        }
    }

    public void clearMapTextureObjects() {
        ArrayList<ITextureObject> texObjList = new ArrayList<ITextureObject>(this.mapTextureObjects.values());
        for (ITextureObject texObj : texObjList) {
            ((FontTexture)texObj).func_147631_c();
        }
        this.mapTextureObjects.clear();
    }

    public void setUnicodeFlagAll() {
        for (FontRenderer fr : this.fontRendererList) {
            fr.func_78264_a(true);
        }
    }
}

