/*
 * Decompiled with CFR 0.152.
 */
package bre.ufex.asm;

import bre.ufex.asm.AsmHelper;
import bre.ufex.asm.UfexAdapter;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class Transformer
implements IClassTransformer {
    public static final String[] TARGETS = new String[]{"net.minecraft.client.gui.FontRenderer", "net.minecraft.client.gui.ScaledResolution", "net.minecraft.client.renderer.texture.TextureManager", "net.minecraftforge.client.GuiIngameForge"};

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassReader cr;
        if (FMLLaunchHandler.side().isServer()) {
            return bytes;
        }
        if (!this.accept(transformedName)) {
            return bytes;
        }
        AsmHelper.logger.info("Internal name = " + name);
        AsmHelper.logger.info("Transformed name = " + transformedName);
        try {
            cr = new ClassReader(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            cr = new ClassReader(bytes);
        }
        AsmHelper.logger.info("new ClassReader done");
        ClassWriter cw = new ClassWriter(1);
        AsmHelper.logger.info("new ClassWriter done");
        if (transformedName.equals("net.minecraft.client.gui.FontRenderer")) {
            cw.visitField(1, "fontRendererHook", "Lbre/ufex/FontRendererHook;", null, null).visitEnd();
        }
        UfexAdapter.ClassAdapter cv = new UfexAdapter.ClassAdapter((ClassVisitor)cw, name, transformedName);
        AsmHelper.logger.info("new ClassAdapter done");
        cr.accept((ClassVisitor)cv, 8);
        AsmHelper.logger.info("accept done");
        return cw.toByteArray();
    }

    private boolean accept(String className) {
        for (String target : TARGETS) {
            if (!target.equals(className)) continue;
            AsmHelper.logger.info("Transform: " + className);
            return true;
        }
        return false;
    }
}

