/*
 * Decompiled with CFR 0.152.
 */
package bre.ufex;

import bre.ufex.FontRasterizer;
import bre.ufex.FontShader;
import bre.ufex.FontTextureManager;
import bre.ufex.ModConfig;
import bre.ufex.asm.CorePlugin;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class FontRendererHook {
    private float fontScale;
    private boolean overlayScreen;
    private boolean exclusionCond;
    private boolean orthographic;
    private boolean fractionCoord;
    private int tex_wrapS;
    private int tex_wrapT;
    private int tex_min_filter;
    private int tex_mag_filter;
    private int tex_blend;
    private Minecraft mc = Minecraft.func_71410_x();
    private FontRenderer fontRenderer;
    private boolean highPrecision = true;
    public boolean boldFlag = false;
    private float fontScaleRoundingToleranceRate = 0.0f;
    private static final ResourceLocation[] unicodePageLocations = new ResourceLocation[256];
    private FontShader fontShader;
    private int prevShaderProg;
    private FontTextureManager fontTextureManager;
    public static boolean isHookWorked1 = false;
    public static boolean isHookWorked2 = false;
    public static boolean modLoaded = false;
    public static float fontSizeBiasVal;
    public static float[] glyphWidthFloat;
    public static float[] glyphBaselineGap;
    public static List<FontRendererHook> uninitFontRendererHookList;
    private static float horizontalOverhang;
    private static float verticalOverhang;
    private static float fontGapOverhang;

    public FontRendererHook(FontRenderer renderer) {
        this.fontRenderer = renderer;
        this.fontTextureManager = FontTextureManager.getInstance();
        this.fontTextureManager.fontRendererList.add(renderer);
        this.fontShader = FontShader.getInstance();
        if (ModConfig.configLoaded) {
            this.initAfterConfigLoaded();
        } else {
            uninitFontRendererHookList.add(this);
        }
    }

    public void initAfterConfigLoaded() {
        String cls = this.fontRenderer.getClass().toString();
        for (String c : ModConfig.normalPrecisionClasses) {
            if (!cls.endsWith(c)) continue;
            this.highPrecision = false;
        }
        if (ModConfig.useOSFont) {
            FontRasterizer.getInstance();
        }
        FontRendererHook.setOverhangs();
        this.fontScaleRoundingToleranceRate = (float)ModConfig.fontScaleRoundingTolerance * 0.01f;
    }

    public void fontRendererExitHook() {
        if (ModConfig.forceUnicode) {
            this.fontRenderer.func_78264_a(true);
        }
    }

    private void saveTexParams() {
        this.tex_wrapS = GL11.glGetTexParameteri((int)3553, (int)10242);
        this.tex_wrapT = GL11.glGetTexParameteri((int)3553, (int)10243);
        this.tex_min_filter = GL11.glGetTexParameteri((int)3553, (int)10241);
        this.tex_mag_filter = GL11.glGetTexParameteri((int)3553, (int)10240);
    }

    private void restoreTexParams() {
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)this.tex_wrapS);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)this.tex_wrapT);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)this.tex_min_filter);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)this.tex_mag_filter);
    }

    private void setLodBias() {
        if (this.orthographic && !this.fractionCoord) {
            GlStateManager.func_187436_a((int)34048, (int)34049, (float)((float)ModConfig.overlayLodBias / 10.0f));
        } else {
            GlStateManager.func_187436_a((int)34048, (int)34049, (float)((float)ModConfig.mipmapLodBias / 10.0f));
        }
    }

    private void setTexParams() {
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)33069);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)33069);
        if (ModConfig.enableInterpolation) {
            if (ModConfig.enableMipmap) {
                GlStateManager.func_187421_b((int)3553, (int)10241, (int)9987);
                this.setLodBias();
            } else {
                GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
            }
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
        } else {
            if (ModConfig.enableMipmap) {
                GlStateManager.func_187421_b((int)3553, (int)10241, (int)9986);
                this.setLodBias();
            } else {
                GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
            }
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        }
    }

    public float renderUnicodeCharHook(char ch, boolean italic, byte[] glyphWidth, float posX, float posY) {
        ScaledResolution scaledResolution;
        float it;
        float texW;
        float right;
        if (!isHookWorked2) {
            isHookWorked2 = true;
        }
        if (glyphWidth[ch] == 0) {
            return 0.0f;
        }
        if (ModConfig.disableSmallItalic && this.fontScale < 2.1f) {
            italic = false;
        }
        int i = ch / 256;
        ResourceLocation unicodePageLocation = this.getUnicodePageLocation(i);
        this.fontTextureManager.bindTexture(unicodePageLocation, i);
        float left = (glyphWidth[ch] & 0xF0) >>> 4;
        if (modLoaded && ModConfig.useOSFont && this.highPrecision) {
            right = left + glyphWidthFloat[ch];
            texW = glyphWidthFloat[ch];
        } else {
            right = (glyphWidth[ch] & 0xF) + 1;
            texW = right - left - 0.02f;
        }
        float borderWidthRate = this.fontTextureManager.borderWidthRateArray[i];
        float texSize = 256.0f + borderWidthRate * 16.0f;
        float zeroSideMargin = borderWidthRate / 2.0f;
        float texX = (float)(ch % 16) * (16.0f + borderWidthRate) + left + zeroSideMargin;
        float texY = (float)((ch & 0xFF) / 16) * (16.0f + borderWidthRate) + zeroSideMargin;
        float f = it = italic ? 1.0f : 0.0f;
        if (ModConfig.fontAlignBaseline && ModConfig.useOSFont) {
            posY += glyphBaselineGap[ch];
        }
        if (this.boldFlag && (scaledResolution = new ScaledResolution(this.mc)).func_78325_e() >= 3) {
            this.renderUnicodeChar(posX - 0.25f, posY, left, right, texX, texY, texW, texSize, it);
        }
        return this.renderUnicodeChar(posX, posY, left, right, texX, texY, texW, texSize, it);
    }

    private float renderUnicodeChar(float posX, float posY, float left, float right, float texX, float texY, float width, float texSize, float italic) {
        float horizontalOverhang = FontRendererHook.horizontalOverhang;
        width += fontGapOverhang;
        if (modLoaded && !this.exclusionCond) {
            this.saveTexParams();
            this.setTexParams();
            if (right - left <= 15.0f) {
                horizontalOverhang += 1.0f;
            }
            for (int i = 0; i < (ModConfig.enableDouble ? 2 : 1); ++i) {
                GlStateManager.func_187447_r((int)5);
                GlStateManager.func_187426_b((float)((texX - horizontalOverhang) / texSize), (float)((texY - verticalOverhang) / texSize));
                GlStateManager.func_187435_e((float)(posX - horizontalOverhang / 2.0f + italic), (float)(posY - verticalOverhang / 2.0f), (float)0.0f);
                GlStateManager.func_187426_b((float)((texX - horizontalOverhang) / texSize), (float)((texY + 15.8f + verticalOverhang) / texSize));
                GlStateManager.func_187435_e((float)(posX - horizontalOverhang / 2.0f - italic), (float)(posY + 7.9f + verticalOverhang / 2.0f), (float)0.0f);
                GlStateManager.func_187426_b((float)((texX + horizontalOverhang + width) / texSize), (float)((texY - verticalOverhang) / texSize));
                GlStateManager.func_187435_e((float)(posX + (horizontalOverhang + width) / 2.0f + italic), (float)(posY - verticalOverhang / 2.0f), (float)0.0f);
                GlStateManager.func_187426_b((float)((texX + horizontalOverhang + width) / texSize), (float)((texY + 15.8f + verticalOverhang) / texSize));
                GlStateManager.func_187435_e((float)(posX + (horizontalOverhang + width) / 2.0f - italic), (float)(posY + 7.9f + verticalOverhang / 2.0f), (float)0.0f);
                GlStateManager.func_187437_J();
            }
            this.restoreTexParams();
            return (right - left) / 2.0f + 1.0f;
        }
        GlStateManager.func_187447_r((int)5);
        GlStateManager.func_187426_b((float)((texX - horizontalOverhang) / texSize), (float)((texY - verticalOverhang) / texSize));
        GlStateManager.func_187435_e((float)(posX - horizontalOverhang / 2.0f + italic), (float)(posY - verticalOverhang / 2.0f), (float)0.0f);
        GlStateManager.func_187426_b((float)((texX - horizontalOverhang) / texSize), (float)((texY + 15.8f + verticalOverhang) / texSize));
        GlStateManager.func_187435_e((float)(posX - horizontalOverhang / 2.0f - italic), (float)(posY + 7.9f + verticalOverhang / 2.0f), (float)0.0f);
        GlStateManager.func_187426_b((float)((texX + horizontalOverhang + width) / texSize), (float)((texY - verticalOverhang) / texSize));
        GlStateManager.func_187435_e((float)(posX + horizontalOverhang / 2.0f + width / 2.0f + italic), (float)(posY - verticalOverhang / 2.0f), (float)0.0f);
        GlStateManager.func_187426_b((float)((texX + horizontalOverhang + width) / texSize), (float)((texY + 15.8f + verticalOverhang) / texSize));
        GlStateManager.func_187435_e((float)(posX + horizontalOverhang / 2.0f + width / 2.0f - italic), (float)(posY + 7.9f + verticalOverhang / 2.0f), (float)0.0f);
        GlStateManager.func_187437_J();
        return (right - left) / 2.0f + 1.0f;
    }

    public static void setOverhangs() {
        if (ModConfig.useOSFont) {
            fontGapOverhang = -((float)ModConfig.fontGap);
            float fontSizeOverhang = ModConfig.fontSizeAdjustment > 0 ? 0.4f * (float)ModConfig.fontSizeAdjustment : 0.0f;
            horizontalOverhang = (float)ModConfig.horizontalOverhang + fontSizeOverhang + fontGapOverhang / 2.0f;
            verticalOverhang = (float)ModConfig.verticalOverhang + fontSizeOverhang;
        } else {
            horizontalOverhang = ModConfig.horizontalOverhang;
            verticalOverhang = ModConfig.verticalOverhang;
        }
    }

    public void renderStringAtPosEnterHook(String text, boolean unicodeFlag) {
        if (!isHookWorked1) {
            isHookWorked1 = true;
        }
        if (modLoaded) {
            FloatBuffer fbuf = BufferUtils.createFloatBuffer((int)16);
            GlStateManager.func_179111_a((int)2983, (FloatBuffer)fbuf);
            fbuf.rewind();
            Matrix4f mtxPrj = new Matrix4f();
            mtxPrj.load(fbuf);
            fbuf.clear();
            GlStateManager.func_179111_a((int)2982, (FloatBuffer)fbuf);
            fbuf.rewind();
            Matrix4f mtxMod = new Matrix4f();
            mtxMod.load(fbuf);
            float fontScaleX = Math.abs((float)this.mc.field_71443_c * mtxPrj.m00 * mtxMod.m00);
            float fontScaleY = Math.abs((float)this.mc.field_71440_d * mtxPrj.m11 * mtxMod.m11);
            this.fontScale = Math.min(fontScaleX, fontScaleY);
            if (mtxPrj.m22 == -0.001f && mtxPrj.m32 == -2.0f && mtxMod.m32 == -2000.0f) {
                this.overlayScreen = true;
                this.orthographic = true;
            } else {
                this.overlayScreen = false;
                if (mtxPrj.m33 == 0.0f) {
                    this.orthographic = false;
                    this.fontScale /= Math.abs(mtxMod.m32);
                } else {
                    this.orthographic = true;
                }
            }
            this.fractionCoord = mtxMod.m30 * 10.0f % 5.0f != 0.0f || mtxMod.m31 * 10.0f % 5.0f != 0.0f;
            GL11.glPushAttrib((int)24576);
            float roundedScale = Math.round(this.fontScale);
            roundedScale = Math.abs(roundedScale - this.fontScale) < this.fontScale * this.fontScaleRoundingToleranceRate ? roundedScale : this.fontScale;
            float fontRes = FontRasterizer.getInstance().getFontRes();
            boolean bl = this.exclusionCond = this.orthographic && ModConfig.excludeIntMultiple && roundedScale % (fontRes / 4.0f) == 0.0f || ModConfig.excludeHighMag && (double)(roundedScale * 4.0f) >= (double)fontRes * ModConfig.limitingMagnification;
            if (!this.exclusionCond) {
                this.prevShaderProg = this.fontShader.getCurProgram();
                if (this.prevShaderProg == 0) {
                    float sizeBias = (float)Math.pow(3.0, fontSizeBiasVal) / (float)Math.pow(this.fontScale, fontSizeBiasVal);
                    sizeBias = sizeBias > 1.0f ? 1.0f : sizeBias;
                    float bright = (float)ModConfig.brightness / 10.0f * sizeBias;
                    float alpha = 1.0f + (float)ModConfig.opacityLevel / 10.0f * sizeBias;
                    boolean lightmap = this.fontShader.checkLightmapTexUnit();
                    this.fontShader.useProgram(lightmap & !this.orthographic);
                    this.fontShader.setColorBias(lightmap, bright, bright, bright, alpha);
                }
            }
            if (ModConfig.enableAlphaBlend) {
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)770, (int)1);
            } else {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)0);
            }
        }
    }

    public float renderStringAtPosHookAdjustShadow(float pos, boolean dropShadow, boolean unicodeFlag) {
        if (dropShadow && unicodeFlag) {
            pos += ModConfig.shadowAdjustVal;
        }
        return pos;
    }

    public void renderStringAtPosExitHook(boolean unicodeFlag) {
        if (modLoaded) {
            if (!this.exclusionCond && this.prevShaderProg == 0) {
                this.fontShader.useProgram(this.prevShaderProg);
            }
            GL11.glPopAttrib();
        }
    }

    private ResourceLocation getUnicodePageLocation(int page) {
        if (unicodePageLocations[page] == null) {
            FontRendererHook.unicodePageLocations[page] = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", page));
        }
        return unicodePageLocations[page];
    }

    public void readGlyphSizesExitHook() {
        this.fontTextureManager.saveGlyphWidthOrig(this.fontRenderer.field_78287_e);
        if (ModConfig.useOSFont) {
            this.fontTextureManager.restoreGlyphWidth(this.fontRenderer.field_78287_e);
        }
    }

    public boolean setUnicodeFlagHook(boolean unicodeFlag) {
        if (ModConfig.forceUnicode && this.mc.func_152349_b()) {
            return true;
        }
        return unicodeFlag;
    }

    public static float getFontSizeBiasValue(int value) {
        switch (value) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return 0.5f;
            }
            case 2: {
                return 1.5f;
            }
        }
        return 4.0f;
    }

    public float getCharWidthFloat(char character) {
        switch (character) {
            case '\u00a7': {
                return -1.0f;
            }
            case ' ': {
                if (CorePlugin.optifineExist && !this.fontRenderer.field_78293_l) {
                    return this.fontRenderer.func_78263_a(character);
                }
                return 4.0f;
            }
        }
        int i = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(character);
        if (character > '\u0000' && i != -1 && !this.fontRenderer.field_78293_l) {
            if (CorePlugin.optifineExist) {
                return this.fontRenderer.func_78263_a(character);
            }
            return this.fontRenderer.field_78286_d[i];
        }
        if (this.fontRenderer.field_78287_e[character] != 0) {
            if (ModConfig.useOSFont && this.highPrecision) {
                return glyphWidthFloat[character] / 2.0f + 1.0f;
            }
            int j = this.fontRenderer.field_78287_e[character] & 0xFF;
            int k = j >>> 4;
            int l = j & 0xF;
            return (++l - k) / 2 + 1;
        }
        return 0.0f;
    }

    public int getStringWidthFloatHook(String text) {
        if (text == null) {
            return 0;
        }
        float width = 0.0f;
        boolean bold = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            float chWidth = this.getCharWidthFloat(ch);
            if (chWidth < 0.0f && i < text.length() - 1) {
                ch = text.charAt(++i);
                switch (ch) {
                    case 'L': 
                    case 'l': {
                        bold = true;
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        bold = false;
                        break;
                    }
                }
                chWidth = 0.0f;
            }
            width += chWidth;
            if (!bold || !(chWidth > 0.0f)) continue;
            width += 1.0f;
        }
        return (int)width;
    }

    public String trimStringToWidthFloatHook(String text, int width, boolean reverse) {
        if (ModConfig.useOSFont && this.highPrecision) {
            ++width;
        }
        StringBuilder stringbuilder = new StringBuilder();
        float totalWidth = 0.0f;
        int start = reverse ? text.length() - 1 : 0;
        int step = reverse ? -1 : 1;
        boolean deco = false;
        boolean bold = false;
        for (int cur = start; cur >= 0 && cur < text.length() && totalWidth < (float)width; cur += step) {
            char ch = text.charAt(cur);
            float chWidth = this.getCharWidthFloat(ch);
            if (deco) {
                deco = false;
                switch (ch) {
                    case 'L': 
                    case 'l': {
                        bold = true;
                        break;
                    }
                    case 'R': 
                    case 'r': {
                        bold = false;
                        break;
                    }
                }
            } else if (chWidth < 0.0f) {
                deco = true;
            } else {
                totalWidth += chWidth;
                if (bold) {
                    totalWidth += 1.0f;
                }
            }
            if (totalWidth > (float)width) break;
            if (reverse) {
                stringbuilder.insert(0, ch);
                continue;
            }
            stringbuilder.append(ch);
        }
        return stringbuilder.toString();
    }

    public int sizeStringToWidthFloatHook(String str, int wrapWidth) {
        int pos;
        int len = str.length();
        float width = 0.0f;
        int breakPos = -1;
        boolean bold = false;
        for (pos = 0; pos < len; ++pos) {
            char ch = str.charAt(pos);
            block0 : switch (ch) {
                case '\n': {
                    --pos;
                    break;
                }
                case ' ': {
                    breakPos = pos;
                }
                default: {
                    width += this.getCharWidthFloat(ch);
                    if (!bold) break;
                    width += 1.0f;
                    break;
                }
                case '\u00a7': {
                    if (pos >= len - 1) break;
                    char decoCode = str.charAt(++pos);
                    switch (decoCode) {
                        case 'L': 
                        case 'l': {
                            bold = true;
                            break block0;
                        }
                        case 'R': 
                        case 'r': {
                            bold = false;
                            break block0;
                        }
                    }
                    if (!FontRenderer.func_78272_b((char)decoCode)) break;
                    bold = false;
                }
            }
            if (ch == '\n') {
                breakPos = ++pos;
                break;
            }
            if (width > (float)wrapWidth) break;
        }
        return pos != len && breakPos != -1 && breakPos < pos ? breakPos : pos;
    }

    public float doDrawHook(float f) {
        return ModConfig.useOSFont && this.highPrecision ? f : (float)((int)f);
    }

    static {
        glyphWidthFloat = new float[65536];
        glyphBaselineGap = new float[65536];
        uninitFontRendererHookList = new ArrayList<FontRendererHook>();
    }
}

