/*
 * Decompiled with CFR 0.152.
 */
package bre.ufex;

import bre.ufex.FontRasterizer;
import bre.ufex.FontTextureManager;
import bre.ufex.FontUtils;
import bre.ufex.ModConfig;
import bre.ufex.util.Logger;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL30;

public class FontTexture
extends AbstractTexture {
    public float borderWidthRate;
    public int fontRes;
    protected final ResourceLocation textureLocation;
    protected final int page;
    private FontTextureManager fontTextureManager;

    public FontTexture(ResourceLocation resourceLoc, int page) {
        this.textureLocation = resourceLoc;
        this.page = page;
        this.fontTextureManager = FontTextureManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_110551_a(IResourceManager iResMgr) throws IOException {
        this.func_147631_c();
        IResource iresource = null;
        try {
            BufferedImage borderedImage;
            iresource = iResMgr.func_110536_a(this.textureLocation);
            boolean flagBlur = false;
            boolean flagClamp = false;
            if (ModConfig.useOSFont) {
                borderedImage = FontRasterizer.getInstance().getFontImage(this.page);
                this.fontRes = FontRasterizer.getInstance().getFontRes();
                int texBorderWidth = FontUtils.getBorderWidth(this.fontRes);
                this.borderWidthRate = (float)(texBorderWidth * 16) / (float)this.fontRes;
            } else {
                BufferedImage bufferedimage = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
                borderedImage = this.addTextureBorder(bufferedimage);
                if (iresource.func_110528_c()) {
                    try {
                        TextureMetadataSection texturemetadatasection = (TextureMetadataSection)iresource.func_110526_a("texture");
                        if (texturemetadatasection != null) {
                            flagBlur = texturemetadatasection.func_110479_a();
                            flagClamp = texturemetadatasection.func_110480_b();
                        }
                    }
                    catch (RuntimeException runtimeexception) {
                        Logger.warn("Failed reading metadata of: " + this.textureLocation);
                    }
                }
            }
            this.fontTextureManager.textureSizeArray[this.page] = this.fontRes;
            this.fontTextureManager.borderWidthRateArray[this.page] = this.borderWidthRate;
            this.uploadTextureImageAllocate(this.func_110552_b(), borderedImage, flagBlur, flagClamp);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(iresource);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)iresource);
    }

    private void uploadTextureImageAllocate(int textureId, BufferedImage texture, boolean blur, boolean clamp) {
        TextureUtil.func_180600_a((int)textureId, (int)ModConfig.mipmapLevel, (int)texture.getWidth(), (int)texture.getHeight());
        TextureUtil.func_110995_a((int)textureId, (BufferedImage)texture, (int)0, (int)0, (boolean)blur, (boolean)clamp);
        GL30.glGenerateMipmap((int)3553);
    }

    protected BufferedImage addTextureBorder(BufferedImage origImg) {
        BufferedImage newImg;
        int textureSize;
        int width = origImg.getWidth();
        int height = origImg.getHeight();
        this.fontRes = width / 16;
        int texBorderWidth = FontUtils.getBorderWidth(this.fontRes);
        this.borderWidthRate = (float)(texBorderWidth * 16) / (float)this.fontRes;
        int newWidth = textureSize = (this.fontRes + texBorderWidth) * 16;
        int newHeight = textureSize;
        if (origImg.getColorModel() instanceof IndexColorModel) {
            if (origImg.getType() == 12) {
                byte[] r = new byte[]{-1, -1};
                byte[] g = new byte[]{-1, -1};
                byte[] b = new byte[]{-1, -1};
                byte[] a = new byte[]{0, -1};
                IndexColorModel icm = new IndexColorModel(1, 2, r, g, b, a);
                newImg = new BufferedImage(newWidth, newHeight, origImg.getType(), icm);
            } else {
                newImg = new BufferedImage(newWidth, newHeight, origImg.getType(), (IndexColorModel)origImg.getColorModel());
            }
        } else {
            newImg = new BufferedImage(newWidth, newHeight, origImg.getType());
        }
        Graphics2D g2 = newImg.createGraphics();
        int zeroSideMargin = texBorderWidth / 2;
        if (origImg.getType() == 12) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int alpha = origImg.getRGB(x, y) >>> 24;
                    if (alpha != 255) continue;
                    g2.setColor(Color.WHITE);
                    g2.drawLine(x + x / 16 * texBorderWidth + zeroSideMargin, y + y / 16 * texBorderWidth + zeroSideMargin, x + x / 16 * texBorderWidth + zeroSideMargin, y + y / 16 * texBorderWidth + zeroSideMargin);
                }
            }
        } else {
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    BufferedImage charImage = origImg.getSubimage(i * this.fontRes, j * this.fontRes, this.fontRes, this.fontRes);
                    g2.drawImage((Image)charImage, i * (this.fontRes + texBorderWidth) + zeroSideMargin, j * (this.fontRes + texBorderWidth) + zeroSideMargin, null);
                }
            }
        }
        g2.dispose();
        return newImg;
    }
}

