/*
 * Decompiled with CFR 0.152.
 */
package bre.ufex;

import bre.ufex.FontRasterizer;
import bre.ufex.FontUtils;
import bre.ufex.ModConfig;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;

public class CommandShowTexture
extends CommandBase {
    private final String COMMAND_NAME = "showfont";
    public static final CommandShowTexture INSTANCE = new CommandShowTexture();

    public String func_71517_b() {
        return "showfont";
    }

    public String func_71518_a(ICommandSender sender) {
        return "showfont <page num>";
    }

    public boolean func_71519_b(ICommandSender sender) {
        return true;
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandShowTexture.func_71530_a((String[])args, (String[])new String[]{"showfont"});
        }
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        int page;
        if (args.length >= 1 && ModConfig.useOSFont && (page = Integer.parseInt(args[0])) >= 0 && page < 256) {
            this.showTexture(page);
        }
    }

    protected void showTexture(int page) {
        BufferedImage img = FontRasterizer.getInstance().getFontImage(page);
        BufferedImage newImg = new BufferedImage(img.getWidth(), img.getHeight(), 6);
        Graphics2D g2 = newImg.createGraphics();
        int elementSize = FontRasterizer.getInstance().getFontRes();
        int borderSize = FontUtils.getBorderWidth(elementSize);
        int zeroSideMargin = borderSize / 2;
        g2.setBackground(Color.BLACK);
        g2.clearRect(0, 0, img.getWidth(), img.getHeight());
        g2.setBackground(Color.BLUE);
        g2.clearRect(0, 0, zeroSideMargin, img.getHeight());
        g2.clearRect(0, 0, img.getWidth(), zeroSideMargin);
        for (int i = elementSize; i < img.getWidth(); i += elementSize + borderSize) {
            g2.clearRect(i + zeroSideMargin, 0, borderSize, img.getHeight());
            g2.clearRect(0, i + zeroSideMargin, img.getWidth(), borderSize);
        }
        g2.drawImage((Image)img, 0, 0, null);
        g2.dispose();
        ImageIcon icon = new ImageIcon(newImg);
        JOptionPane.showMessageDialog(null, "type=" + img.getType(), "Unicode\u30c6\u30af\u30b9\u30c1\u30e3", -1, icon);
    }
}

