/*
 * Decompiled with CFR 0.152.
 */
package bre.ufex;

import bre.ufex.ModConfig;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import org.lwjgl.opengl.GL11;

public class FontUtils {
    public static List<String> getFontList() {
        Font[] fonts;
        ArrayList<String> fontNameList = new ArrayList<String>();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (Font font : fonts = ge.getAllFonts()) {
            fontNameList.add(font.getName());
        }
        return fontNameList;
    }

    public static List<String> getFontFamilyList() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Language lang = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        String[] families = ge.getAvailableFontFamilyNames(new Locale(lang.func_135034_a(), lang.field_135037_b));
        List<String> fontFamilyList = Arrays.asList(families);
        return fontFamilyList;
    }

    public static int getFontRes(int val) {
        switch (val) {
            case 0: {
                return 8;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 24;
            }
            case 5: {
                return 32;
            }
            case 6: {
                return 48;
            }
            case 7: {
                return 64;
            }
        }
        return 16;
    }

    public static int getBorderWidth(int texelSize) {
        switch (texelSize) {
            case 8: {
                return 8;
            }
            case 10: {
                return 6;
            }
            case 12: {
                return 20;
            }
            case 16: {
                return 16;
            }
            case 24: {
                if (ModConfig.fontSizeAdjustment <= 0) {
                    return 8;
                }
                return 40;
            }
            case 32: {
                return 32;
            }
            case 48: {
                if (ModConfig.fontSizeAdjustment <= 0) {
                    return 16;
                }
                return 32;
            }
            case 64: {
                if (ModConfig.fontSizeAdjustment <= 0) {
                    return 16;
                }
                return 32;
            }
        }
        return 16;
    }

    public static int getMaxFontSizeIndex() {
        int id;
        int maxTextureSize = FontUtils.getMaxTextureSize();
        for (id = 7; id >= 1 && FontUtils.calcTextureSize(FontUtils.getFontRes(id)) > maxTextureSize; --id) {
        }
        return id;
    }

    private static int getMaxTextureSize() {
        return GL11.glGetInteger((int)3379);
    }

    private static int calcTextureSize(int fontSize) {
        return (fontSize + FontUtils.getBorderWidth(fontSize)) * 16;
    }
}

