/*
 * Decompiled with CFR 0.152.
 */
package bre.ufex;

import bre.ufex.FontRendererHook;
import bre.ufex.FontUtils;
import bre.ufex.util.Logger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ModConfig {
    private static Configuration cfg;
    private static final String configVersion = "2";
    public static boolean debug;
    public static boolean debugLog;
    public static boolean chatMsg;
    public static boolean enableInterpolation;
    public static boolean enableAlphaBlend;
    public static boolean enableDouble;
    public static boolean excludeIntMultiple;
    public static double fontScaleRoundingTolerance;
    public static boolean excludeHighMag;
    public static double limitingMagnification;
    public static boolean alternativeInterpolation;
    public static boolean removeScaleRestriction;
    public static boolean disableSmallItalic;
    public static boolean enableMipmap;
    public static int mipmapLevel;
    public static int mipmapLodBias;
    public static int overlayLodBias;
    public static int brightness;
    public static int opacityLevel;
    public static int fontSizeBias;
    public static boolean useOSFont;
    public static String fontName;
    public static String secondaryFontName;
    public static int fontAntiAliasEx;
    public static int fontDouble;
    public static int fontResIndex;
    public static boolean fontAutoSizing;
    public static int fontSizeAdjustment;
    public static int fontGap;
    public static boolean fontAlignBaseline;
    public static boolean fontDetailList;
    public static int verticalOverhang;
    public static int horizontalOverhang;
    public static String heightAdjustChars;
    public static int shadowLength;
    public static boolean forceUnicode;
    public static String[] normalPrecisionClasses;
    public static float shadowAdjustVal;
    public static boolean compressCache;
    public static boolean configLoaded;
    public static final boolean coreDebug = false;
    private static Property debugLogProp;
    private static Property chatMsgProp;
    private static Property enableInterpolationProp;
    private static Property enableAlphaBlendProp;
    private static Property enableDoubleProp;
    private static Property excludeIntMultipleProp;
    private static Property fontScaleRoundingToleranceProp;
    private static Property excludeHighMagProp;
    private static Property limitingMagnificationProp;
    private static Property alternativeInterpolationProp;
    private static Property removeScaleRestrictionProp;
    private static Property disableSmallItalicProp;
    private static Property enableMipmapProp;
    private static Property mipmapLevelProp;
    private static Property mipmapLodBiasProp;
    private static Property overlayLodBiasProp;
    private static Property brightnessProp;
    private static Property opacityLevelProp;
    private static Property fontSizeBiasProp;
    private static Property useOSFontProp;
    private static Property fontNameProp;
    private static Property secondaryFontNameProp;
    private static Property fontAntiAliasExProp;
    private static Property fontDoubleProp;
    private static Property fontResIndexProp;
    private static Property fontAutoSizingProp;
    private static Property fontSizeAdjProp;
    private static Property fontGapProp;
    private static Property fontAlignBaselineProp;
    private static Property fontDetailListProp;
    private static Property verticalOverhangProp;
    private static Property horizontalOverhangProp;
    private static Property heightAdjustCharsProp;
    private static Property shadowLengthProp;
    private static Property forceUnicodeProp;
    private static Property normalPrecisionClassesProp;

    public static void initConfig(File configFile) {
        cfg = new Configuration(configFile, configVersion);
        cfg.setCategoryRequiresMcRestart("staticSettings", true);
        try {
            ModConfig.loadConfig();
            ModConfig.convertVersion();
        }
        catch (Exception e) {
            Logger.error("Configuration file access error.");
        }
        finally {
            ModConfig.saveConfig();
        }
        configLoaded = true;
        ModConfig.initAfterConfigLoaded();
    }

    public static void loadConfig() {
        cfg.load();
        debugLogProp = cfg.get("debug", "debugLog", false, "Enable debug log.");
        chatMsgProp = cfg.get("debug", "showLogInChat", false, "Show event log on the game screen.");
        enableInterpolationProp = cfg.get("settings", "enableInterpolation", true, "Enable linear interpolation");
        enableAlphaBlendProp = cfg.get("settings", "enableAlphaBlend", true, "Enable alpha blending");
        enableDoubleProp = cfg.get("settings", "enableDouble", false, "Enable double rendering");
        excludeIntMultipleProp = cfg.get("settings", "excludeIntMultiple", true, "Disable interpolation for the integral multiple of default size.");
        fontScaleRoundingToleranceProp = cfg.get("settings", "fontScaleRoundingTolerance", 0.5, "Tolerance (in percent) for rounding font scale to integer.(Default: 0.5)");
        excludeHighMagProp = cfg.get("settings", "excludeHighMag", true, "Disable interpolation for characters drawn with high magnification.");
        limitingMagnificationProp = cfg.get("settings", "limitingMagnification", 3.0, "Disable interpolation for fonts above this magnification when excludeHighMag is enabled.(Default: 3.0)");
        alternativeInterpolationProp = cfg.get("settings", "alternativeInterpolation", false, "Experimental: Try interpolation for MOD original font renderer.");
        removeScaleRestrictionProp = cfg.get("settings", "removeScaleRestriction", true, "Enable odd multiple GUI scale factors (x3,x5,...) with unicode font.");
        disableSmallItalicProp = cfg.get("settings", "disableSmallItalic", true, "Disable italic for small fonts.");
        enableMipmapProp = cfg.get("settings", "enableMipmap", true, "Enable mipmap for unicode fonts.");
        mipmapLevelProp = cfg.get("settings", "mipmapLevel", 4, "Mipmap level.");
        mipmapLodBiasProp = cfg.get("settings", "mipmapLodBias", -3, "Mipmap LOD bias.");
        overlayLodBiasProp = cfg.get("settings", "overlayLodBias", -10, "Mipmap LOD bias for overlay screen.");
        brightnessProp = cfg.get("settings", "brightness", 10, "Brightness level.");
        opacityLevelProp = cfg.get("settings", "opacityLevel", 8, "Opacity level.");
        fontSizeBiasProp = cfg.get("settings", "fontSizeBias", 2, "Bias by font size.(0:off, 1:low, 2:mid, 3:high)");
        useOSFontProp = cfg.get("settings", "useOSFont", false, "Use the installed fonts in the operating system.");
        fontNameProp = cfg.get("settings", "fontName", "SansSerif", "Primary system font name.");
        secondaryFontNameProp = cfg.get("settings", "secondaryFontName", "SansSerif", "Secondary system font name. It is used if the primary font cannot be displayed.");
        fontAntiAliasExProp = cfg.get("settings", "fontAntiAliasEx", 0, "Enable anti-alias for OS fonts.(0:off, 1:normal, 2:high precision)");
        fontDoubleProp = cfg.get("settings", "fontDouble", 0, "Enable double drawing for OS fonts. (0:off, 1:Ascii only, 2:Non-Ascii, 3:All)");
        fontResIndexProp = cfg.get("settings", "fontResolution", 3, "OS font resolution. (0:8px, 1:10px, 2:12px, 3:16px, 4:24px, 5:32px, 6:48px, 7:64px)");
        fontAutoSizingProp = cfg.get("settings", "fontAutoSizing", true, "Enable automatic font size detection for the font resolution.");
        fontSizeAdjProp = cfg.get("settings", "fontSizeAdjustment", 0, "OS font size. (-4:-20%, ... 0:normal, ... 4:+20%)");
        fontGapProp = cfg.get("settings", "fontGap", -2, "Font gap.");
        fontAlignBaselineProp = cfg.get("settings", "fontAlignBaseline", true, "Align baseline among different fonts.");
        fontDetailListProp = cfg.get("state", "fontDetailList", false, "Internal state.");
        verticalOverhangProp = cfg.get("settings", "verticalOverhang", 2, "Vertical overhang width.");
        horizontalOverhangProp = cfg.get("settings", "horizontalOverhang", 1, "Horizontal overhang width.");
        heightAdjustCharsProp = cfg.get("settings", "heightAdjustmentChars", "", "The size of the font is determined so that the height of these characters will not protrude.");
        shadowLengthProp = cfg.get("settings", "shadowLength", 5, "Shadow length. (0~10)");
        forceUnicodeProp = cfg.get("staticSettings", "forceUnicode", false, "Force to use unicode font.");
        normalPrecisionClassesProp = cfg.get("staticSettings", "normalPrecisionClasses", normalPrecisionClasses, "These font renderer classes use normal precision font width instead of high precision font width.\nAlthough the balance of character spacing is worse, compatibility of string width improves.");
        ModConfig.setValues();
    }

    private static void initAfterConfigLoaded() {
        for (FontRendererHook fontRendererHook : FontRendererHook.uninitFontRendererHookList) {
            fontRendererHook.initAfterConfigLoaded();
        }
    }

    private static void setValues() {
        debugLog = debugLogProp.getBoolean();
        chatMsg = chatMsgProp.getBoolean();
        enableInterpolation = enableInterpolationProp.getBoolean();
        enableAlphaBlend = enableAlphaBlendProp.getBoolean();
        enableDouble = enableDoubleProp.getBoolean();
        excludeIntMultiple = excludeIntMultipleProp.getBoolean();
        fontScaleRoundingTolerance = fontScaleRoundingToleranceProp.getDouble();
        excludeHighMag = excludeHighMagProp.getBoolean();
        limitingMagnification = limitingMagnificationProp.getDouble();
        alternativeInterpolation = alternativeInterpolationProp.getBoolean();
        removeScaleRestriction = removeScaleRestrictionProp.getBoolean();
        disableSmallItalic = disableSmallItalicProp.getBoolean();
        enableMipmap = enableMipmapProp.getBoolean();
        mipmapLevel = mipmapLevelProp.getInt();
        mipmapLodBias = mipmapLodBiasProp.getInt();
        overlayLodBias = overlayLodBiasProp.getInt();
        brightness = brightnessProp.getInt();
        opacityLevel = opacityLevelProp.getInt();
        fontSizeBias = fontSizeBiasProp.getInt();
        useOSFont = useOSFontProp.getBoolean();
        fontName = fontNameProp.getString();
        secondaryFontName = secondaryFontNameProp.getString();
        fontAntiAliasEx = fontAntiAliasExProp.getInt();
        fontDouble = fontDoubleProp.getInt();
        fontResIndex = fontResIndexProp.getInt();
        fontAutoSizing = fontAutoSizingProp.getBoolean();
        fontSizeAdjustment = fontSizeAdjProp.getInt();
        fontGap = fontGapProp.getInt();
        fontAlignBaseline = fontAlignBaselineProp.getBoolean();
        fontDetailList = fontDetailListProp.getBoolean();
        verticalOverhang = verticalOverhangProp.getInt();
        horizontalOverhang = horizontalOverhangProp.getInt();
        heightAdjustChars = heightAdjustCharsProp.getString();
        shadowLength = shadowLengthProp.getInt();
        forceUnicode = forceUnicodeProp.getBoolean();
        normalPrecisionClasses = normalPrecisionClassesProp.getStringList();
        FontRendererHook.fontSizeBiasVal = FontRendererHook.getFontSizeBiasValue(fontSizeBias);
        shadowAdjustVal = (float)(shadowLength - 5) / 10.0f;
        if (fontResIndex > FontUtils.getMaxFontSizeIndex()) {
            fontResIndex = FontUtils.getMaxFontSizeIndex();
        }
    }

    public static void saveConfig() {
        debugLogProp.setValue(debugLog);
        chatMsgProp.setValue(chatMsg);
        enableInterpolationProp.setValue(enableInterpolation);
        enableAlphaBlendProp.setValue(enableAlphaBlend);
        enableDoubleProp.setValue(enableDouble);
        excludeIntMultipleProp.setValue(excludeIntMultiple);
        fontScaleRoundingToleranceProp.setValue(fontScaleRoundingTolerance);
        excludeHighMagProp.setValue(excludeHighMag);
        limitingMagnificationProp.setValue(limitingMagnification);
        alternativeInterpolationProp.setValue(alternativeInterpolation);
        removeScaleRestrictionProp.setValue(removeScaleRestriction);
        disableSmallItalicProp.setValue(disableSmallItalic);
        enableMipmapProp.setValue(enableMipmap);
        mipmapLevelProp.setValue(mipmapLevel);
        mipmapLodBiasProp.setValue(mipmapLodBias);
        overlayLodBiasProp.setValue(overlayLodBias);
        brightnessProp.setValue(brightness);
        opacityLevelProp.setValue(opacityLevel);
        fontSizeBiasProp.setValue(fontSizeBias);
        useOSFontProp.setValue(useOSFont);
        fontNameProp.setValue(fontName);
        secondaryFontNameProp.setValue(secondaryFontName);
        fontAntiAliasExProp.setValue(fontAntiAliasEx);
        fontDoubleProp.setValue(fontDouble);
        fontResIndexProp.setValue(fontResIndex);
        fontAutoSizingProp.setValue(fontAutoSizing);
        fontSizeAdjProp.setValue(fontSizeAdjustment);
        fontGapProp.setValue(fontGap);
        fontAlignBaselineProp.setValue(fontAlignBaseline);
        fontDetailListProp.setValue(fontDetailList);
        verticalOverhangProp.setValue(verticalOverhang);
        horizontalOverhangProp.setValue(horizontalOverhang);
        heightAdjustCharsProp.setValue(heightAdjustChars);
        shadowLengthProp.setValue(shadowLength);
        forceUnicodeProp.setValue(forceUnicode);
        normalPrecisionClassesProp.setValues(normalPrecisionClasses);
        cfg.save();
    }

    public static void resetConfig() {
        enableInterpolationProp.setToDefault();
        enableAlphaBlendProp.setToDefault();
        excludeIntMultipleProp.setToDefault();
        excludeHighMagProp.setToDefault();
        alternativeInterpolationProp.setToDefault();
        removeScaleRestrictionProp.setToDefault();
        enableMipmapProp.setToDefault();
        mipmapLodBiasProp.setToDefault();
        overlayLodBiasProp.setToDefault();
        brightnessProp.setToDefault();
        opacityLevelProp.setToDefault();
        fontSizeBiasProp.setToDefault();
        useOSFontProp.setToDefault();
        fontNameProp.setToDefault();
        secondaryFontNameProp.setToDefault();
        fontAntiAliasExProp.setToDefault();
        fontDoubleProp.setToDefault();
        fontResIndexProp.setToDefault();
        fontAutoSizingProp.setToDefault();
        fontSizeAdjProp.setToDefault();
        fontGapProp.setToDefault();
        fontAlignBaselineProp.setToDefault();
        fontDetailListProp.setToDefault();
        heightAdjustCharsProp.setToDefault();
        shadowLengthProp.setToDefault();
        forceUnicodeProp.setToDefault();
        ModConfig.setValues();
        cfg.save();
    }

    private static void convertVersion() {
        if (cfg.getLoadedConfigVersion() == null) {
            if (fontResIndex == 0) {
                fontResIndex = 1;
            } else if (fontResIndex >= 1) {
                fontResIndex += 2;
            }
            fontSizeAdjustment *= 2;
            if (cfg.hasKey("settings", "fontAntiAlias")) {
                Property fontAntiAliasProp = cfg.get("settings", "fontAntiAlias", false);
                fontAntiAliasEx = fontAntiAliasProp.getBoolean() ? 1 : 0;
                cfg.moveProperty("settings", "fontAntiAlias", "work");
                cfg.removeCategory(cfg.getCategory("work"));
            }
        }
        ModConfig.removeKey("settings", "smallFontOnly");
        ModConfig.removeKey("settings", "fontScaleLimit");
        ModConfig.removeKey("settings", "overlayScreenOnly");
        if (fontResIndex > FontUtils.getMaxFontSizeIndex()) {
            fontResIndex = FontUtils.getMaxFontSizeIndex();
        }
    }

    private static void removeKey(String category, String key) {
        if (cfg.hasKey(category, key)) {
            cfg.moveProperty(category, key, "work");
            cfg.removeCategory(cfg.getCategory("work"));
        }
    }

    static {
        debug = false;
        normalPrecisionClasses = new String[0];
        compressCache = false;
        configLoaded = false;
    }
}

