/*
 * Decompiled with CFR 0.152.
 */
package bre.ufex.gui;

import bre.ufex.FontRasterizer;
import bre.ufex.FontRendererHook;
import bre.ufex.FontTextureManager;
import bre.ufex.ModConfig;
import bre.ufex.gui.GuiCommon;
import bre.ufex.gui.GuiFontSelection;
import bre.ufex.gui.GuiSliderEx;
import com.mojang.realmsclient.gui.ChatFormatting;
import cpw.mods.fml.client.config.GuiSlider;
import cpw.mods.fml.client.config.HoverChecker;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiConfigScreen
extends GuiScreen
implements GuiYesNoCallback {
    private static final int dx = -160;
    private static final int btnGap = 4;
    private static final int bx = 158;
    private static final int by = 20;
    private static final int rowOfParts = 8;
    private static final int gridHeight = 24;
    private static final int sampleHeight = 50;
    private int baseY;
    private static int prevX;
    private static int prevY;
    private GuiScreen parentScreen;
    private HoverChecker[] buttonHover = new HoverChecker[GuiPart.values().length];
    private static final int tooltipTimer = 500;
    private int excludeCondition;

    public GuiConfigScreen(GuiScreen parent) {
        this.parentScreen = parent;
        this.excludeCondition = (ModConfig.excludeHighMag ? 2 : 0) + (ModConfig.excludeIntMultiple ? 1 : 0);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.baseY = this.field_146295_m / 2 - 121;
        this.field_146292_n.add(this.arrangeHalfButton(GuiPart.BTN_ENABLE_INTERPOLATION, I18n.func_135052_a((String)"ufex.config.menu.enableInterpolation", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(ModConfig.enableInterpolation)));
        this.field_146292_n.add(this.arrangeHalfButton(GuiPart.BTN_ENABLE_ALPHABLEND, I18n.func_135052_a((String)"ufex.config.menu.enableAlphaBlend", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(ModConfig.enableAlphaBlend)));
        this.field_146292_n.add(this.arrangeHalfSlider(GuiPart.SLD_BRIGHTNESS, I18n.func_135052_a((String)"ufex.config.menu.brightness", (Object[])new Object[0]) + ": ", -10, 20, ModConfig.brightness, null, 0));
        this.field_146292_n.add(this.arrangeHalfSlider(GuiPart.SLD_OPACITY, I18n.func_135052_a((String)"ufex.config.menu.opacityLevel", (Object[])new Object[0]) + ": ", -10, 20, ModConfig.opacityLevel, null, 0));
        this.field_146292_n.add(this.arrangeHalfButton(GuiPart.BTN_FONT_SIZE_BIAS, I18n.func_135052_a((String)"ufex.config.menu.fontSizeBias", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("ufex.config.fontSizeBiasValue" + ModConfig.fontSizeBias), (Object[])new Object[0])));
        this.field_146292_n.add(this.arrangeHalfButton(GuiPart.BTN_ENABLE_MIPMAP, I18n.func_135052_a((String)"ufex.config.menu.enableMipmap", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(ModConfig.enableMipmap)));
        this.field_146292_n.add(this.arrangeHalfSlider(GuiPart.SLD_MIPMAP_LOD_BIAS, I18n.func_135052_a((String)"ufex.config.menu.mipmapLodBias", (Object[])new Object[0]) + ": ", -10, 10, ModConfig.mipmapLodBias, null, 0));
        this.field_146292_n.add(this.arrangeHalfSlider(GuiPart.SLD_OVERLAY_LOD_BIAS, I18n.func_135052_a((String)"ufex.config.menu.overlayLodBias", (Object[])new Object[0]) + ": ", -10, 10, ModConfig.overlayLodBias, null, 0));
        this.field_146292_n.add(this.arrangeHalfButton(GuiPart.BTN_EXCLUDE_CONDITION, I18n.func_135052_a((String)("ufex.config.menu.excludeCondition." + this.excludeCondition), (Object[])new Object[0])));
        this.field_146292_n.add(this.arrangeHalfSlider(GuiPart.SLD_SHADOW_LENGTH, I18n.func_135052_a((String)"ufex.config.menu.shadowLength", (Object[])new Object[0]) + ": ", 0, 20, ModConfig.shadowLength, I18n.func_135052_a((String)"ufex.config.menu.shadowLengthNormal", (Object[])new Object[0]), 5));
        int btnWidth = (Math.abs(-160) * 2 - 8) / 3;
        int id = GuiPart.BTN_FORCE_UNICODE.ordinal();
        GuiButton button = new GuiButton(id, this.field_146294_l / 2 + -160, this.baseY + 24 * ((id >>> 1) + 1), btnWidth, 20, I18n.func_135052_a((String)"ufex.config.menu.forceUnicode", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(ModConfig.forceUnicode));
        this.field_146292_n.add(button);
        this.buttonHover[id] = new HoverChecker(button, 500);
        id = GuiPart.BTN_ALTERNATIVE_INTERPOLATION.ordinal();
        button = new GuiButton(id, this.field_146294_l / 2 + -160 + btnWidth + 4, this.baseY + 24 * ((id - 1 >>> 1) + 1), btnWidth, 20, I18n.func_135052_a((String)"ufex.config.menu.alternativeInterpolation", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(ModConfig.alternativeInterpolation));
        this.field_146292_n.add(button);
        this.buttonHover[id] = new HoverChecker(button, 500);
        id = GuiPart.BTN_REMOVE_SCALE_RESTRICTION.ordinal();
        button = new GuiButton(id, this.field_146294_l / 2 + -160 + (btnWidth + 4) * 2, this.baseY + 24 * ((id - 2 >>> 1) + 1), btnWidth, 20, I18n.func_135052_a((String)"ufex.config.menu.removeScaleRestriction", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(ModConfig.removeScaleRestriction));
        this.field_146292_n.add(button);
        this.buttonHover[id] = new HoverChecker(button, 500);
        id = GuiPart.BTN_FONT.ordinal();
        button = new GuiButton(id, this.field_146294_l / 2 + -160, this.baseY + 24 * ((id >>> 1) + 1), btnWidth, 20, I18n.func_135052_a((String)"ufex.config.menu.font", (Object[])new Object[0]));
        this.field_146292_n.add(button);
        this.buttonHover[id] = new HoverChecker(button, 500);
        id = GuiPart.BTN_DEFAULT.ordinal();
        button = new GuiButton(id, this.field_146294_l / 2 + -160 + btnWidth + 4, this.baseY + 24 * ((id - 1 >>> 1) + 1), btnWidth, 20, I18n.func_135052_a((String)"ufex.config.menu.default", (Object[])new Object[0]));
        this.field_146292_n.add(button);
        this.buttonHover[id] = new HoverChecker(button, 500);
        id = GuiPart.BTN_EXIT.ordinal();
        button = new GuiButton(id, this.field_146294_l / 2 + -160 + (btnWidth + 4) * 2, this.baseY + 24 * ((id - 2 >>> 1) + 1), btnWidth, 20, I18n.func_135052_a((String)"ufex.config.menu.exit", (Object[])new Object[0]));
        this.field_146292_n.add(button);
        this.buttonHover[id] = new HoverChecker(button, 500);
    }

    private GuiButton arrangeHalfButton(GuiPart guiPart, String buttonLabel) {
        int id = guiPart.ordinal();
        GuiButton button = new GuiButton(id, this.field_146294_l / 2 + ((id & 1) == 0 ? -160 : 2), this.baseY + 24 * ((id >>> 1) + 1), 158, 20, buttonLabel);
        this.buttonHover[id] = new HoverChecker(button, 500);
        return button;
    }

    private GuiSliderEx arrangeHalfSlider(GuiPart guiPart, String sliderLabel, int minVal, int maxVal, int curVal, String normalStr, int normalVal) {
        int id = guiPart.ordinal();
        GuiSliderEx slider = new GuiSliderEx(id, this.field_146294_l / 2 + ((id & 1) == 0 ? -160 : 2), this.baseY + 24 * ((id >>> 1) + 1), 158, 20, sliderLabel, "", minVal, maxVal, curVal, false, true, normalStr, normalVal){

            protected void func_146119_b(Minecraft mc, int par1, int par2) {
                super.func_146119_b(mc, par1, par2);
                if (this.dragging) {
                    GuiConfigScreen.this.func_146284_a((GuiButton)this);
                }
            }
        };
        this.buttonHover[id] = new HoverChecker((GuiButton)slider, 500);
        return slider;
    }

    public void func_146284_a(GuiButton button) {
        GuiPart[] guiPartArray = GuiPart.values();
        GuiPart guiPart = guiPartArray[button.field_146127_k];
        switch (guiPart) {
            case BTN_ENABLE_INTERPOLATION: {
                ModConfig.enableInterpolation = !ModConfig.enableInterpolation;
                button.field_146126_j = I18n.func_135052_a((String)"ufex.config.menu.enableInterpolation", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(ModConfig.enableInterpolation);
                ModConfig.saveConfig();
                break;
            }
            case BTN_ENABLE_ALPHABLEND: {
                ModConfig.enableAlphaBlend = !ModConfig.enableAlphaBlend;
                button.field_146126_j = I18n.func_135052_a((String)"ufex.config.menu.enableAlphaBlend", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(ModConfig.enableAlphaBlend);
                ModConfig.saveConfig();
                break;
            }
            case SLD_BRIGHTNESS: {
                ModConfig.brightness = ((GuiSlider)button).getValueInt();
                ModConfig.saveConfig();
                break;
            }
            case SLD_OPACITY: {
                ModConfig.opacityLevel = ((GuiSlider)button).getValueInt();
                ModConfig.saveConfig();
                break;
            }
            case BTN_FONT_SIZE_BIAS: {
                if (++ModConfig.fontSizeBias >= 4) {
                    ModConfig.fontSizeBias = 0;
                }
                button.field_146126_j = I18n.func_135052_a((String)"ufex.config.menu.fontSizeBias", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)("ufex.config.fontSizeBiasValue" + ModConfig.fontSizeBias), (Object[])new Object[0]);
                FontRendererHook.fontSizeBiasVal = FontRendererHook.getFontSizeBiasValue(ModConfig.fontSizeBias);
                ModConfig.saveConfig();
                break;
            }
            case BTN_ENABLE_MIPMAP: {
                ModConfig.enableMipmap = !ModConfig.enableMipmap;
                button.field_146126_j = I18n.func_135052_a((String)"ufex.config.menu.enableMipmap", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(ModConfig.enableMipmap);
                ModConfig.saveConfig();
                break;
            }
            case SLD_MIPMAP_LOD_BIAS: {
                ModConfig.mipmapLodBias = ((GuiSlider)button).getValueInt();
                ModConfig.saveConfig();
                break;
            }
            case SLD_OVERLAY_LOD_BIAS: {
                ModConfig.overlayLodBias = ((GuiSlider)button).getValueInt();
                ModConfig.saveConfig();
                break;
            }
            case BTN_EXCLUDE_CONDITION: {
                ++this.excludeCondition;
                if (this.excludeCondition >= 4) {
                    this.excludeCondition = 0;
                }
                button.field_146126_j = I18n.func_135052_a((String)("ufex.config.menu.excludeCondition." + this.excludeCondition), (Object[])new Object[0]);
                ModConfig.excludeIntMultiple = (this.excludeCondition & 1) == 1;
                ModConfig.excludeHighMag = (this.excludeCondition & 2) == 2;
                ModConfig.saveConfig();
                break;
            }
            case SLD_SHADOW_LENGTH: {
                ModConfig.shadowLength = ((GuiSlider)button).getValueInt();
                ModConfig.shadowAdjustVal = (float)(ModConfig.shadowLength - 5) / 10.0f;
                ModConfig.saveConfig();
                break;
            }
            case BTN_FORCE_UNICODE: {
                ModConfig.forceUnicode = !ModConfig.forceUnicode;
                button.field_146126_j = I18n.func_135052_a((String)"ufex.config.menu.forceUnicode", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(ModConfig.forceUnicode);
                ModConfig.saveConfig();
                if (!ModConfig.forceUnicode) break;
                FontTextureManager.getInstance().setUnicodeFlagAll();
                break;
            }
            case BTN_ALTERNATIVE_INTERPOLATION: {
                ModConfig.alternativeInterpolation = !ModConfig.alternativeInterpolation;
                button.field_146126_j = I18n.func_135052_a((String)"ufex.config.menu.alternativeInterpolation", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(ModConfig.alternativeInterpolation);
                ModConfig.saveConfig();
                this.field_146297_k.func_110436_a();
                break;
            }
            case BTN_REMOVE_SCALE_RESTRICTION: {
                ModConfig.removeScaleRestriction = !ModConfig.removeScaleRestriction;
                button.field_146126_j = I18n.func_135052_a((String)"ufex.config.menu.removeScaleRestriction", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(ModConfig.removeScaleRestriction);
                ModConfig.saveConfig();
                ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
                int x = scaledresolution.func_78326_a();
                int y = scaledresolution.func_78328_b();
                this.func_146280_a(this.field_146297_k, x, y);
                break;
            }
            case BTN_FONT: {
                GuiFontSelection guiFontSelection = new GuiFontSelection(this);
                this.field_146297_k.func_147108_a((GuiScreen)guiFontSelection);
                break;
            }
            case BTN_DEFAULT: {
                GuiYesNo guiYesNo = new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"ufex.key.categories.UnicodeFontExtension", (Object[])new Object[0]), I18n.func_135052_a((String)"ufex.config.menu.default.yesno", (Object[])new Object[0]), 0);
                this.field_146297_k.func_147108_a((GuiScreen)guiYesNo);
                break;
            }
            case BTN_EXIT: {
                this.field_146297_k.func_147108_a(this.parentScreen);
                if (this.parentScreen != null) break;
                this.field_146297_k.func_71381_h();
                break;
            }
        }
    }

    public void func_73878_a(boolean result, int id) {
        switch (id) {
            case 0: {
                if (!result) break;
                boolean curAltInterpolation = ModConfig.alternativeInterpolation;
                boolean curUseOSFont = ModConfig.useOSFont;
                ModConfig.resetConfig();
                FontRendererHook.fontSizeBiasVal = FontRendererHook.getFontSizeBiasValue(ModConfig.fontSizeBias);
                this.func_73866_w_();
                if (curUseOSFont != ModConfig.useOSFont) {
                    FontTextureManager.getInstance().clearMapTextureObjects();
                    FontRasterizer.getInstance().clearFontCache();
                    this.field_146297_k.func_110436_a();
                } else if (curAltInterpolation != ModConfig.alternativeInterpolation) {
                    this.field_146297_k.func_110436_a();
                }
                ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
                int x = scaledresolution.func_78326_a();
                int y = scaledresolution.func_78328_b();
                this.func_146280_a(this.field_146297_k, x, y);
                break;
            }
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    public void func_146286_b(int mouseX, int mouseY, int which) {
        super.func_146286_b(mouseX, mouseY, which);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"ufex.key.categories.UnicodeFontExtension", (Object[])new Object[0]), this.field_146294_l / 2, this.baseY + 8, 0xFFFFFF);
        this.drawSamples(this.field_146294_l / 2, this.baseY + 192);
        this.drawWarningMessage(2, this.field_146295_m - 18);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawTooltip(mouseX, mouseY);
    }

    private void drawWarningMessage(int posX, int posY) {
        if (!FontRendererHook.isHookWorked1 || !FontRendererHook.isHookWorked2 && this.field_146297_k.func_152349_b()) {
            GuiConfigScreen.func_73734_a((int)posX, (int)posY, (int)(posX + this.field_146294_l), (int)(posY + 18), (int)-536870912);
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"ufex.msg.notWorking", (Object[])new Object[0]), posX, posY, 0xFF0000);
            if (Loader.isModLoaded((String)"FastCraft")) {
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"ufex.msg.detectFastCraft", (Object[])new Object[0]), posX, posY + 9, 0xFF0000);
            }
        }
    }

    private void drawSampleStringCentered(int posX, int posY, float scale) {
        ScaledResolution scaledRes = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        float fontRes = FontRasterizer.getInstance().getFontRes();
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)0.0f);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"language.name", (Object[])new Object[0]) + String.format(" ABCabc123 (x%.2f)", Float.valueOf((float)(scaledRes.func_78325_e() * 8) / fontRes * scale)), (int)((float)posX / scale), (int)((float)posY / scale), 0xFFFFFF);
        GL11.glPopMatrix();
    }

    private void drawSamples(int posX, int posY) {
        int h = 10;
        int y = posY;
        this.drawSampleStringCentered(posX, y, 0.5f);
        y = (int)((float)y + 5.0f);
        this.drawSampleStringCentered(posX, y, 1.0f);
        y = (int)((float)y + 10.0f);
        this.drawSampleStringCentered(posX, y, 1.5f);
        y = (int)((float)y + 15.0f);
        this.drawSampleStringCentered(posX, y, 2.0f);
        y = (int)((float)y + 20.0f);
    }

    public boolean func_73868_f() {
        return true;
    }

    private void drawTooltip(int mouseX, int mouseY) {
        for (GuiPart gp : GuiPart.values()) {
            if (this.buttonHover[gp.ordinal()] == null || !this.buttonHover[gp.ordinal()].checkHover(mouseX, mouseY)) continue;
            if (mouseX != prevX || mouseY != prevY) {
                this.buttonHover[gp.ordinal()].resetHoverTimer();
            } else {
                switch (gp) {
                    case BTN_ENABLE_INTERPOLATION: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"ufex.tooltip.enableInterpolation", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case BTN_ENABLE_ALPHABLEND: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"ufex.tooltip.enableAlphaBlend", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case SLD_BRIGHTNESS: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"ufex.tooltip.brightness", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case SLD_OPACITY: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"ufex.tooltip.opacityLevel", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case BTN_FONT_SIZE_BIAS: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"ufex.tooltip.fontSizeBias", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case BTN_ENABLE_MIPMAP: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"ufex.tooltip.enableMipmap", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case SLD_MIPMAP_LOD_BIAS: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"ufex.tooltip.mipmapLodBias", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case SLD_OVERLAY_LOD_BIAS: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"ufex.tooltip.overlayLodBias", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case BTN_EXCLUDE_CONDITION: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"ufex.tooltip.excludeCondition", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case BTN_FORCE_UNICODE: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"ufex.tooltip.forceUnicode", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case BTN_ALTERNATIVE_INTERPOLATION: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"ufex.tooltip.alternativeInterpolation", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case BTN_REMOVE_SCALE_RESTRICTION: {
                        this.func_146283_a(this.strToList(I18n.func_135052_a((String)"ufex.tooltip.removeScaleRestriction", (Object[])new Object[0])), mouseX, mouseY);
                        break;
                    }
                    case BTN_FONT: 
                    case BTN_DEFAULT: 
                    case BTN_EXIT: {
                        break;
                    }
                }
            }
            prevX = mouseX;
            prevY = mouseY;
        }
    }

    private List strToList(String str) {
        ArrayList<String> list = new ArrayList<String>();
        String[] strs = str.split("\\\\n");
        list.add(strs[0]);
        for (int i = 1; i < strs.length; ++i) {
            list.add(ChatFormatting.GRAY + strs[i]);
        }
        return list;
    }

    private static enum GuiPart {
        BTN_ENABLE_INTERPOLATION,
        BTN_ENABLE_ALPHABLEND,
        SLD_BRIGHTNESS,
        SLD_OPACITY,
        BTN_FONT_SIZE_BIAS,
        BTN_ENABLE_MIPMAP,
        SLD_MIPMAP_LOD_BIAS,
        SLD_OVERLAY_LOD_BIAS,
        BTN_EXCLUDE_CONDITION,
        SLD_SHADOW_LENGTH,
        BTN_FORCE_UNICODE,
        BTN_ALTERNATIVE_INTERPOLATION,
        BTN_REMOVE_SCALE_RESTRICTION,
        BTN_FONT,
        BTN_DEFAULT,
        BTN_EXIT;

    }
}

