/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.controller;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import mod.pbj.client.controller.BlendingAnimationController;
import mod.pbj.mixin.AnimatableManagerAccessor;
import mod.pbj.mixin.AnimationControllerAccessor;
import mod.pbj.util.AnimationPointInfo2;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationProcessor;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.EasingType;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.AnimationPoint;
import software.bernie.geckolib.animation.keyframe.BoneAnimation;
import software.bernie.geckolib.animation.keyframe.BoneAnimationQueue;
import software.bernie.geckolib.animation.keyframe.event.data.CustomInstructionKeyframeData;
import software.bernie.geckolib.animation.keyframe.event.data.ParticleKeyframeData;
import software.bernie.geckolib.animation.keyframe.event.data.SoundKeyframeData;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;

public class BlendingAnimationProcessor<T extends GeoAnimatable>
extends AnimationProcessor<T> {
    private final Map<String, GeoBone> bones = new Object2ObjectOpenHashMap();
    private final GeoModel<T> model;
    public boolean reloadAnimations = false;
    static final String WAIT = "internal.wait";

    public BlendingAnimationProcessor(GeoModel<T> model) {
        super(null);
        this.model = model;
    }

    public Queue<AnimationProcessor.QueuedAnimation> buildAnimationQueue(T animatable, RawAnimation rawAnimation) {
        LinkedList<AnimationProcessor.QueuedAnimation> animations = new LinkedList<AnimationProcessor.QueuedAnimation>();
        boolean error = false;
        for (RawAnimation.Stage stage : rawAnimation.getAnimationStages()) {
            Animation animation = stage.animationName().equals(WAIT) ? BlendingAnimationProcessor.generateWaitAnimation(stage.additionalTicks()) : this.model.getAnimation(animatable, stage.animationName());
            if (animation == null) {
                System.out.println("Unable to find animation: " + stage.animationName() + " for " + animatable.getClass().getSimpleName());
                error = true;
                continue;
            }
            animations.add(new AnimationProcessor.QueuedAnimation(animation, stage.loopType()));
        }
        return error ? null : animations;
    }

    static Animation generateWaitAnimation(double length) {
        return new Animation(WAIT, length, Animation.LoopType.PLAY_ONCE, new BoneAnimation[0], new Animation.Keyframes(new SoundKeyframeData[0], new ParticleKeyframeData[0], new CustomInstructionKeyframeData[0]));
    }

    public void tickAnimation(T animatable, GeoModel<T> model, AnimatableManager<T> animatableManager, double animTime, AnimationState<T> state, boolean crashWhenCantFindBone) {
        Minecraft mc = Minecraft.getInstance();
        long ts = System.currentTimeMillis() % 10000L;
        LinkedHashMap<GeoBone, Map> animationPoints = new LinkedHashMap<GeoBone, Map>();
        Map<String, BoneSnapshot> globalBoneSnapshots = this.updateBoneSnapshots(animatableManager.getBoneSnapshotCollection());
        Set snapshotSets = Collections.newSetFromMap(new IdentityHashMap());
        snapshotSets.add(globalBoneSnapshots);
        for (AnimationController controller : animatableManager.getAnimationControllers().values()) {
            if (this.reloadAnimations) {
                controller.forceAnimationReset();
                controller.getBoneAnimationQueues().clear();
            }
            AnimationControllerAccessor controllerExt = (AnimationControllerAccessor)controller;
            controllerExt.setIsJustStarting(animatableManager.isFirstTick());
            state.withController(controller);
            controller.process(model, state, this.bones, globalBoneSnapshots, animTime, crashWhenCantFindBone);
            for (BoneAnimationQueue boneAnimation : controller.getBoneAnimationQueues().values()) {
                GeoBone bone = boneAnimation.bone();
                AnimationPoint rotXPoint = (AnimationPoint)boneAnimation.rotationXQueue().poll();
                AnimationPoint rotYPoint = (AnimationPoint)boneAnimation.rotationYQueue().poll();
                AnimationPoint rotZPoint = (AnimationPoint)boneAnimation.rotationZQueue().poll();
                AnimationPoint posXPoint = (AnimationPoint)boneAnimation.positionXQueue().poll();
                AnimationPoint posYPoint = (AnimationPoint)boneAnimation.positionYQueue().poll();
                AnimationPoint posZPoint = (AnimationPoint)boneAnimation.positionZQueue().poll();
                AnimationPoint scaleXPoint = (AnimationPoint)boneAnimation.scaleXQueue().poll();
                AnimationPoint scaleYPoint = (AnimationPoint)boneAnimation.scaleYQueue().poll();
                AnimationPoint scaleZPoint = (AnimationPoint)boneAnimation.scaleZQueue().poll();
                EasingType easingType = controllerExt.getOverrideEasingTypeFunction().apply(animatable);
                AnimationPointInfo2 info = new AnimationPointInfo2(easingType);
                if (rotXPoint != null && rotYPoint != null && rotZPoint != null) {
                    info.setRotXPoint(rotXPoint);
                    info.setRotYPoint(rotYPoint);
                    info.setRotZPoint(rotZPoint);
                }
                if (posXPoint != null && posYPoint != null && posZPoint != null) {
                    info.setPosXPoint(posXPoint);
                    info.setPosYPoint(posYPoint);
                    info.setPosZPoint(posZPoint);
                }
                if (scaleXPoint != null && scaleYPoint != null && scaleZPoint != null) {
                    info.setScaleXPoint(scaleXPoint);
                    info.setScaleYPoint(scaleYPoint);
                    info.setScaleZPoint(scaleZPoint);
                }
                if (!info.isPositionChanged() && !info.isRotationChanged() && !info.isScaleChanged()) continue;
                Map boneAnimationPoints = animationPoints.computeIfAbsent(bone, b -> new HashMap());
                String controllerName = controller instanceof BlendingAnimationController ? controller.getName() : "_default";
                boneAnimationPoints.put(controllerName, info);
            }
        }
        this.reloadAnimations = false;
        double resetTickLength = animatable.getBoneResetTime();
        for (Map.Entry e : animationPoints.entrySet()) {
            Map pointInfoByControllers = (Map)e.getValue();
            if (pointInfoByControllers == null) continue;
            double rotXPoint = 0.0;
            double rotYPoint = 0.0;
            double rotZPoint = 0.0;
            double posXPoint = 0.0;
            double posYPoint = 0.0;
            double posZPoint = 0.0;
            double scaleXPoint = 0.0;
            double scaleYPoint = 0.0;
            double scaleZPoint = 0.0;
            boolean rotationChanged = false;
            boolean positionChanged = false;
            boolean scaleChanged = false;
            for (Map.Entry e2 : pointInfoByControllers.entrySet()) {
                AnimationPointInfo2 pointInfo = (AnimationPointInfo2)e2.getValue();
                if (pointInfo.isRotationChanged()) {
                    rotXPoint += (double)((float)EasingType.lerpWithOverride((AnimationPoint)pointInfo.getRotXPoint(), (EasingType)pointInfo.getEasingType()));
                    rotYPoint += (double)((float)EasingType.lerpWithOverride((AnimationPoint)pointInfo.getRotYPoint(), (EasingType)pointInfo.getEasingType()));
                    rotZPoint += (double)((float)EasingType.lerpWithOverride((AnimationPoint)pointInfo.getRotZPoint(), (EasingType)pointInfo.getEasingType()));
                    rotationChanged = true;
                }
                if (pointInfo.isPositionChanged()) {
                    posXPoint += (double)((float)EasingType.lerpWithOverride((AnimationPoint)pointInfo.getPosXPoint(), (EasingType)pointInfo.getEasingType()));
                    posYPoint += (double)((float)EasingType.lerpWithOverride((AnimationPoint)pointInfo.getPosYPoint(), (EasingType)pointInfo.getEasingType()));
                    posZPoint += (double)((float)EasingType.lerpWithOverride((AnimationPoint)pointInfo.getPosZPoint(), (EasingType)pointInfo.getEasingType()));
                    positionChanged = true;
                }
                if (!pointInfo.isScaleChanged()) continue;
                scaleXPoint += (double)((float)EasingType.lerpWithOverride((AnimationPoint)pointInfo.getScaleXPoint(), (EasingType)pointInfo.getEasingType()));
                scaleYPoint += (double)((float)EasingType.lerpWithOverride((AnimationPoint)pointInfo.getScaleYPoint(), (EasingType)pointInfo.getEasingType()));
                scaleZPoint += (double)((float)EasingType.lerpWithOverride((AnimationPoint)pointInfo.getScaleZPoint(), (EasingType)pointInfo.getEasingType()));
                scaleChanged = true;
            }
            GeoBone bone = this.bones.get(((GeoBone)e.getKey()).getName());
            BoneSnapshot snapshot = globalBoneSnapshots.get(bone.getName());
            if (rotationChanged) {
                BoneSnapshot initialSnapshot = bone.getInitialSnapshot();
                bone.setRotX((float)rotXPoint + initialSnapshot.getRotX());
                bone.setRotY((float)rotYPoint + initialSnapshot.getRotY());
                bone.setRotZ((float)rotZPoint + initialSnapshot.getRotZ());
                snapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                snapshot.startRotAnim();
                bone.markRotationAsChanged();
            }
            if (positionChanged) {
                bone.setPosX((float)posXPoint);
                bone.setPosY((float)posYPoint);
                bone.setPosZ((float)posZPoint);
                snapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                snapshot.startPosAnim();
                bone.markPositionAsChanged();
            }
            if (!scaleChanged) continue;
            bone.setScaleX((float)scaleXPoint);
            bone.setScaleY((float)scaleYPoint);
            bone.setScaleZ((float)scaleZPoint);
            snapshot.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
            snapshot.startScaleAnim();
            bone.markScaleAsChanged();
        }
        this.resetBones(this.getRegisteredBones(), globalBoneSnapshots, animatableManager, animTime, resetTickLength);
        ((AnimatableManagerAccessor)animatableManager).setIsFirstTick(false);
    }

    private void resetBones(Collection<GeoBone> bones, Map<String, BoneSnapshot> boneSnapshots, AnimatableManager<T> animatableManager, double animTime, double resetTickLength) {
        Minecraft mc = Minecraft.getInstance();
        long ts = System.currentTimeMillis() % 10000L;
        for (GeoBone bone : bones) {
            double percentageReset;
            BoneSnapshot saveSnapshot;
            BoneSnapshot initialSnapshot;
            if (!bone.hasRotationChanged()) {
                initialSnapshot = bone.getInitialSnapshot();
                saveSnapshot = boneSnapshots.get(bone.getName());
                if (saveSnapshot == null) continue;
                if (saveSnapshot.isRotAnimInProgress()) {
                    saveSnapshot.stopRotAnim(animTime);
                }
                percentageReset = Math.min((animTime - saveSnapshot.getLastResetRotationTick()) / resetTickLength, 1.0);
                bone.setRotX((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getRotX(), (double)initialSnapshot.getRotX()));
                bone.setRotY((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getRotY(), (double)initialSnapshot.getRotY()));
                bone.setRotZ((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getRotZ(), (double)initialSnapshot.getRotZ()));
                if (percentageReset >= 1.0) {
                    saveSnapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                }
            }
            if (!bone.hasPositionChanged()) {
                initialSnapshot = bone.getInitialSnapshot();
                saveSnapshot = boneSnapshots.get(bone.getName());
                if (saveSnapshot.isPosAnimInProgress()) {
                    saveSnapshot.stopPosAnim(animTime);
                }
                percentageReset = Math.min((animTime - saveSnapshot.getLastResetPositionTick()) / resetTickLength, 1.0);
                bone.setPosX((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getOffsetX(), (double)initialSnapshot.getOffsetX()));
                bone.setPosY((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getOffsetY(), (double)initialSnapshot.getOffsetY()));
                bone.setPosZ((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getOffsetZ(), (double)initialSnapshot.getOffsetZ()));
                if (percentageReset >= 1.0) {
                    saveSnapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                }
            }
            if (bone.hasScaleChanged()) continue;
            initialSnapshot = bone.getInitialSnapshot();
            saveSnapshot = boneSnapshots.get(bone.getName());
            if (saveSnapshot.isScaleAnimInProgress()) {
                saveSnapshot.stopScaleAnim(animTime);
            }
            percentageReset = Math.min((animTime - saveSnapshot.getLastResetScaleTick()) / resetTickLength, 1.0);
            bone.setScaleX((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getScaleX(), (double)initialSnapshot.getScaleX()));
            bone.setScaleY((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getScaleY(), (double)initialSnapshot.getScaleY()));
            bone.setScaleZ((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getScaleZ(), (double)initialSnapshot.getScaleZ()));
            if (!(percentageReset >= 1.0)) continue;
            saveSnapshot.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
        }
        BlendingAnimationProcessor.resetBoneTransformationMarkers(bones);
    }

    private static void resetBoneTransformationMarkers(Collection<GeoBone> bones) {
        bones.forEach(GeoBone::resetStateChanges);
    }

    private Map<String, BoneSnapshot> updateBoneSnapshots(Map<String, BoneSnapshot> snapshots) {
        for (GeoBone bone : this.getRegisteredBones()) {
            if (snapshots.containsKey(bone.getName())) continue;
            snapshots.put(bone.getName(), BoneSnapshot.copy((BoneSnapshot)bone.getInitialSnapshot()));
        }
        return snapshots;
    }

    public GeoBone getBone(String boneName) {
        return this.bones.get(boneName);
    }

    public void registerGeoBone(GeoBone bone) {
        bone.saveInitialSnapshot();
        this.bones.put(bone.getName(), bone);
        for (GeoBone child : bone.getChildBones()) {
            this.registerGeoBone(child);
        }
    }

    public void setActiveModel(BakedGeoModel model) {
        this.bones.clear();
        for (GeoBone bone : model.topLevelBones()) {
            this.registerGeoBone(bone);
        }
    }

    public Collection<GeoBone> getRegisteredBones() {
        return this.bones.values();
    }

    public void preAnimationSetup(AnimationState<T> animationState, double animTime) {
        this.model.applyMolangQueries(animationState, animTime);
    }
}

