/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import mod.pbj.client.GunClientState;
import mod.pbj.client.render.RenderUtil;
import mod.pbj.item.FireModeInstance;
import mod.pbj.item.GunItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GunItemOverlay {
    private static final ResourceLocation OVERLAY_RESOURCE = ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"textures/gui/ammo.png");

    public static void renderGunOverlay(GuiGraphics guiGraphics, ItemStack stack) {
        int messageColor;
        Minecraft mc = Minecraft.getInstance();
        int slotIndex = mc.player.getInventory().selected;
        GunClientState gunClientState = GunClientState.getState((Player)mc.player, stack, slotIndex, false);
        if (gunClientState == null) {
            return;
        }
        Component message = gunClientState.getCurrentMessage();
        if (message != null) {
            messageColor = 0xDDFF00;
        } else {
            FireModeInstance fireModeInstance = GunItem.getFireModeInstance(stack);
            int currentAmmo = gunClientState.getAmmoCount(fireModeInstance);
            GunItem gunItem = (GunItem)stack.getItem();
            int maxAmmo = gunItem.getMaxAmmoCapacity(stack, fireModeInstance);
            message = maxAmmo == Integer.MAX_VALUE ? Component.literal((String)"\u221e") : Component.literal((String)String.format("%d/%d", currentAmmo, maxAmmo));
            messageColor = 0xFFFF00;
        }
        Font font = mc.font;
        int screenX = mc.getWindow().getGuiScaledWidth();
        guiGraphics.drawString(font, message, screenX - font.width((FormattedText)message) - 10, 10, messageColor, false);
    }

    public static void renderGunOverlay2(GuiGraphics guiGraphics, ItemStack stack) {
        int textureWidth = 160;
        int textureHeight = 32;
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        Minecraft mc = Minecraft.getInstance();
        FireModeInstance fireModeInstance = GunItem.getFireModeInstance(stack);
        if (fireModeInstance == null) {
            return;
        }
        String fireModeDisplayName = fireModeInstance.getDisplayName().getString();
        int width = 9 + mc.font.width(fireModeDisplayName);
        int height = 22;
        int vOffset = mc.getWindow().getGuiScaledHeight() - height;
        int hOffset = (mc.getWindow().getGuiScaledWidth() >> 1) + 97;
        RenderUtil.blitNineSliced(guiGraphics, OVERLAY_RESOURCE, hOffset, vOffset, width, height, 18, 4, textureWidth, textureHeight, 0, 0);
        guiGraphics.drawString(mc.font, fireModeDisplayName, hOffset + 5 + 1, vOffset + 7, 0, false);
        guiGraphics.drawString(mc.font, fireModeDisplayName, hOffset + 5 - 1, vOffset + 7, 0, false);
        guiGraphics.drawString(mc.font, fireModeDisplayName, hOffset + 5, vOffset + 7 + 1, 0, false);
        guiGraphics.drawString(mc.font, fireModeDisplayName, hOffset + 5, vOffset + 7 - 1, 0, false);
        guiGraphics.drawString(mc.font, fireModeDisplayName, hOffset + 5, vOffset + 7, 8040160, false);
        int slotIndex = mc.player.getInventory().selected;
        GunClientState gunClientState = GunClientState.getState((Player)mc.player, stack, slotIndex, false);
        if (gunClientState == null) {
            return;
        }
        int currentAmmo = gunClientState.getAmmoCount(fireModeInstance);
        GunItem gunItem = (GunItem)stack.getItem();
        int maxAmmo = gunItem.getMaxAmmoCapacity(stack, fireModeInstance);
        String counter = maxAmmo == Integer.MAX_VALUE ? "\u221e" : String.format("%d/%d", currentAmmo, maxAmmo);
        Component message = gunClientState.getCurrentMessage();
        if (message != null) {
            counter = message.getString();
        }
        guiGraphics.drawString(mc.font, counter, hOffset + 5 + 1, vOffset - 5, 0, false);
        guiGraphics.drawString(mc.font, counter, hOffset + 5 - 1, vOffset - 5, 0, false);
        guiGraphics.drawString(mc.font, counter, hOffset + 5, vOffset - 5 + 1, 0, false);
        guiGraphics.drawString(mc.font, counter, hOffset + 5, vOffset - 5 - 1, 0, false);
        guiGraphics.drawString(mc.font, counter, hOffset + 5, vOffset - 5, -1, false);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }
}

