/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.entity;

import mod.pbj.registry.SoundRegistry;
import mod.pbj.util.HitboxHelper;
import mod.pbj.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ProjectileBulletEntity
extends Projectile {
    public static final EntityType<ProjectileBulletEntity> TYPE;
    private int correlationId;
    public float speed;
    public float damage;
    public int time = 0;
    public int shotCount;
    public Vec3 initPos = new Vec3(0.0, 0.0, 0.0);
    public float maxDistance = 1500.0f;
    public float headshotMultiplier = 1.0f;
    public ItemStack gunStack;
    public static TagKey<Block> PASSABLE;
    public static TagKey<Block> BREAKABLE;
    private float bulletGravity = 0.03f;

    private static TagKey<Block> create(ResourceLocation loc) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)loc);
    }

    public void setBulletGravity(float gravity) {
        this.bulletGravity = gravity;
    }

    public ProjectileBulletEntity(Level world) {
        super(TYPE, world);
    }

    public ProjectileBulletEntity(EntityType<ProjectileBulletEntity> entityType, Level world) {
        super(entityType, world);
    }

    public ProjectileBulletEntity(EntityType<ProjectileBulletEntity> entityType, double x, double y, double z, Level world) {
        super(entityType, world);
        this.moveTo(x, y, z, this.getYRot(), this.getXRot());
        this.reapplyPosition();
    }

    public boolean checkLeftOwner() {
        Entity entity = this.getOwner();
        if (entity != null) {
            for (Entity entity1 : this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), p_37272_ -> !p_37272_.isSpectator() && p_37272_.isPickable())) {
                if (entity1.getRootVehicle() != entity.getRootVehicle()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean canHitEntity(Entity pTarget) {
        return super.canHitEntity(pTarget) && !pTarget.noPhysics;
    }

    public boolean isPickable() {
        return true;
    }

    public float getPickRadius() {
        return 1.0f;
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        Entity entity = this.getOwner();
        if (this.level().isClientSide || (entity == null || !entity.isRemoved()) && this.level().hasChunkAt(this.blockPosition())) {
            super.tick();
            HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
            if (hitresult.getType() != HitResult.Type.MISS) {
                this.onHit(hitresult);
            }
            this.checkInsideBlocks();
            Vec3 vec3 = this.getDeltaMovement();
            double d0 = this.getX() + vec3.x;
            double d1 = this.getY() + vec3.y;
            double d2 = this.getZ() + vec3.z;
            ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.2f);
            float f = 0.95f;
            if (this.isInWater()) {
                for (int i = 0; i < 4; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d0 - vec3.x * 0.25, d1 - vec3.y * 0.25, d2 - vec3.z * 0.25, vec3.x, vec3.y, vec3.z);
                }
                f = 0.8f;
            }
            this.setDeltaMovement(vec3.scale((double)f));
            this.addDeltaMovement(new Vec3(0.0, (double)(-this.bulletGravity), 0.0));
            this.setPos(d0, d1, d2);
        } else {
            this.discard();
        }
    }

    public ProjectileBulletEntity(LivingEntity shooter, Level world, float damage, float speed, int shotCount, float maxDistance, float headshotMultiplier, ItemStack gunStack, int correlationId) {
        this(TYPE, shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ(), world);
        this.setOwner((Entity)shooter);
        this.setRot(shooter.getYRot(), shooter.getXRot());
        this.damage = damage;
        this.speed = speed;
        this.shotCount = shotCount;
        this.initPos = new Vec3(shooter.getX(), shooter.getEyeY() - (double)0.1f, shooter.getZ());
        this.maxDistance = maxDistance;
        this.headshotMultiplier = headshotMultiplier;
        this.gunStack = gunStack;
        this.correlationId = correlationId;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    protected void onHit(HitResult pResult) {
        HitResult.Type hitresult$type = pResult.getType();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)pResult);
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, pResult.getLocation(), GameEvent.Context.of((Entity)this, (BlockState)null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)pResult;
            this.onHitBlock(blockhitresult);
            BlockPos blockpos = blockhitresult.getBlockPos();
            BlockState blockState = this.level().getBlockState(blockpos);
            if (blockState.is(BREAKABLE)) {
                this.level().destroyBlock(blockpos, true, this.getOwner());
                return;
            }
            if (blockState.is(PASSABLE)) {
                return;
            }
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, blockpos, GameEvent.Context.of((Entity)this, (BlockState)this.level().getBlockState(blockpos)));
        }
    }

    protected void onHitBlock(BlockHitResult pResult) {
        if (pResult.getLocation().distanceTo(this.initPos) >= (double)this.maxDistance) {
            this.discard();
            return;
        }
        BlockState blockState = this.level().getBlockState(pResult.getBlockPos());
        if (blockState.is(BREAKABLE)) {
            this.level().destroyBlock(pResult.getBlockPos(), true, this.getOwner());
            return;
        }
        if (blockState.is(PASSABLE)) {
            return;
        }
        super.onHitBlock(pResult);
        if (this.getOwner() != null && this.level() instanceof ServerLevel) {
            for (ServerPlayer serverPlayer : ((ServerLevel)MiscUtil.getLevel(this.getOwner())).getPlayers(p -> true)) {
                if (serverPlayer != this.getOwner() && !(serverPlayer.distanceToSqr(this.getOwner()) < (double)(this.maxDistance * this.maxDistance))) continue;
            }
        }
        this.playSound(this.level().getBlockState(pResult.getBlockPos()).getSoundType().getHitSound(), 1.0f / (float)this.shotCount, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        RandomSource source = RandomSource.create();
        double d0 = pResult.getLocation().x;
        double d1 = pResult.getLocation().y;
        double d2 = pResult.getLocation().z;
        double d3 = d0 - (double)pResult.getBlockPos().getX() - 0.5;
        double d5 = d2 - (double)pResult.getBlockPos().getZ() - 0.5;
        double d6 = Math.max(Math.abs(d3), Math.abs(d5));
        d0 = (double)pResult.getBlockPos().getX() + 0.5 + d3 / d6 * 0.5;
        d2 = (double)pResult.getBlockPos().getZ() + 0.5 + d5 / d6 * 0.5;
        float f = Mth.ceil((float)this.damage);
        double d4 = Math.min((double)(0.2f + f / 15.0f), 2.5);
        int i = (int)(15.0 * d4);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sv = (ServerLevel)level;
            for (int j = 0; j < i; ++j) {
                sv.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), d0, d1, d2, 1, source.nextBoolean() ? source.nextDouble() / 4.0 : -source.nextDouble() / 4.0, (double)j / (double)i / 2.0, source.nextBoolean() ? source.nextDouble() / 4.0 : -source.nextDouble() / 4.0, 0.15);
            }
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        if (pResult.getLocation().distanceTo(this.initPos) >= (double)this.maxDistance) {
            this.discard();
            return;
        }
        Entity entity = pResult.getEntity();
        AABB boundingBox = HitboxHelper.getFixedBoundingBox(entity, this.getOwner());
        Vec3 startVec = this.position();
        Vec3 endVec = startVec.add(this.getDeltaMovement());
        Vec3 hitPos = boundingBox.clip(startVec, endVec).orElse(null);
        double headshotmulti = 1.0;
        if (hitPos != null) {
            if (this.getOwner() != null && this.level() instanceof ServerLevel) {
                for (ServerPlayer serverPlayer : ((ServerLevel)MiscUtil.getLevel(this.getOwner())).getPlayers(p -> true)) {
                    if (serverPlayer != this.getOwner() && !(serverPlayer.distanceToSqr(this.getOwner()) < (double)(this.maxDistance * this.maxDistance))) continue;
                }
            }
            Vec3 hitBoxPos = hitPos.subtract(entity.position());
            boolean headshot = false;
            float eyeHeight = entity.getEyeHeight();
            if (entity instanceof Player && (double)eyeHeight - 0.25 < hitBoxPos.y && hitBoxPos.y < (double)eyeHeight + 0.25) {
                headshot = true;
                headshotmulti = this.headshotMultiplier;
            }
            if (!(entity instanceof Player) && (double)eyeHeight - 0.25 < hitBoxPos.y && hitBoxPos.y < (double)eyeHeight + 0.25) {
                headshot = true;
                headshotmulti = this.headshotMultiplier;
            }
            DamageSource damageSource = pResult.getEntity().damageSources().mobProjectile((Entity)this, (LivingEntity)this.getOwner());
            if (headshot) {
                this.level().playSound(null, entity.blockPosition(), SoundRegistry.HIT_HEADSHOT.get(), SoundSource.HOSTILE, 0.8f / (float)this.shotCount, 1.0f);
            }
            pResult.getEntity().hurt(damageSource, (float)((double)this.damage * headshotmulti));
            pResult.getEntity().invulnerableTime = 1;
            this.discard();
        }
    }

    static {
        PASSABLE = ProjectileBulletEntity.create(ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"passable"));
        BREAKABLE = ProjectileBulletEntity.create(ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"breakable"));
        TYPE = EntityType.Builder.of(ProjectileBulletEntity::new, (MobCategory)MobCategory.MISC).noSummon().noSave().fireImmune().sized(0.0225f, 0.0225f).clientTrackingRange(256).canSpawnFarFromPlayer().updateInterval(1).build("bullet");
    }
}

