/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;

public class BulletModifierFeature
extends ConditionalFeature {
    private final float velocity;
    private final float gravity;
    private final float inaccuracy;
    private final float speedOffset;
    private final float maxSpeedOffset;

    public BulletModifierFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, float velocity, float gravity, float inaccuracy, float speedOffset, float maxSpeedOffset) {
        super(owner, predicate);
        this.velocity = velocity;
        this.gravity = gravity;
        this.inaccuracy = inaccuracy;
        this.speedOffset = speedOffset;
        this.maxSpeedOffset = maxSpeedOffset;
    }

    public float getVelocityModifier() {
        return this.velocity;
    }

    public float getGravityModifier() {
        return this.gravity;
    }

    public float getInaccuracyModifier() {
        return this.inaccuracy;
    }

    public float getSpeedOffsetModifier() {
        return this.speedOffset;
    }

    public float getMaxSpeedOffsetModifier() {
        return this.maxSpeedOffset;
    }

    public Predicate<ConditionContext> getPredicate() {
        return this.predicate;
    }

    public static class Builder
    implements FeatureBuilder<Builder, BulletModifierFeature> {
        private Predicate<ConditionContext> predicate = ctx -> true;
        private float velocity = 0.0f;
        private float gravity = 0.0f;
        private float inaccuracy = 0.0f;
        private float speedOffset = 0.0f;
        private float maxSpeedOffset = 0.0f;

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.predicate = Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition"));
            }
            this.velocity = JsonUtil.getJsonFloat(obj, "velocity", 0.0f);
            this.gravity = JsonUtil.getJsonFloat(obj, "gravity", 0.0f);
            this.inaccuracy = JsonUtil.getJsonFloat(obj, "inaccuracy", 0.0f);
            this.speedOffset = JsonUtil.getJsonFloat(obj, "speedOffset", 0.0f);
            this.maxSpeedOffset = JsonUtil.getJsonFloat(obj, "maxSpeedOffset", 0.0f);
            return this;
        }

        @Override
        public BulletModifierFeature build(FeatureProvider owner) {
            return new BulletModifierFeature(owner, this.predicate, this.velocity, this.gravity, this.inaccuracy, this.speedOffset, this.maxSpeedOffset);
        }
    }
}

