/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonObject;
import java.util.function.Predicate;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.util.Conditions;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;

public class DescriptionFeature
extends ConditionalFeature {
    public MutableComponent text;

    public DescriptionFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, MutableComponent text) {
        super(owner, predicate);
        this.text = text;
    }

    public Component getMutableDescription() {
        return this.text.withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC);
    }

    public static class Builder
    implements FeatureBuilder<Builder, DescriptionFeature> {
        public Predicate<ConditionContext> predicate = ctx -> true;
        public MutableComponent text;

        @Override
        public Builder withJsonObject(JsonObject obj) {
            String txt = obj.get("text").getAsString();
            this.text = MutableComponent.create((ComponentContents)Component.translatable((String)txt).getContents());
            if (obj.has("condition")) {
                this.predicate = Conditions.fromJson(obj.get("condition"));
            }
            return this;
        }

        @Override
        public DescriptionFeature build(FeatureProvider featureProvider) {
            return new DescriptionFeature(featureProvider, this.predicate, this.text);
        }
    }
}

