/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mod.pbj.feature.Feature;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public interface FeatureProvider {
    default public <T extends Feature> T getFeature(Class<T> featureType) {
        return null;
    }

    default public boolean hasFeature(Feature feature) {
        return this.getFeature(feature.getClass()) == feature;
    }

    default public <T extends Feature> boolean hasFeature(Class<T> featureClass) {
        return this.getFeature(featureClass).getClass() == featureClass;
    }

    public Collection<Feature> getFeatures();

    default public List<Component> getDescriptionTooltipLines() {
        return Collections.emptyList();
    }

    default public List<Component> getFeatureTooltipLines() {
        ArrayList<Component> tooltipLines = new ArrayList<Component>();
        for (Feature feature : this.getFeatures()) {
            MutableComponent featureDescription = feature.getDescription().copy().withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC);
            for (Component description : feature.getDescriptions()) {
                featureDescription.append(description).copy().withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC);
            }
            FormattedText.ContentConsumer consumer = s -> Optional.of(s != null && !s.isEmpty());
            if (!featureDescription.getContents().visit(consumer).orElse(false).booleanValue()) continue;
            tooltipLines.add((Component)featureDescription);
        }
        return tooltipLines;
    }
}

