/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.feature;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import mod.pbj.client.GunClientState;
import mod.pbj.feature.ConditionContext;
import mod.pbj.feature.ConditionalFeature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.Features;
import mod.pbj.util.Conditions;
import mod.pbj.util.JsonUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SkinFeature
extends ConditionalFeature {
    private ResourceLocation texture;
    private Map<String, Pair<ResourceLocation, Predicate<ConditionContext>>> conditions;

    private SkinFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, ResourceLocation texture, Map<String, Pair<ResourceLocation, Predicate<ConditionContext>>> conditions) {
        super(owner, predicate);
        this.texture = texture;
        this.conditions = conditions;
    }

    public MutableComponent getDescription() {
        return Component.literal((String)"Changes skin");
    }

    public static ResourceLocation getTexture(ItemStack itemStack, Player player) {
        Object object;
        Features.EnabledFeature enabledSkinTexture = Features.getFirstEnabledFeature(itemStack, SkinFeature.class);
        if (enabledSkinTexture != null && (object = enabledSkinTexture.feature()) instanceof SkinFeature) {
            SkinFeature feature = (SkinFeature)object;
            if (feature.conditions != null && !feature.conditions.isEmpty()) {
                for (Map.Entry entry : feature.conditions.entrySet()) {
                    String gunId;
                    GunClientState gunState = GunClientState.getMainHeldState();
                    ConditionContext testCondition = new ConditionContext((LivingEntity)player, itemStack, gunState);
                    if (gunState != null && itemStack.getItem().toString().equals(entry.getKey()) && !((Predicate)((Pair)entry.getValue()).getSecond()).test(testCondition)) {
                        return null;
                    }
                    if (gunState == null || !itemStack.getItem().toString().equals(entry.getKey()) || feature.conditions == null || !feature.conditions.containsKey(gunId = itemStack.getItem().toString())) continue;
                    return (ResourceLocation)feature.conditions.get(gunId).getFirst();
                }
            }
            return feature.texture;
        }
        return null;
    }

    public static class Builder
    implements FeatureBuilder<Builder, SkinFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private Map<String, Pair<ResourceLocation, Predicate<ConditionContext>>> resourceConditions;
        private ResourceLocation skinResource;
        private Map<String, Pair<ResourceLocation, Predicate<ConditionContext>>> conditions;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withTexture(String texture) {
            this.skinResource = ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)texture);
            return this;
        }

        public void withTextures(JsonArray textureArray) {
            this.resourceConditions = new HashMap<String, Pair<ResourceLocation, Predicate<ConditionContext>>>();
            for (int i = 0; i < textureArray.size(); ++i) {
                JsonObject obj = textureArray.get(i).getAsJsonObject();
                String weaponId = "pointblank:" + obj.get("id").getAsString();
                String texture = obj.get("texture").getAsString();
                Predicate<ConditionContext> textureCondition = ctx -> true;
                if (obj.has("condition") && obj.get("condition") != null) {
                    textureCondition = Conditions.fromJson(obj.get("condition"));
                }
                this.resourceConditions.put(weaponId, (Pair<ResourceLocation, Predicate<ConditionContext>>)Pair.of((Object)ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)texture), textureCondition));
            }
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            if (obj.has("skins")) {
                this.withTextures(obj.getAsJsonArray("skins"));
            }
            if (obj.has("texture")) {
                this.withTexture(JsonUtil.getJsonString(obj, "texture"));
            }
            return this;
        }

        @Override
        public SkinFeature build(FeatureProvider featureProvider) {
            return new SkinFeature(featureProvider, this.condition, this.skinResource, this.resourceConditions);
        }
    }
}

