/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.item;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mod.pbj.Nameable;
import mod.pbj.attachment.Attachment;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.attachment.AttachmentHost;
import mod.pbj.attachment.Attachments;
import mod.pbj.client.controller.GlowAnimationController;
import mod.pbj.client.effect.AbstractEffect;
import mod.pbj.client.render.ArmorInHandRenderer;
import mod.pbj.client.render.ArmorItemRenderer;
import mod.pbj.crafting.Craftable;
import mod.pbj.feature.AttributeFeature;
import mod.pbj.feature.DefenseFeature;
import mod.pbj.feature.DescriptionFeature;
import mod.pbj.feature.Feature;
import mod.pbj.feature.FeatureBuilder;
import mod.pbj.feature.Features;
import mod.pbj.item.AttachmentItem;
import mod.pbj.item.ExpandedAttributes;
import mod.pbj.item.GunItem;
import mod.pbj.item.ItemBuilder;
import mod.pbj.registry.ItemRegistry;
import mod.pbj.util.JsonUtil;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArmorItem
extends net.minecraft.world.item.ArmorItem
implements Equipable,
Nameable,
Craftable,
AttachmentHost,
GeoItem,
ExpandedAttributes {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final String name;
    public ResourceLocation modelResourceLocation;
    private final List<Supplier<Attachment>> compatibleAttachmentsSuppliers;
    private Collection<Attachment> compatibleAttachments;
    private final List<String> compatibleAttachmentGroups;
    private final Map<Class<? extends Feature>, Feature> features;
    private final List<Supplier<AttachmentItem>> defaultAttachments;
    protected final ArmorItem.Type type;
    private final int defense;
    private final float toughness;
    protected final float knockbackResistance;
    private final Ingredient repairMaterial;
    private final long craftingDuration;
    private final Holder<SoundEvent> equipSound;
    private final List<GlowAnimationController.Builder> glowEffectBuilders;

    public ArmorItem(Builder builder, String namespace) {
        super(ArmorMaterials.LEATHER, builder.armorType, new Item.Properties().stacksTo(1).durability(builder.durability));
        this.name = builder.name;
        this.modelResourceLocation = this.name.contains(":") ? ResourceLocation.parse((String)this.name) : ResourceLocation.fromNamespaceAndPath((String)namespace, (String)this.name);
        this.glowEffectBuilders = builder.glowEffectBuilders;
        this.defense = builder.armor;
        this.type = builder.armorType;
        this.toughness = builder.armorToughness;
        this.equipSound = builder.equipSound;
        this.knockbackResistance = builder.knockbackResistance;
        this.compatibleAttachmentGroups = builder.compatibleAttachmentGroups;
        this.defaultAttachments = builder.defaultAttachments;
        this.compatibleAttachmentsSuppliers = builder.compatibleAttachments;
        this.craftingDuration = builder.craftingDuration;
        this.repairMaterial = Ingredient.of(builder.repairItems.stream());
        HashMap features = new HashMap();
        for (FeatureBuilder<?, ?> featureBuilder : builder.featureBuilders) {
            Object feature = featureBuilder.build(this);
            features.put(feature.getClass(), feature);
        }
        this.features = Collections.unmodifiableMap(features);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public Collection<Attachment> getCompatibleAttachments() {
        if (this.compatibleAttachments == null) {
            HashSet<AttachmentCategory> attachmentCategories = new HashSet<AttachmentCategory>();
            LinkedHashSet<Attachment> compatibleAttachments = new LinkedHashSet<Attachment>();
            for (Attachment attachment : this.getDefaultAttachments()) {
                if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) break;
                attachmentCategories.add(attachment.getCategory());
                compatibleAttachments.add(attachment);
            }
            for (Supplier supplier : this.compatibleAttachmentsSuppliers) {
                Attachment attachment = (Attachment)supplier.get();
                if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) break;
                attachmentCategories.add(attachment.getCategory());
                compatibleAttachments.add(attachment);
            }
            block2: for (String string : this.compatibleAttachmentGroups) {
                for (Supplier<? extends Item> ga : ItemRegistry.ITEMS.getAttachmentsForGroup(string)) {
                    Item item = ga.get();
                    if (!(item instanceof Attachment)) continue;
                    Attachment attachment = (Attachment)item;
                    if (attachmentCategories.size() >= this.getMaxAttachmentCategories()) continue block2;
                    compatibleAttachments.add(attachment);
                }
            }
            this.compatibleAttachments = compatibleAttachments;
        }
        return this.compatibleAttachments;
    }

    @Override
    public long getCraftingDuration() {
        return this.craftingDuration;
    }

    @Override
    public Collection<Feature> getFeatures() {
        return this.features.values();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private ArmorItemRenderer renderer = null;
            public ArmorInHandRenderer inHandRenderer = null;

            @Nullable
            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.inHandRenderer == null) {
                    this.inHandRenderer = new ArmorInHandRenderer(ArmorItem.this.modelResourceLocation, ArmorItem.this.glowEffectBuilders);
                }
                return this.inHandRenderer;
            }

            @Nullable
            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.inHandRenderer == null) {
                    this.inHandRenderer = new ArmorInHandRenderer(ArmorItem.this.modelResourceLocation, ArmorItem.this.glowEffectBuilders);
                }
                if (this.renderer == null) {
                    this.renderer = new ArmorItemRenderer(((ArmorItem)itemStack.getItem()).modelResourceLocation, this.inHandRenderer);
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, (HumanoidModel)original);
                return this.renderer;
            }
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public ArmorItem.Type getType() {
        return this.type;
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public boolean isValidRepairItem(ItemStack pToRepair, ItemStack pRepair) {
        return this.repairMaterial.test(pRepair) || super.isValidRepairItem(pToRepair, pRepair);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        for (Feature descFeature : Features.getEnabledFeatures(stack, DescriptionFeature.class).stream().map(Features.EnabledFeature::feature).toList()) {
            tooltipComponents.add(((DescriptionFeature)descFeature).getMutableDescription());
        }
    }

    public int getDefaultTooltipHideFlags(@NotNull ItemStack stack) {
        return 2;
    }

    public int getAdjustedDefense(ItemStack stack) {
        float defenseMod = DefenseFeature.getDefenseModifier(stack);
        int defenseAdd = DefenseFeature.getDefenseAdditive(stack);
        int defenseFinal = (int)((float)this.defense * defenseMod) + defenseAdd;
        return defenseFinal;
    }

    public float getAdjustedToughness(ItemStack stack) {
        float toughnessMod = DefenseFeature.getToughnessModifier(stack);
        float toughnessAdd = DefenseFeature.getToughnessAdditive(stack);
        float toughnessFinal = this.toughness * toughnessMod + toughnessAdd;
        return toughnessFinal;
    }

    public int getDefense() {
        return this.defense;
    }

    public float getToughness() {
        return this.toughness;
    }

    public EquipmentSlot getEquipmentSlot() {
        return this.type.getSlot();
    }

    public Holder<SoundEvent> getEquipSound() {
        return this.equipSound;
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        for (Supplier<AttachmentItem> attachmentSupplier : this.defaultAttachments) {
            Attachments.addAttachment(stack, attachmentSupplier.get().getDefaultInstance(), true);
        }
        return stack;
    }

    @Override
    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        for (AttributeFeature feature : Features.getEnabledFeatures(stack, AttributeFeature.class).stream().map(enb -> (AttributeFeature)enb.feature()).toList()) {
            builder.add(feature.baseAttribute, feature.modifier, EquipmentSlotGroup.bySlot((EquipmentSlot)this.getEquipmentSlot()));
        }
        int i = this.getAdjustedDefense(stack);
        float f = this.getAdjustedToughness(stack);
        EquipmentSlotGroup equipmentSlotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot());
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)("armor." + this.type.getName()));
        builder.add(Attributes.ARMOR, new AttributeModifier(resourceLocation, (double)i, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourceLocation, (double)f, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        float g = ((ArmorMaterial)this.material.value()).knockbackResistance();
        if (g > 0.0f) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(resourceLocation, (double)g, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        }
        return builder.build();
    }

    public static class Builder
    extends ItemBuilder<Builder> {
        private long craftingDuration = 500L;
        private int armor;
        private float armorToughness;
        private float knockbackResistance;
        private int durability;
        private String name;
        private final Holder<SoundEvent> equipSound = SoundEvents.ARMOR_EQUIP_GENERIC;
        private ArmorItem.Type armorType;
        private final List<ItemStack> repairItems;
        private final List<Supplier<Attachment>> compatibleAttachments;
        private final List<String> compatibleAttachmentGroups;
        private final List<FeatureBuilder<?, ?>> featureBuilders;
        private final List<Supplier<AttachmentItem>> defaultAttachments;
        private final List<GlowAnimationController.Builder> glowEffectBuilders = new ArrayList<GlowAnimationController.Builder>();

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withArmorToughness(float toughness) {
            this.armorToughness = toughness;
            return this;
        }

        public Builder withArmor(int armor) {
            this.armor = armor;
            return this;
        }

        public Builder withType(ArmorItem.Type type) {
            this.armorType = type;
            return this;
        }

        public Builder withKnockbackResistance(float knockbackResistance) {
            this.knockbackResistance = knockbackResistance;
            return this;
        }

        private Builder withCraftingDuration(long craftingDuration) {
            this.craftingDuration = craftingDuration;
            return this;
        }

        private Builder withFeature(FeatureBuilder<?, ?> featureBuilder) {
            this.featureBuilders.add(featureBuilder);
            return this;
        }

        private Builder withDurability(int durability) {
            this.durability = durability;
            return this;
        }

        public Builder withGlow(String glowingPartName) {
            return this.withGlow(glowingPartName, null);
        }

        public Builder withGlow(String glowingPartName, String textureName) {
            return this.withGlow(Collections.singleton(GunItem.FirePhase.ANY), Collections.singleton(glowingPartName), textureName);
        }

        public Builder withGlow(Collection<GunItem.FirePhase> firePhases, String glowingPartName) {
            return this.withGlow(firePhases, Collections.singleton(glowingPartName), null);
        }

        public Builder withGlow(Collection<GunItem.FirePhase> firePhases, Collection<String> glowingPartNames, String texture) {
            GlowAnimationController.Builder builder = new GlowAnimationController.Builder().withFirePhases(firePhases);
            if (texture != null) {
                builder.withTexture(ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)texture));
            }
            builder.withGlowingPartNames(glowingPartNames);
            this.glowEffectBuilders.add(builder);
            return this;
        }

        public Builder withGlow(Collection<GunItem.FirePhase> firePhases, String glowingPartName, String texture, AbstractEffect.SpriteAnimationType spriteAnimationType, int spriteRows, int spriteColumns, int spritesPerSecond, Direction ... directions) {
            GlowAnimationController.Builder builder = new GlowAnimationController.Builder().withFirePhases(firePhases);
            if (texture != null) {
                builder.withTexture(ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)texture));
            }
            builder.withGlowingPartNames(Collections.singleton(glowingPartName));
            builder.withSprites(spriteRows, spriteColumns, spritesPerSecond, spriteAnimationType);
            builder.withDirections(directions);
            this.glowEffectBuilders.add(builder);
            return this;
        }

        public Builder() {
            this.compatibleAttachments = new ArrayList<Supplier<Attachment>>();
            this.compatibleAttachmentGroups = new ArrayList<String>();
            this.featureBuilders = new ArrayList();
            this.defaultAttachments = new ArrayList<Supplier<AttachmentItem>>();
            this.repairItems = new ArrayList<ItemStack>();
        }

        @Override
        public Builder withJsonObject(JsonObject obj, boolean isClientSide) {
            Supplier ri;
            this.withName(JsonUtil.getJsonString(obj, "name")).withCraftingDuration(JsonUtil.getJsonInt(obj, "craftingDuration", 500)).withArmor(JsonUtil.getJsonInt(obj, "defense", 0)).withDurability(JsonUtil.getJsonInt(obj, "durability", 128)).withArmorToughness(JsonUtil.getJsonFloat(obj, "toughness", 0.0f)).withType(JsonUtil.getEnum(obj, "armorType", ArmorItem.Type.class, ArmorItem.Type.HELMET, true));
            for (JsonObject featureObj : JsonUtil.getJsonObjects(obj, "features")) {
                FeatureBuilder<?, ?> featureBuilder = Features.fromJson(featureObj);
                this.withFeature(featureBuilder);
            }
            for (String compatibleAttachmentName : JsonUtil.getStrings(obj, "compatibleAttachments")) {
                ri = ItemRegistry.ITEMS.getDeferredRegisteredObject(compatibleAttachmentName);
                if (ri == null) continue;
                this.compatibleAttachments.add(() -> (Attachment)ri.get());
            }
            for (String compatibleAttachmentName : JsonUtil.getStrings(obj, "defaultAttachments")) {
                ri = ItemRegistry.ITEMS.getDeferredRegisteredObject(compatibleAttachmentName);
                if (ri == null) continue;
                this.defaultAttachments.add(() -> (AttachmentItem)ri.get());
            }
            for (JsonObject glowingPart : JsonUtil.getJsonObjects(obj, "glowingParts")) {
                String partName = JsonUtil.getJsonString(glowingPart, "name");
                List<GunItem.FirePhase> firePhases = Collections.singletonList(GunItem.FirePhase.ANY);
                String textureName = JsonUtil.getJsonString(glowingPart, "texture", null);
                Direction direction = JsonUtil.getEnum(glowingPart, "direction", Direction.class, null, true);
                JsonObject spritesObj = glowingPart.getAsJsonObject("sprites");
                if (spritesObj != null) {
                    int rows = JsonUtil.getJsonInt(spritesObj, "rows", 1);
                    int columns = JsonUtil.getJsonInt(spritesObj, "columns", 1);
                    int fps = JsonUtil.getJsonInt(spritesObj, "fps", 60);
                    AbstractEffect.SpriteAnimationType spriteAnimationType = JsonUtil.getEnum(spritesObj, "type", AbstractEffect.SpriteAnimationType.class, AbstractEffect.SpriteAnimationType.LOOP, true);
                    if (direction != null) {
                        this.withGlow(firePhases, partName, textureName, spriteAnimationType, rows, columns, fps, direction);
                        continue;
                    }
                    this.withGlow(firePhases, partName, textureName, spriteAnimationType, rows, columns, fps, new Direction[0]);
                    continue;
                }
                this.withGlow(firePhases, Collections.singletonList(partName), textureName);
            }
            List<String> compatibleAttachmentGroups = JsonUtil.getStrings(obj, "compatibleAttachmentGroups");
            this.compatibleAttachmentGroups.addAll(compatibleAttachmentGroups);
            return this;
        }

        public ArmorItem build() {
            return new ArmorItem(this, "pointblank");
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

