/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.mixin;

import mod.pbj.Platform;
import mod.pbj.event.RenderGuiEventPost;
import mod.pbj.event.RenderGuiOverlayEvent;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public class GuiMixin {
    @Shadow
    private LayeredDraw layers;

    @Inject(method={"renderCrosshair"}, cancellable=true, at={@At(value="HEAD")})
    private void onRenderCrosshair(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo callback) {
        RenderGuiOverlayEvent event = this.publishRenderOverlayEvent(guiGraphics, deltaTracker);
        if (event.isCanceled()) {
            callback.cancel();
        }
    }

    private RenderGuiOverlayEvent publishRenderOverlayEvent(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        RenderGuiOverlayEvent event = new RenderGuiOverlayEvent(guiGraphics, deltaTracker, RenderGuiOverlayEvent.Type.CROSSHAIR);
        Platform.getInstance().getEventBus().postEvent(event);
        return event;
    }

    @Inject(method={"renderHotbarAndDecorations"}, cancellable=true, at={@At(value="HEAD")})
    private void onRenderHotbarAndDecorations(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo callback) {
        RenderGuiOverlayEvent event = this.publishRenderHotbarAndDecorationsEvent(guiGraphics, deltaTracker);
        if (event.isCanceled()) {
            callback.cancel();
        }
    }

    private RenderGuiOverlayEvent publishRenderHotbarAndDecorationsEvent(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        RenderGuiOverlayEvent event = new RenderGuiOverlayEvent(guiGraphics, deltaTracker, RenderGuiOverlayEvent.Type.HOTBAR);
        Platform.getInstance().getEventBus().postEvent(event);
        return event;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstruct(Minecraft minecraft, CallbackInfo ci) {
        LayeredDraw newLayer = new LayeredDraw().add(this::publishRenderOverlayPostEvent);
        this.layers.add(newLayer, () -> !minecraft.options.hideGui);
    }

    private void publishRenderOverlayPostEvent(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        RenderGuiEventPost event = new RenderGuiEventPost(guiGraphics, deltaTracker);
        Platform.getInstance().getEventBus().postEvent(event);
    }
}

