/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.mixin;

import java.util.function.BiConsumer;
import mod.pbj.item.ExpandedAttributes;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public abstract class ItemStackAttributeExpanderMixin
implements DataComponentHolder {
    @Shadow
    public abstract Item getItem();

    @Inject(method={"forEachModifier(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void pointblank$forEachModifier(EquipmentSlot equipmentSLot, BiConsumer<Holder<Attribute>, AttributeModifier> action, CallbackInfo ci) {
        Item item = this.getItem();
        if (item instanceof ExpandedAttributes) {
            ExpandedAttributes attr = (ExpandedAttributes)item;
            ItemAttributeModifiers itemAttributeModifiers = (ItemAttributeModifiers)this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
            if (!itemAttributeModifiers.modifiers().isEmpty()) {
                itemAttributeModifiers.forEach(equipmentSLot, action);
            } else {
                attr.getDefaultAttributeModifiers((ItemStack)this).forEach(equipmentSLot, action);
            }
            EnchantmentHelper.forEachModifier((ItemStack)((ItemStack)this), (EquipmentSlot)equipmentSLot, action);
            ci.cancel();
        }
    }

    @Inject(method={"forEachModifier(Lnet/minecraft/world/entity/EquipmentSlotGroup;Ljava/util/function/BiConsumer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void pointblank$forEachModifier(EquipmentSlotGroup equipmentSLot, BiConsumer<Holder<Attribute>, AttributeModifier> action, CallbackInfo ci) {
        Item item = this.getItem();
        if (item instanceof ExpandedAttributes) {
            ExpandedAttributes attr = (ExpandedAttributes)item;
            ItemAttributeModifiers itemAttributeModifiers = (ItemAttributeModifiers)this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
            if (!itemAttributeModifiers.modifiers().isEmpty()) {
                itemAttributeModifiers.forEach(equipmentSLot, action);
            } else {
                attr.getDefaultAttributeModifiers((ItemStack)this).forEach(equipmentSLot, action);
            }
            EnchantmentHelper.forEachModifier((ItemStack)((ItemStack)this), (EquipmentSlotGroup)equipmentSLot, action);
            ci.cancel();
        }
    }
}

