/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import java.util.UUID;
import mod.pbj.NetworkService;
import mod.pbj.item.GunItem;
import mod.pbj.network.GunStateRequestPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AimingChangeRequestPacket
extends GunStateRequestPacket {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private boolean isAimingEnabled;

    public AimingChangeRequestPacket() {
    }

    public AimingChangeRequestPacket(UUID stateId, int slotIndex, boolean isAimingEnabled) {
        super(stateId, slotIndex);
        this.isAimingEnabled = isAimingEnabled;
    }

    public static AimingChangeRequestPacket decode(FriendlyByteBuf buffer) {
        GunStateRequestPacket header = GunStateRequestPacket.decodeHeader(buffer);
        return new AimingChangeRequestPacket(header.stateId, header.slotIndex, buffer.readBoolean());
    }

    @Override
    protected void doEncode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isAimingEnabled);
    }

    @Override
    protected <T extends GunStateRequestPacket> void handleEnqueued(NetworkService.MessageContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.getSender();
        if (player != null) {
            Item item;
            ItemStack itemStack = player.getInventory().getItem(this.slotIndex);
            if (itemStack != null && (item = itemStack.getItem()) instanceof GunItem) {
                GunItem gunItem = (GunItem)item;
                gunItem.handleAimingChangeRequest((Player)player, itemStack, this.stateId, this.slotIndex, this.isAimingEnabled);
            } else {
                LOGGER.warn("Mismatching item in slot {}", (Object)this.slotIndex);
            }
        }
    }
}

