/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.network;

import java.util.UUID;
import mod.pbj.NetworkService;
import mod.pbj.item.FireModeInstance;
import mod.pbj.item.GunItem;
import mod.pbj.network.GunStateRequestPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ReloadRequestPacket
extends GunStateRequestPacket {
    private FireModeInstance fireModeInstance;

    public ReloadRequestPacket() {
    }

    public ReloadRequestPacket(UUID stateId, int slotIndex, FireModeInstance fireModeInstance) {
        super(stateId, slotIndex);
        this.fireModeInstance = fireModeInstance;
    }

    @Override
    protected void doEncode(FriendlyByteBuf buffer) {
        this.fireModeInstance.writeToBuf(buffer);
    }

    public static ReloadRequestPacket decode(FriendlyByteBuf buffer) {
        GunStateRequestPacket header = GunStateRequestPacket.decodeHeader(buffer);
        FireModeInstance fireModeInstance = FireModeInstance.readFromBuf(buffer);
        return new ReloadRequestPacket(header.stateId, header.slotIndex, fireModeInstance);
    }

    @Override
    protected <T extends GunStateRequestPacket> void handleEnqueued(NetworkService.MessageContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.getSender();
        if (player != null) {
            ItemStack itemStack = player.getInventory().getItem(this.slotIndex);
            if (itemStack != null && itemStack.getItem() instanceof GunItem) {
                ((GunItem)itemStack.getItem()).handleClientReloadRequest(player, itemStack, this.stateId, this.slotIndex, this.fireModeInstance);
            } else {
                System.err.println("Mismatching item in slot " + this.slotIndex);
            }
        }
    }
}

