/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.platform.neoforge;

import mod.pbj.Config;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoforgeConfig
extends Config {
    protected ModConfigSpec.Builder BUILDER;
    protected final ModConfigSpec SPEC;

    public NeoforgeConfig() {
        ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
        this.AUTO_RELOAD = BUILDER.comment("Enables auto-reloading of guns").defineEnum("autoReloadEnabled", (Enum)Config.AutoReload.CREATIVE);
        this.SCOPE_AIMING_MOUSE_SENSITIVITY = BUILDER.comment("Adjusts mouse sensitivity when using scopes").defineInRange("scopeAimingMouseSensitivity", 0.4, 0.01, 0.9);
        this.RESET_AUTO_FIRE_PITCH_ENABLED = BUILDER.comment("Toggle to reset player pitch to original after auto fire").define("resetAutoFirePitchEnabled", true);
        this.KNOCKBACK = BUILDER.comment("Adjusts the knockback force applied to entities hit by gunfire, with higher values causing greater knockback distance.").defineInRange("knockback", 1.0, 0.1, 2.0);
        this.PARTICLE_EFFECTS_ENABLED = BUILDER.comment("Enables particle effects").define("particleEffectsEnabled", true);
        this.ARMS_DEALER_HOUSE_WEIGHT = BUILDER.comment("Sets the likelihood of an 'Arms Dealer' house appearing in new villages, with higher values increasing frequency and lower values making it rarer.").defineInRange("armsDealerHouse", 10, 0, 20);
        this.EMERALD_EXCHANGE_RATE = BUILDER.comment("Set the exchange rate to determine how many in-game price units are equivalent to one emerald.").defineInRange("emeraldExchangeRate", 100.0, 1.0, 1000.0);
        this.THIRD_PERSON_ARM_POSE_ALWAYS_ON = BUILDER.comment("Controls whether the player's arm pose is permanently set to the aiming/firing position in third-person view, regardless of their current action with a gun.").define("thirdPersonArmPoseAlwaysOn", true);
        this.PIP_SCOPE_REFRESH_FRAME = BUILDER.comment("Specifies how often the \"picture-in-picture\" scope updates, with 1 being every frame, 2 for every other frame, etc. A higher number may improve performance.").defineInRange("pipScopeRefreshRate", 2, 0, 5);
        this.PIP_SCOPES_ENABLED = BUILDER.comment("Enables pip scopes").define("pipScopesEnabled", true);
        this.PIP_SCOPE_COLOR_BALANCE_RED = BUILDER.comment("Sets pip scope red color balance. This options works for shaders only.").defineInRange("pipScopeColorBalanceRed", 90, 0, 255);
        this.PIP_SCOPE_COLOR_BALANCE_GREEN = BUILDER.comment("Sets pip scope green color balance. This options works for shaders only.").defineInRange("pipScopeColorBalanceGreen", 105, 0, 255);
        this.PIP_SCOPE_COLOR_BALANCE_BLUE = BUILDER.comment("Sets pip scope blue color balance. This options works for shaders only.").defineInRange("pipScopeColorBalanceBlue", 110, 0, 255);
        this.CUSTOM_SHADERS_ENABLED = BUILDER.comment("Enables custom shaders").define("customShadersEnabled", true);
        this.EXPLOSION_DESTROY_BLOCKS_ENABLED = BUILDER.comment("Enables explosions to destroy blocks").define("explosionDestroyBlocksEnabled", true);
        this.ITEM_DROP_CHANCE = BUILDER.comment("Sets the probability of dropping some item(s) by monster mobs.").defineInRange("itemDropChance", 0.35, 0.0, 1.0);
        this.MAX_ITEM_DROP_COUNT = BUILDER.comment("Sets the max count of items to be dropped by a monster mob.").defineInRange("maxItemDropCount", 7, 2, 64);
        this.BULLETS_BREAK_GLASS_ENABLED = BUILDER.comment("Enables bullets breaking glass").define("bulletsBreakGlassEnabled", true);
        this.HITSCAN_DAMAGE_MODIFIER = BUILDER.comment("Modifier to adjust damage dealt by hitscan weapons").defineInRange("hitscanDamageModifier", 1.0, 0.1, 10.0);
        this.CROSSHAIR_TYPE = BUILDER.comment("Sets the crosshair type.").defineEnum("crosshair", (Enum)Config.CrosshairType.DEFAULT);
        this.HEADSHOT_DAMAGE_MODIFIER = BUILDER.comment("Modifier to adjust damage dealt by headshot.").defineInRange("headshotDamageModifier", 3.0, 1.0, 10.0);
        this.GORE_ENABLED = BUILDER.comment("Enables gore effects").define("goreEnabled", true);
        this.ADVANCED_IRIS_INTEGRATION_ENABLED = BUILDER.comment("Enables advanced integraiton with Iris shaders").define("advancedIrisIntegrationEnabled", true);
        this.FIRST_PERSON_ANIMATIONS_ENABLED = BUILDER.comment("Enables advanced first person animations").define("firstPersonAnimationsEnabled", true);
        this.THIRD_PERSON_ANIMATIONS_ENABLED = BUILDER.comment("Enables advanced third person animations").define("thirdPersonAnimationsEnabled", true);
        this.OVERWRITE_DISABLED = BUILDER.comment("Set to true to disable overwriting of the default pointblank content pack").define("overwriteDisabled", false);
        this.SPEC = BUILDER.build();
    }
}

