/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.attachment;

import com.mojang.datafixers.util.Pair;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import mod.pbj.Platform;
import mod.pbj.attachment.Attachment;
import mod.pbj.attachment.AttachmentCategory;
import mod.pbj.attachment.AttachmentHost;
import mod.pbj.feature.AimingFeature;
import mod.pbj.feature.Feature;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.network.ServerBoundNextAttachmentPacket;
import mod.pbj.network.ServerBoundOpenScreenPacket;
import mod.pbj.util.LRUCache;
import mod.pbj.util.MiscUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Attachments {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static final LRUCache<Pair<class_2487, Long>, NavigableMap<AttachmentCategory, String>> selectedAttachmentsCache = new LRUCache(100);
    private static final LRUCache<Pair<class_2487, Long>, NavigableMap<String, class_1799>> tagAttachmentsCache = new LRUCache(100);
    private static final LRUCache<Pair<class_2487, Long>, NavigableMap<String, List<class_1799>>> tagAttachmentGroupsCache = new LRUCache(100);
    private static final LRUCache<Pair<class_2487, Long>, NavigableMap<String, class_1799>> recursiveAttachmentsCache = new LRUCache(100);
    public static final String ROOT_PATH = "/";

    public static void ensureValidAttachmentsSelected(class_1799 itemStack) {
        Attachments.ensureValidAttachmentSelected(itemStack, AttachmentCategory.SCOPE, AimingFeature.class);
    }

    private static void ensureValidAttachmentSelected(class_1799 itemStack, AttachmentCategory category, Class<? extends Feature> featureType) {
        FeatureProvider fp;
        Feature feature;
        class_1792 class_17922;
        boolean isValid = false;
        Pair<String, class_1799> selected = Attachments.getSelectedAttachment(itemStack, category);
        if (selected != null && (class_17922 = ((class_1799)selected.getSecond()).method_7909()) instanceof FeatureProvider && (feature = (fp = (FeatureProvider)class_17922).getFeature(featureType)) != null) {
            isValid = feature.isEnabled((class_1799)selected.getSecond());
        }
        if (!isValid) {
            Attachments.selectNextAttachment(itemStack, category, featureType);
        }
    }

    public static Collection<class_1799> getAttachments(class_1799 itemStack) {
        return Attachments.getAttachments(itemStack, false).values();
    }

    public static Pair<String, class_1799> getSelectedAttachment(class_1799 rootItemStack, AttachmentCategory category) {
        NavigableMap<AttachmentCategory, String> selectedAttachments = Attachments.getSelectedAttachments(rootItemStack);
        String selectedAttachmentPath = (String)selectedAttachments.get(category);
        if (selectedAttachmentPath == null) {
            return null;
        }
        if (ROOT_PATH.equals(selectedAttachmentPath)) {
            return Pair.of((Object)selectedAttachmentPath, (Object)rootItemStack);
        }
        NavigableMap<String, class_1799> allAttachments = Attachments.getAttachments(rootItemStack, true);
        class_1799 attachmentStack = (class_1799)allAttachments.get(selectedAttachmentPath);
        if (attachmentStack == null) {
            return Pair.of((Object)selectedAttachmentPath, (Object)class_1799.field_8037);
        }
        return Pair.of((Object)selectedAttachmentPath, (Object)attachmentStack);
    }

    public static NavigableMap<AttachmentCategory, String> getSelectedAttachments(class_1799 itemStack) {
        if (itemStack == null || !(itemStack.method_7909() instanceof AttachmentHost) || MiscUtil.getTag(itemStack) == null) {
            return Collections.emptyNavigableMap();
        }
        return selectedAttachmentsCache.computeIfAbsent(MiscUtil.getTagAndTimestamp(itemStack), p -> Attachments.getSelectedAttachments((class_2487)p.getFirst()));
    }

    private static NavigableMap<AttachmentCategory, String> getSelectedAttachments(class_2487 tag) {
        if (tag != null && tag.method_10545("sa")) {
            class_2487 attachmentsTag = tag.method_10562("sa");
            TreeMap<AttachmentCategory, String> attachments = new TreeMap<AttachmentCategory, String>();
            for (AttachmentCategory category : AttachmentCategory.values()) {
                if (!attachmentsTag.method_10545(category.getName())) continue;
                attachments.put(category, attachmentsTag.method_10558(category.getName()));
            }
            return attachments;
        }
        return Collections.emptyNavigableMap();
    }

    private static void saveSelectedAttachments(class_1799 rootItemStack, Map<AttachmentCategory, String> attachments) {
        class_2487 nbt = MiscUtil.getOrCreateTag(rootItemStack);
        class_2487 attachmentsTag = new class_2487();
        for (Map.Entry<AttachmentCategory, String> entry : attachments.entrySet()) {
            attachmentsTag.method_10582(entry.getKey().getName(), entry.getValue());
        }
        nbt.method_10566("sa", (class_2520)attachmentsTag);
        MiscUtil.setTag(rootItemStack, nbt);
    }

    public static Pair<String, class_1799> selectNextAttachment(class_1799 rootItemStack, AttachmentCategory category, Class<? extends Feature> featureType) {
        FeatureProvider fp;
        Object feature;
        class_1792 class_17922 = rootItemStack.method_7909();
        if (!(class_17922 instanceof AttachmentHost)) {
            return null;
        }
        AttachmentHost attachmentHost = (AttachmentHost)class_17922;
        if (attachmentHost.getCompatibleAttachments().isEmpty()) {
            return null;
        }
        NavigableMap<String, class_1799> attachmentsForCategory = Attachments.getAttachmentsForCategory(rootItemStack, category);
        NavigableMap<AttachmentCategory, String> selectedAttachments = Attachments.getSelectedAttachments(rootItemStack);
        String activeAttachmentPath = (String)selectedAttachments.get(category);
        Map.Entry<String, Object> next = null;
        if (activeAttachmentPath != null) {
            for (Map.Entry entry : attachmentsForCategory.tailMap(activeAttachmentPath, false).entrySet()) {
                class_1792 class_17923 = ((class_1799)entry.getValue()).method_7909();
                if (!(class_17923 instanceof FeatureProvider) || (feature = (fp = (FeatureProvider)class_17923).getFeature(featureType)) == null || !feature.isEnabled((class_1799)entry.getValue())) continue;
                next = entry;
                break;
            }
        }
        if (next == null) {
            FeatureProvider fp2;
            Feature feature2;
            class_1792 class_17924 = rootItemStack.method_7909();
            if (class_17924 instanceof FeatureProvider && (feature2 = (fp2 = (FeatureProvider)class_17924).getFeature(featureType)) != null && feature2.isEnabled(rootItemStack)) {
                next = new AbstractMap.SimpleImmutableEntry<String, class_1799>(ROOT_PATH, rootItemStack);
            }
            if (next == null) {
                for (Map.Entry entry : attachmentsForCategory.entrySet()) {
                    feature = ((class_1799)entry.getValue()).method_7909();
                    if (!(feature instanceof FeatureProvider) || (feature = (fp = (FeatureProvider)feature).getFeature(featureType)) == null || !feature.isEnabled((class_1799)entry.getValue())) continue;
                    next = entry;
                    break;
                }
            }
        }
        selectedAttachments = new TreeMap<AttachmentCategory, String>((SortedMap<AttachmentCategory, String>)selectedAttachments);
        if (next != null) {
            selectedAttachments.put(category, (String)next.getKey());
        } else {
            selectedAttachments.remove(category);
        }
        LOGGER.debug("Active attachments for stack {} updated: {}", (Object)rootItemStack, selectedAttachments);
        Attachments.saveSelectedAttachments(rootItemStack, selectedAttachments);
        return next != null ? Pair.of((Object)((String)next.getKey()), (Object)((class_1799)next.getValue())) : null;
    }

    public static NavigableMap<String, class_1799> getAttachmentsForCategory(class_1799 itemStack, AttachmentCategory category) {
        NavigableMap<String, class_1799> attachments = Attachments.getAttachments(itemStack, true);
        TreeMap<String, class_1799> attachmentsForCategory = new TreeMap<String, class_1799>();
        for (Map.Entry e : attachments.entrySet()) {
            Attachment attachment;
            class_1799 attachmentStack = (class_1799)e.getValue();
            class_1792 class_17922 = attachmentStack.method_7909();
            if (!(class_17922 instanceof Attachment) || !Objects.equals(category, (attachment = (Attachment)class_17922).getCategory())) continue;
            attachmentsForCategory.put((String)e.getKey(), (class_1799)e.getValue());
        }
        return Collections.unmodifiableNavigableMap(attachmentsForCategory);
    }

    public static NavigableMap<String, List<class_1799>> getAttachmentGroups(class_1799 itemStack) {
        if (itemStack == null || !(itemStack.method_7909() instanceof AttachmentHost) || MiscUtil.getTag(itemStack) == null) {
            return Collections.emptyNavigableMap();
        }
        return tagAttachmentGroupsCache.computeIfAbsent(MiscUtil.getTagAndTimestamp(itemStack), p -> Attachments.getAttachmentGroups((class_2487)p.getFirst()));
    }

    private static NavigableMap<String, List<class_1799>> getAttachmentGroups(class_2487 tag) {
        NavigableMap<String, class_1799> attachments = Attachments.getAttachments(tag, ROOT_PATH, false, new TreeMap<String, class_1799>());
        TreeMap<String, List<class_1799>> attachmentGroups = new TreeMap<String, List<class_1799>>();
        for (Map.Entry e : attachments.entrySet()) {
            for (String group : ((Attachment)((class_1799)e.getValue()).method_7909()).getGroups()) {
                List attachmentList = attachmentGroups.computeIfAbsent(group, g -> new ArrayList());
                attachmentList.add((class_1799)e.getValue());
            }
        }
        return attachmentGroups;
    }

    public static NavigableMap<String, class_1799> getAttachments(class_1799 itemStack, boolean recursive) {
        if (itemStack == null || !(itemStack.method_7909() instanceof AttachmentHost) || MiscUtil.getTag(itemStack) == null) {
            return Collections.emptyNavigableMap();
        }
        if (recursive) {
            return recursiveAttachmentsCache.computeIfAbsent(MiscUtil.getTagAndTimestamp(itemStack), p -> Attachments.getAttachments((class_2487)p.getFirst(), ROOT_PATH, true, new TreeMap<String, class_1799>()));
        }
        return tagAttachmentsCache.computeIfAbsent(MiscUtil.getTagAndTimestamp(itemStack), p -> Attachments.getAttachments((class_2487)p.getFirst(), ROOT_PATH, false, new TreeMap<String, class_1799>()));
    }

    static NavigableMap<String, class_1799> getAttachments(class_2487 itemTag, String parentPath, boolean recursive, NavigableMap<String, class_1799> attachmentStacks) {
        if (itemTag != null && itemTag.method_10573("as", 9)) {
            class_2499 attachmentsList = itemTag.method_10554("as", 10);
            for (int i = 0; i < attachmentsList.size(); ++i) {
                class_2487 attachmentTag = attachmentsList.method_10602(i);
                String attachmentItemId = attachmentTag.method_10558("id");
                class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)attachmentItemId));
                if (!(item instanceof Attachment)) continue;
                Attachment attachment = (Attachment)item;
                class_1799 attachmentStack = new class_1799((class_1935)item);
                MiscUtil.setTag(attachmentStack, attachmentTag);
                String path = parentPath + ROOT_PATH + attachment.getName();
                attachmentStacks.put(path, attachmentStack);
                if (!recursive || !(item instanceof AttachmentHost)) continue;
                Attachments.getAttachments(attachmentTag, path, recursive, attachmentStacks);
            }
        }
        return attachmentStacks;
    }

    public static class_2487 addAttachment(class_1799 containerStack, class_1799 attachmentStack, boolean isRemoveable) {
        String attachmentId = class_7923.field_41178.method_10221((Object)attachmentStack.method_7909()).toString();
        class_2487 containerTag = MiscUtil.getOrCreateTag(containerStack);
        class_2499 attachmentsList = containerTag.method_10554("as", 10);
        class_2487 attachmentTag = MiscUtil.hasTag(attachmentStack) ? MiscUtil.copyTag(attachmentStack) : new class_2487();
        Attachments.initAttachmentTag(attachmentTag, attachmentId, isRemoveable);
        attachmentsList.add((Object)attachmentTag);
        containerTag.method_10566("as", (class_2520)attachmentsList);
        MiscUtil.setTag(containerStack, containerTag);
        return attachmentTag;
    }

    public static List<Attachment> removeAllAttachments(class_1799 containerStack) {
        class_2487 containerTag = MiscUtil.getOrCreateTag(containerStack);
        class_2499 attachmentsList1 = containerTag.method_10554("as", 10);
        class_2499 removedList = attachmentsList1.method_10612();
        attachmentsList1.clear();
        ArrayList<Attachment> removedItems = new ArrayList<Attachment>();
        for (int i = 0; i < removedList.size(); ++i) {
            class_2487 attachmentTag = removedList.method_10602(i);
            String attachmentItemId = attachmentTag.method_10558("id");
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)attachmentItemId));
            if (!(item instanceof Attachment)) continue;
            Attachment attachment = (Attachment)item;
            removedItems.add(attachment);
        }
        MiscUtil.setTag(containerStack, containerTag);
        return removedItems;
    }

    public static void initAttachmentTag(class_2487 attachmentTag, String attachmentId, boolean isRemoveable) {
        attachmentTag.method_10582("id", attachmentId);
        attachmentTag.method_10556("rmv", isRemoveable);
    }

    public static boolean isRemoveable(class_2487 containerTag) {
        return true;
    }

    public static void tryAttachmentMode(class_1657 player, class_1799 heldItem) {
        Platform.getInstance().getNetworkService().sendToServer(new ServerBoundOpenScreenPacket(ServerBoundOpenScreenPacket.ScreenType.ATTACHMENTS));
    }

    public static void tryNextAttachment(class_1657 player, class_1799 heldItem, AttachmentCategory category, Class<? extends Feature> feature) {
        Platform.getInstance().getNetworkService().sendToServer(new ServerBoundNextAttachmentPacket(category, feature));
    }
}

