/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.block.entity;

import java.util.List;
import mod.pbj.Enableable;
import mod.pbj.block.entity.PrinterBlockEntityExt;
import mod.pbj.crafting.Craftable;
import mod.pbj.crafting.PointBlankRecipe;
import mod.pbj.inventory.CraftingContainerMenu;
import mod.pbj.registry.BlockEntityRegistry;
import mod.pbj.registry.SoundRegistry;
import mod.pbj.util.ClientUtil;
import mod.pbj.util.InventoryUtils;
import mod.pbj.util.MiscUtil;
import mod.pbj.util.StateMachine;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.event.data.SoundKeyframeData;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PrinterBlockEntity
extends class_2586
implements PrinterBlockEntityExt,
GeoBlockEntity,
class_3908 {
    private static final int OPENING_DURATION = 655;
    private static final int CLOSING_DURATION = 577;
    protected final class_3913 dataAccess = new class_3913(){

        public int method_17390(int dataSlotIndex) {
            switch (dataSlotIndex) {
                case 0: {
                    return PrinterBlockEntity.this.getState().ordinal();
                }
                case 1: {
                    return PrinterBlockEntity.this.craftingPlayer != null ? PrinterBlockEntity.this.craftingPlayer.method_5628() : -1;
                }
            }
            return 0;
        }

        public void method_17391(int dataSlotIndex, int value) {
            switch (dataSlotIndex) {
                default: 
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private static final class_2561 CONTAINER_TITLE = class_2561.method_43471((String)"screen.pointblank.crafting");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private List<class_1657> nearbyEntities;
    private long lastNearbyEntityUpdateTimestamp;
    private class_1657 craftingPlayer;
    private PointBlankRecipe craftingRecipe;
    private long craftingStartTime;
    private long craftingDuration;
    private long openingDuration = 655L;
    private long closingStartTime;
    private long closingDuration = 577L;
    private long openingStartTime;
    private CraftingEventHandler craftingEventHandler;
    private StateMachine<State, Context> stateMachine;
    private State clientState;
    private static final RawAnimation ANIMATION_OPEN = RawAnimation.begin().thenPlay("animation.model.open").thenLoop("animation.model.idle");
    private static final RawAnimation ANIMATION_CLOSE = RawAnimation.begin().thenPlay("animation.model.close");
    private static final RawAnimation ANIMATION_IDLE = RawAnimation.begin().thenPlay("animation.model.idle");
    private static final RawAnimation ANIMATION_CRAFTING = RawAnimation.begin().thenPlay("animation.model.crafting").thenLoop("animation.model.idle");

    public PrinterBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityRegistry.PRINTER_BLOCK_ENTITY.get(), pos, state);
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (level.field_9236) {
            this.clientState = State.CLOSED;
        } else {
            this.stateMachine = this.createStateMachine();
        }
    }

    public State getState() {
        if (this.field_11863 == null) {
            return null;
        }
        return this.field_11863.field_9236 ? this.clientState : this.stateMachine.getCurrentState();
    }

    private StateMachine<State, Context> createStateMachine() {
        StateMachine.Builder<State, Context> builder = new StateMachine.Builder<State, Context>();
        builder.withTransition(State.CLOSED, State.OPENING, this::predicateIsPlayerNearby, StateMachine.TransitionMode.AUTO, null, this::actionOpen);
        builder.withTransition(State.OPENING, State.IDLE, this::openingTimeoutExpired, StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition(State.IDLE, State.CRAFTING, this::predicateIsPlayerNearby, StateMachine.TransitionMode.EVENT, null, this::actionStartCrafting);
        builder.withTransition(State.CRAFTING, State.IDLE, this::predicateIsPlayerNearby, StateMachine.TransitionMode.EVENT, null, null);
        builder.withTransition(State.CRAFTING, State.CRAFTING_COMPLETED, ctx -> this.predicateIsPlayerNearby((Context)ctx) && this.craftingTimeoutExpired((Context)ctx), StateMachine.TransitionMode.AUTO, null, this::actionCompleteCrafting);
        builder.withTransition(State.CRAFTING, State.CLOSING, ctx -> !this.predicateIsPlayerNearby((Context)ctx), StateMachine.TransitionMode.AUTO, null, this::actionCancelCrafting);
        builder.withTransition(State.CRAFTING_COMPLETED, State.IDLE, ctx -> true, StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition(State.IDLE, State.CLOSING, ctx -> !this.predicateIsPlayerNearby((Context)ctx), StateMachine.TransitionMode.AUTO, null, null);
        builder.withTransition(State.CLOSING, State.CLOSED, this::closingTimeoutExpired, StateMachine.TransitionMode.AUTO, null, null);
        builder.withOnSetStateAction(State.IDLE, this::actionIdle);
        builder.withOnChangeStateAction(this::actionOnChangeState);
        return builder.build(State.CLOSED);
    }

    private boolean closingTimeoutExpired(Context ctx) {
        return System.currentTimeMillis() - this.closingStartTime >= this.closingDuration;
    }

    private boolean craftingTimeoutExpired(Context ctx) {
        return System.currentTimeMillis() - this.craftingStartTime >= this.craftingDuration;
    }

    private boolean openingTimeoutExpired(Context ctx) {
        return System.currentTimeMillis() - this.openingStartTime >= this.openingDuration;
    }

    private boolean predicateIsPlayerNearby(Context context) {
        return PrinterBlockEntity.isPlayerNearby(this.method_11016(), this.nearbyEntities);
    }

    private void actionStartCrafting(Context context, State fromState, State toState) {
        this.craftingPlayer = context.craftingPlayer;
        this.craftingRecipe = context.craftingRecipe;
        this.craftingStartTime = System.currentTimeMillis();
        this.craftingDuration = ((Craftable)context.craftingRecipe.method_8110(null).method_7909()).getCraftingDuration();
        this.craftingEventHandler = context.craftingEventHandler;
    }

    private void actionIdle(Context context, State fromState, State toState) {
        this.resetCrafting();
    }

    private void actionOpen(Context context, State fromState, State toState) {
        this.openingStartTime = System.currentTimeMillis();
    }

    private void actionCompleteCrafting(Context context, State fromState, State toState) {
        this.createCraftingItem();
    }

    private void actionCancelCrafting(Context context, State fromState, State toState) {
        this.cancelCrafting(context.craftingPlayer, context.craftingRecipe.getId(MiscUtil.getLevel((class_1297)context.craftingPlayer)));
    }

    private void actionOnChangeState(Context context, State fromState, State toState) {
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, state -> {
            PlayState playState = null;
            switch (this.getState().ordinal()) {
                case 0: {
                    playState = state.setAndContinue(ANIMATION_CLOSE);
                    break;
                }
                case 1: {
                    playState = state.setAndContinue(ANIMATION_OPEN);
                    break;
                }
                case 3: {
                    playState = state.setAndContinue(ANIMATION_IDLE);
                    break;
                }
                case 4: {
                    playState = state.setAndContinue(ANIMATION_CRAFTING);
                    break;
                }
                case 5: {
                    playState = state.setAndContinue(ANIMATION_IDLE);
                    break;
                }
                case 2: {
                    playState = state.setAndContinue(ANIMATION_CLOSE);
                }
            }
            return playState;
        }).setSoundKeyframeHandler(event -> {
            SoundKeyframeData soundKeyframeData;
            String soundName;
            class_3414 soundEvent;
            class_1657 player = ClientUtil.getClientPlayer();
            if (player != null && (soundEvent = SoundRegistry.getSoundEvent(soundName = (soundKeyframeData = event.getKeyframeData()).getSound())) != null) {
                class_2338 blockPos = this.method_11016();
                this.field_11863.method_8486((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), soundEvent, class_3419.field_15245, 2.0f, (1.0f + (this.field_11863.field_9229.method_43057() - this.field_11863.field_9229.method_43057()) * 0.2f) * 0.7f, false);
            }
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void clientTick(class_1937 level, class_2338 blockPos, class_2680 blockState, PrinterBlockEntity entity) {
    }

    private void updateEntities() {
        class_2338 blockpos = this.method_11016();
        if (this.field_11863.method_8510() > this.lastNearbyEntityUpdateTimestamp + 50L || this.nearbyEntities == null) {
            this.lastNearbyEntityUpdateTimestamp = this.field_11863.method_8510();
            class_238 aabb = new class_238(blockpos).method_1014(15.0);
            this.nearbyEntities = this.field_11863.method_18467(class_1657.class, aabb);
        }
    }

    private static boolean isPlayerNearby(class_2338 blockPos, List<class_1657> entities) {
        if (entities == null) {
            return false;
        }
        for (class_1309 class_13092 : entities) {
            if (!(class_13092 instanceof class_1657) || !class_13092.method_5805() || class_13092.method_31481() || !blockPos.method_19769((class_2374)class_13092.method_19538(), 6.0)) continue;
            return true;
        }
        return false;
    }

    public class_1703 createMenu(int containerId, class_1661 inventory, class_1657 player) {
        return new CraftingContainerMenu(containerId, inventory, this, this.dataAccess);
    }

    public class_2561 method_5476() {
        return CONTAINER_TITLE;
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, PrinterBlockEntity entity) {
        entity.serverTick();
    }

    private void serverTick() {
        this.updateEntities();
        Context context = new Context(this.craftingPlayer, this.craftingRecipe, this.craftingEventHandler);
        this.stateMachine.update(context);
    }

    private void createCraftingItem() {
        class_1799 craftedStack = null;
        boolean isCraftingSuccessful = false;
        boolean isAddedToInventory = false;
        Exception craftingException = null;
        try {
            if (this.craftingRecipe.canBeCrafted(this.craftingPlayer) && (craftedStack = this.craftingRecipe.method_8110(null)) != null && !craftedStack.method_7960()) {
                this.craftingRecipe.removeIngredients(this.craftingPlayer);
                int remaingCount = InventoryUtils.addItem(this.craftingPlayer, craftedStack.method_7909(), craftedStack.method_7947());
                if (remaingCount > 0) {
                    class_2338 blockPos = this.method_11016();
                    if (blockPos != null) {
                        class_1264.method_5449((class_1937)MiscUtil.getLevel((class_1297)this.craftingPlayer), (double)blockPos.method_10263(), (double)((float)blockPos.method_10264() + 1.25f), (double)blockPos.method_10260(), (class_1799)craftedStack.method_7972());
                        isCraftingSuccessful = true;
                    }
                } else {
                    isAddedToInventory = true;
                    isCraftingSuccessful = true;
                }
            }
        }
        catch (Exception e) {
            craftingException = e;
            System.err.println("Caught exception during crafting " + String.valueOf(e));
        }
        if (craftedStack == null) {
            craftedStack = class_1799.field_8037;
        }
        if (this.craftingEventHandler != null) {
            if (isCraftingSuccessful) {
                this.craftingEventHandler.onCraftingCompleted(this.craftingPlayer, craftedStack, isAddedToInventory);
            } else {
                this.craftingEventHandler.onCraftingFailed(this.craftingPlayer, craftedStack, craftingException);
            }
        }
    }

    private void resetCrafting() {
        this.craftingPlayer = null;
        this.craftingRecipe = null;
        this.craftingStartTime = 0L;
        this.craftingDuration = 0L;
        this.craftingEventHandler = null;
    }

    public boolean tryCrafting(class_1657 player, class_2960 recipeId, CraftingEventHandler craftingEventHandler) {
        Enableable e;
        class_1792 class_17922;
        if (this.nearbyEntities != null && !this.nearbyEntities.contains(player)) {
            return false;
        }
        PointBlankRecipe craftingRecipe = PointBlankRecipe.getRecipe(MiscUtil.getLevel((class_1297)player), recipeId);
        if (craftingRecipe == null) {
            return false;
        }
        class_1799 craftingItemStack = craftingRecipe.method_8110(null);
        if (craftingItemStack == null || craftingItemStack.method_7960() || !(craftingItemStack.method_7909() instanceof Craftable) || (class_17922 = craftingItemStack.method_7909()) instanceof Enableable && !(e = (Enableable)class_17922).isEnabled()) {
            return false;
        }
        return this.stateMachine.setState(new Context(player, craftingRecipe, craftingEventHandler), State.CRAFTING) == State.CRAFTING;
    }

    public boolean cancelCrafting(class_1657 player, class_2960 recipeId) {
        if (this.stateMachine.getCurrentState() != State.CRAFTING) {
            return false;
        }
        if (player != this.craftingPlayer) {
            return false;
        }
        if (!recipeId.equals((Object)this.craftingRecipe.getId(MiscUtil.getLevel((class_1297)player)))) {
            return false;
        }
        this.stateMachine.setState(new Context(player, this.craftingRecipe, this.craftingEventHandler), State.IDLE);
        if (this.craftingEventHandler != null) {
            this.craftingEventHandler.onCraftingCancelled(this.craftingPlayer, this.craftingRecipe.method_8110(null));
        }
        return true;
    }

    public class_2622 getUpdatePacket() {
        class_2487 tag = new class_2487();
        tag.method_10569("clientState", this.stateMachine.getCurrentState().ordinal());
        return class_2622.method_39026((class_2586)this, (e, ra) -> tag);
    }

    @Override
    public void onDataPacket(class_2535 connection, class_2622 packet, class_7225.class_7874 lookup) {
        class_2487 tag = packet.method_11290();
        if (tag != null) {
            int ordinal = tag.method_10550("clientState");
            this.clientState = State.values()[ordinal];
        }
    }

    public static enum State {
        CLOSED,
        OPENING,
        CLOSING,
        IDLE,
        CRAFTING,
        CRAFTING_COMPLETED;

    }

    private static class Context {
        private class_1657 craftingPlayer;
        private PointBlankRecipe craftingRecipe;
        private CraftingEventHandler craftingEventHandler;

        public Context(class_1657 craftingPlayer, PointBlankRecipe craftingRecipe, CraftingEventHandler craftingEventHandler) {
            this.craftingPlayer = craftingPlayer;
            this.craftingRecipe = craftingRecipe;
            this.craftingEventHandler = craftingEventHandler;
        }
    }

    public static interface CraftingEventHandler {
        default public void onCraftingCompleted(class_1657 player, class_1799 craftingItemStack, boolean isAddedToInventory) {
        }

        default public void onCraftingCancelled(class_1657 player, class_1799 craftingItemStack) {
        }

        default public void onCraftingFailed(class_1657 player, class_1799 craftingItemStack, Exception craftingException) {
        }
    }
}

