/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import mod.pbj.Config;
import mod.pbj.client.ClientEventHandler;
import mod.pbj.client.GunClientState;
import mod.pbj.client.render.AuxLevelRenderer;
import mod.pbj.feature.PipFeature;
import mod.pbj.item.GunItem;
import mod.pbj.util.ClientUtil;
import mod.pbj.util.MiscUtil;
import mod.pbj.util.ReloadableMemoize;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_276;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_4013;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_9779;
import org.joml.Matrix4f;

public class ClientSystem {
    private static ClientSystem instance;
    private AuxLevelRenderer auxLevelRenderer;
    private class_5944 texColorShaderInstance;
    private class_5944 colorTexLightmapShaderInstance;
    private List<class_4013> resourceManagerReloadListeners;
    private Matrix4f inverseCameraMatrix;

    public static ClientSystem getInstance() {
        if (RenderSystem.isOnRenderThreadOrInit()) {
            if (instance == null) {
                instance = new ClientSystem();
            }
        } else {
            new IllegalStateException("getInstance() called from wrong thread");
        }
        return instance;
    }

    private ClientSystem() {
        class_310 mc = class_310.method_1551();
        class_276 mainRenderTarget = mc.method_1522();
        this.auxLevelRenderer = new AuxLevelRenderer(mainRenderTarget.field_1482, mainRenderTarget.field_1481);
        String texColorShaderName = "pointblank_position_tex_color";
        try {
            this.texColorShaderInstance = new class_5944((class_5912)mc.method_1478(), texColorShaderName, class_290.field_1575);
        }
        catch (Exception exception) {
            throw new IllegalStateException("could not preload shader " + texColorShaderName, exception);
        }
        String colorTexLightmapShaderName = "pointblank_position_color_tex_lightmap";
        try {
            this.colorTexLightmapShaderInstance = new class_5944((class_5912)mc.method_1478(), colorTexLightmapShaderName, class_290.field_20888);
        }
        catch (Exception exception) {
            throw new IllegalStateException("could not preload shader " + colorTexLightmapShaderName, exception);
        }
        this.resourceManagerReloadListeners = new ArrayList<class_4013>();
        class_3300 class_33002 = class_310.method_1551().method_1478();
        if (class_33002 instanceof class_3304) {
            class_3304 rrm = (class_3304)class_33002;
            rrm.method_14477((class_3302)this.resourceManagerReloadListener());
        }
    }

    private class_4013 resourceManagerReloadListener() {
        return this::onResourceManagerReload;
    }

    private void onResourceManagerReload(class_3300 resourceManager) {
        for (class_4013 reloadListener : this.resourceManagerReloadListeners) {
            reloadListener.method_14491(resourceManager);
        }
    }

    public <T, U, R> BiFunction<T, U, R> createReloadableMemoize(BiFunction<T, U, R> f) {
        ReloadableMemoize<T, U, R> reloadable = new ReloadableMemoize<T, U, R>(f);
        this.resourceManagerReloadListeners.add(reloadable);
        return reloadable.getMemoizedFunction();
    }

    public AuxLevelRenderer getAuxLevelRenderer() {
        return this.auxLevelRenderer;
    }

    public class_5944 getTexColorShaderInstance() {
        if (Config.customShadersEnabled) {
            return this.texColorShaderInstance;
        }
        return class_757.method_34543();
    }

    public class_5944 getColorTexLightmapShaderInstance() {
        if (Config.customShadersEnabled) {
            return this.colorTexLightmapShaderInstance;
        }
        return class_757.method_34548();
    }

    public void renderAux(GunClientState state, class_9779 deltaTracker) {
        class_310 mc = class_310.method_1551();
        Optional<Float> pipZoom = PipFeature.getZoom(mc.field_1724.method_6047());
        if (pipZoom.isPresent() && state.isAiming()) {
            ClientSystem.getInstance().getAuxLevelRenderer().renderToTarget(deltaTracker, pipZoom.get().floatValue());
        }
    }

    public static double modifyMouseSensitivity(double originalValue) {
        class_1792 class_17922;
        GunClientState state = GunClientState.getMainHeldState();
        class_1799 mainHeldItem = ClientUtil.getClientPlayer().method_6047();
        if (mainHeldItem != null && (class_17922 = mainHeldItem.method_7909()) instanceof GunItem) {
            GunItem gunItem = (GunItem)class_17922;
            if (state != null && state.isAiming() && (gunItem.getScopeOverlay() != null || MiscUtil.isGreaterThanZero(gunItem.getPipScopeZoom()) || ClientEventHandler.runSyncCompute(() -> !PipFeature.getZoom(mainHeldItem).isEmpty()).booleanValue())) {
                return originalValue * Config.scopeAimingMouseSensitivity;
            }
        }
        return originalValue;
    }

    public void setInverseCameraMatrix(Matrix4f inverseCameraMatrix) {
        this.inverseCameraMatrix = inverseCameraMatrix;
    }

    public Matrix4f getInverseCameraMatrix() {
        return this.inverseCameraMatrix;
    }
}

