/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import mod.pbj.client.GunClientState;
import net.minecraft.class_243;
import net.minecraft.class_4587;

public class GunStatePoseProvider {
    private static final GunStatePoseProvider INSTANCE = new GunStatePoseProvider();
    private Map<Key, class_4587.class_4665> poses = new HashMap<Key, class_4587.class_4665>();
    private Map<Key, class_243[]> positionsAndDirections = new HashMap<Key, class_243[]>();

    public static GunStatePoseProvider getInstance() {
        return INSTANCE;
    }

    private GunStatePoseProvider() {
    }

    public class_4587.class_4665 getPose(GunClientState gunClientState, PoseContext poseContext) {
        return this.poses.get(new Key(gunClientState.getId(), poseContext));
    }

    public void setPose(GunClientState gunClientState, PoseContext poseContext, class_4587.class_4665 pose) {
        this.poses.put(new Key(gunClientState.getId(), poseContext), pose);
    }

    public void clear(UUID id) {
        Map.Entry<Key, class_4587.class_4665> e;
        Iterator<Map.Entry<Key, class_4587.class_4665>> it = this.poses.entrySet().iterator();
        while (it.hasNext()) {
            e = it.next();
            if (!Objects.equals(e.getKey().id, id)) continue;
            it.remove();
        }
        it = this.positionsAndDirections.entrySet().iterator();
        while (it.hasNext()) {
            e = it.next();
            if (!Objects.equals(e.getKey().id, id)) continue;
            it.remove();
        }
    }

    public void setPositionAndDirection(GunClientState gunClientState, PoseContext poseContext, class_243 pos, class_243 direction) {
        this.positionsAndDirections.put(new Key(gunClientState.getId(), poseContext), new class_243[]{pos, direction});
    }

    public class_243 getPosition(GunClientState gunClientState, PoseContext poseContext) {
        class_243[] positionAndDirection = this.positionsAndDirections.get(new Key(gunClientState.getId(), poseContext));
        if (positionAndDirection != null) {
            return positionAndDirection[0];
        }
        return null;
    }

    public class_243[] getPositionAndDirection(GunClientState gunClientState, PoseContext poseContext) {
        return this.positionsAndDirections.get(new Key(gunClientState.getId(), poseContext));
    }

    private static class Key {
        UUID id;
        PoseContext poseContext;

        Key(UUID id, PoseContext poseContext) {
            this.id = id;
            this.poseContext = poseContext;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.id, this.poseContext});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.id, other.id) && this.poseContext == other.poseContext;
        }
    }

    public static enum PoseContext {
        FIRST_PERSON_MUZZLE,
        FIRST_PERSON_MUZZLE_FLASH,
        THIRD_PERSON_MUZZLE,
        THIRD_PERSON_MUZZLE_FLASH;

    }
}

