/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.controller;

import mod.pbj.client.GunClientState;
import mod.pbj.client.controller.AbstractProceduralAnimationController;
import mod.pbj.client.render.GunItemRenderer;
import mod.pbj.item.GunItem;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Quaternionf;
import software.bernie.geckolib.cache.object.GeoBone;

public class RotationAnimationController
extends AbstractProceduralAnimationController {
    private static float MODEL_SCALE = 0.0625f;
    private Phase phase = Phase.IDLE;
    private long phaseStartTime;
    private double phaseStartDistance;
    private double rotationsPerSecond = 5.0;
    private double decelerationRate = 5.0;
    private double accelerationRate = 1.0;
    private PhaseMapper phaseMapper;
    private DistanceFunction phaseDistanceFunction = ZeroDistance.INSTANCE;

    private RotationAnimationController() {
        super(0L);
    }

    @Override
    public void onStateTick(class_1309 player, GunClientState state) {
        GunClientState.FireState fireState = state.getFireState();
        Phase newPhase = this.phaseMapper.getPhase(fireState);
        if (newPhase != this.phase) {
            double elapsedPhaseTime = (double)(System.nanoTime() - this.phaseStartTime) / 1.0E9;
            double previousVelocity = this.phaseDistanceFunction.getVelocity(elapsedPhaseTime);
            double previousPhaseDurationSeconds = (double)(System.nanoTime() - this.phaseStartTime) / 1.0E9;
            double previousPhaseDistance = this.phaseDistanceFunction.getDistance(previousPhaseDurationSeconds);
            this.phaseStartDistance += previousPhaseDistance;
            this.phaseStartTime = System.nanoTime();
            switch (newPhase.ordinal()) {
                case 0: {
                    this.phaseDistanceFunction = new DecelerationDistance(previousVelocity, this.decelerationRate);
                    break;
                }
                case 1: {
                    this.phaseDistanceFunction = new AccelerationDistance(previousVelocity, this.accelerationRate);
                    break;
                }
                case 2: {
                    this.phaseDistanceFunction = new AccelerationDistance(previousVelocity, this.accelerationRate);
                    break;
                }
                case 3: {
                    this.phaseDistanceFunction = new DecelerationDistance(previousVelocity, this.decelerationRate);
                }
            }
            this.phase = newPhase;
        }
    }

    public void render(GunItemRenderer renderer, GunClientState gunClientState, class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, int color) {
        poseStack.method_22903();
        float xPivot = bone.getPivotX() * MODEL_SCALE;
        float yPivot = bone.getPivotY() * MODEL_SCALE;
        float zPivot = bone.getPivotZ() * MODEL_SCALE;
        double elapsedPhaseTime = (double)(System.nanoTime() - this.phaseStartTime) / 1.0E9;
        double elapsedPhaseDistance = this.phaseDistanceFunction.getDistance(elapsedPhaseTime);
        double distance = this.phaseStartDistance + elapsedPhaseDistance;
        double currentDistanceInDegress = this.rotationsPerSecond * distance * 360.0;
        poseStack.method_46416(xPivot, yPivot, zPivot);
        poseStack.method_22907(new Quaternionf().rotationXYZ((float)Math.PI / 180 * (float)(0.0 + 0.0 * this.progress), (float)Math.PI / 180 * (float)(0.0 + 0.0 * this.progress), (float)Math.PI / 180 * (float)(0.0 - currentDistanceInDegress)));
        poseStack.method_46416(-xPivot, -yPivot, -zPivot);
        renderer.renderCubesOfBoneParent(poseStack, bone, buffer, packedLight, packedOverlay, color);
        poseStack.method_22909();
    }

    public void renderRecursively(GunItemRenderer renderer, class_4587 poseStack, GunItem animatable, GeoBone bone, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        poseStack.method_22903();
        float xPivot = bone.getPivotX() * MODEL_SCALE;
        float yPivot = bone.getPivotY() * MODEL_SCALE;
        float zPivot = bone.getPivotZ() * MODEL_SCALE;
        double elapsedPhaseTime = (double)(System.nanoTime() - this.phaseStartTime) / 1.0E9;
        double elapsedPhaseDistance = this.phaseDistanceFunction.getDistance(elapsedPhaseTime);
        double distance = this.phaseStartDistance + elapsedPhaseDistance;
        double currentDistanceInDegress = this.rotationsPerSecond * distance * 360.0;
        poseStack.method_46416(xPivot, yPivot, zPivot);
        poseStack.method_22907(new Quaternionf().rotationXYZ((float)Math.PI / 180 * (float)(0.0 + 0.0 * this.progress), (float)Math.PI / 180 * (float)(0.0 + 0.0 * this.progress), (float)Math.PI / 180 * (float)(0.0 - currentDistanceInDegress)));
        poseStack.method_46416(-xPivot, -yPivot, -zPivot);
        renderer.renderRecursivelySuper(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        poseStack.method_22909();
    }

    public static enum Phase {
        IDLE,
        PREPARING,
        RUNNING,
        COMPLETING;

    }

    private static class ZeroDistance
    implements DistanceFunction {
        static final ZeroDistance INSTANCE = new ZeroDistance();

        private ZeroDistance() {
        }

        @Override
        public double getDistance(double t) {
            return 0.0;
        }

        @Override
        public double getVelocity(double t) {
            return 0.0;
        }
    }

    private static interface DistanceFunction {
        public double getDistance(double var1);

        public double getVelocity(double var1);
    }

    public static interface PhaseMapper {
        public Phase getPhase(GunClientState.FireState var1);
    }

    private static class DecelerationDistance
    implements DistanceFunction {
        private double deceleration;
        private double initialVelocity;

        public DecelerationDistance(double initialVelocity, double deceleration) {
            this.deceleration = deceleration;
            this.initialVelocity = initialVelocity;
        }

        @Override
        public double getDistance(double t) {
            double finalVelocity = this.initialVelocity - t * this.deceleration;
            if (finalVelocity < 0.0) {
                double tStop = this.initialVelocity / this.deceleration;
                return this.initialVelocity * tStop - 0.5 * this.deceleration * tStop * tStop;
            }
            return this.initialVelocity * t - 0.5 * this.deceleration * t * t;
        }

        @Override
        public double getVelocity(double t) {
            double finalVelocity = this.initialVelocity - t * this.deceleration;
            return Math.max(finalVelocity, 0.0);
        }
    }

    private static class AccelerationDistance
    implements DistanceFunction {
        private double acceleration;
        private double initialVelocity;

        public AccelerationDistance(double initialVelocity, double acceleration) {
            this.initialVelocity = initialVelocity;
            this.acceleration = acceleration;
        }

        @Override
        public double getDistance(double t) {
            double tMax;
            double distanceWithConstantSpeed = 0.0;
            double finalVelocity = this.initialVelocity + this.acceleration * t;
            if (finalVelocity > 1.0) {
                tMax = Math.max((1.0 - this.initialVelocity) / this.acceleration, 0.0);
                distanceWithConstantSpeed = t - tMax;
            } else {
                tMax = t;
            }
            return this.initialVelocity * tMax + 0.5 * this.acceleration * tMax * tMax + distanceWithConstantSpeed;
        }

        @Override
        public double getVelocity(double t) {
            double finalVelocity = this.initialVelocity + this.acceleration * t;
            return Math.min(finalVelocity, 1.0);
        }
    }

    public static class Builder {
        private String modelPartName;
        private double rotationsPerSecond = 5.0;
        private double decelerationRate = 5.0;
        private double accelerationRate = 1.0;
        private PhaseMapper phaseMapper = FirePhaseMapper.INSTANCE;

        public String getModelPartName() {
            return this.modelPartName;
        }

        public Builder withPhase(String phase) {
            switch (phase) {
                case "fire": {
                    this.phaseMapper = FirePhaseMapper.INSTANCE;
                    break;
                }
                case "reload": {
                    this.phaseMapper = ReloadPhaseMapper.INSTANCE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid phase name: " + phase);
                }
            }
            return this;
        }

        public Builder withPhaseMapper(PhaseMapper phaseMapper) {
            this.phaseMapper = phaseMapper;
            return this;
        }

        public Builder withModelPart(String modelPartName) {
            this.modelPartName = modelPartName;
            return this;
        }

        public Builder withDecelerationRate(double decelerationRate) {
            this.decelerationRate = decelerationRate;
            return this;
        }

        public Builder withAccelerationRate(double accelerationRate) {
            this.accelerationRate = accelerationRate;
            return this;
        }

        public Builder withRotationsPerMinute(double rotationsPerMinute) {
            this.rotationsPerSecond = rotationsPerMinute / 60.0;
            return this;
        }

        public RotationAnimationController build() {
            if (this.modelPartName == null) {
                throw new IllegalStateException("Invalid rotation configutaion, missing model part name");
            }
            RotationAnimationController controller = new RotationAnimationController();
            controller.accelerationRate = this.accelerationRate;
            controller.decelerationRate = this.decelerationRate;
            controller.rotationsPerSecond = this.rotationsPerSecond;
            controller.phaseMapper = this.phaseMapper;
            return controller;
        }
    }

    private static class ConstantDistance
    implements DistanceFunction {
        static final ConstantDistance INSTANCE = new ConstantDistance();

        private ConstantDistance() {
        }

        @Override
        public double getDistance(double t) {
            return t;
        }

        @Override
        public double getVelocity(double t) {
            return t;
        }
    }

    private static class ReloadPhaseMapper
    implements PhaseMapper {
        static final ReloadPhaseMapper INSTANCE = new ReloadPhaseMapper();

        private ReloadPhaseMapper() {
        }

        @Override
        public Phase getPhase(GunClientState.FireState fireState) {
            return switch (fireState) {
                case GunClientState.FireState.PREPARE_RELOAD, GunClientState.FireState.PREPARE_RELOAD_COOLDOWN, GunClientState.FireState.PREPARE_RELOAD_ITER, GunClientState.FireState.PREPARE_RELOAD_COOLDOWN_ITER -> Phase.PREPARING;
                case GunClientState.FireState.RELOAD, GunClientState.FireState.RELOAD_COOLDOWN, GunClientState.FireState.RELOAD_ITER, GunClientState.FireState.RELOAD_COOLDOWN_ITER -> Phase.RUNNING;
                case GunClientState.FireState.COMPLETE_RELOAD, GunClientState.FireState.COMPLETE_RELOAD_COOLDOWN -> Phase.COMPLETING;
                default -> Phase.IDLE;
            };
        }
    }

    private static class FirePhaseMapper
    implements PhaseMapper {
        static final FirePhaseMapper INSTANCE = new FirePhaseMapper();

        private FirePhaseMapper() {
        }

        @Override
        public Phase getPhase(GunClientState.FireState fireState) {
            return switch (fireState) {
                case GunClientState.FireState.PREPARE_FIRE_SINGLE, GunClientState.FireState.PREPARE_FIRE_COOLDOWN_SINGLE, GunClientState.FireState.PREPARE_FIRE_AUTO, GunClientState.FireState.PREPARE_FIRE_COOLDOWN_AUTO, GunClientState.FireState.PREPARE_FIRE_BURST, GunClientState.FireState.PREPARE_FIRE_COOLDOWN_BURST -> Phase.PREPARING;
                case GunClientState.FireState.FIRE_SINGLE, GunClientState.FireState.FIRE_COOLDOWN_SINGLE, GunClientState.FireState.FIRE_AUTO, GunClientState.FireState.FIRE_COOLDOWN_AUTO, GunClientState.FireState.FIRE_BURST, GunClientState.FireState.FIRE_COOLDOWN_BURST -> Phase.RUNNING;
                case GunClientState.FireState.COMPLETE_FIRE, GunClientState.FireState.COMPLETE_FIRE_COOLDOWN -> Phase.COMPLETING;
                default -> Phase.IDLE;
            };
        }
    }
}

