/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.effect;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import mod.pbj.client.ClientSystem;
import mod.pbj.client.PoseProvider;
import mod.pbj.client.SegmentsProviders;
import mod.pbj.client.VertexConsumers;
import mod.pbj.client.effect.AbstractEffect;
import mod.pbj.client.effect.EffectBuilder;
import mod.pbj.client.effect.EffectRenderContext;
import mod.pbj.client.particle.EffectParticles;
import mod.pbj.client.render.RenderTypeProvider;
import mod.pbj.client.render.RenderUtil;
import mod.pbj.client.uv.SpriteUVProvider;
import mod.pbj.item.GunItem;
import mod.pbj.util.Interpolators;
import mod.pbj.util.JsonUtil;
import mod.pbj.util.MiscUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_703;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;

public class AttachedProjectileEffect
extends AbstractEffect {
    private static Random random = new Random();
    private PoseProvider poseProvider;
    private Interpolators.FloatProvider distanceProvider;
    private int numBlades;
    private boolean isFaceEnabled;
    private float randomization;
    private double randomPitch = (random.nextDouble() - 0.5) * 2.0;
    private double randomYaw = (random.nextDouble() - 0.5) * 2.0;
    private int bladeBrightness;
    private int faceBrightness;
    private float bladeTextureMinU;
    private float bladeTextureMaxU;
    private float faceTextureMinU;
    private float faceTextureMaxU;
    private SegmentsProviders.SegmentsProvider segmentsProvider;
    private Interpolators.FloatInterpolator faceWidthProvider;
    private Interpolators.FloatInterpolator bladeWidthProvider;
    private Function<class_4588, class_4588> vertexConsumerTransformer;
    private class_1921 renderType;

    private AttachedProjectileEffect() {
    }

    @Override
    public boolean hasInfiniteBounds() {
        return true;
    }

    private class_4588 getVertextBuffer(EffectRenderContext effectRenderContext) {
        class_4588 vertexBuffer = effectRenderContext.getVertexBuffer();
        if (vertexBuffer == null) {
            class_4597 bufferSource = effectRenderContext.getBufferSource();
            if (this.renderType == null) {
                this.renderType = RenderTypeProvider.getInstance().getMuzzleFlashRenderType(this.texture);
            }
            vertexBuffer = bufferSource.getBuffer(this.renderType);
            vertexBuffer = VertexConsumers.ENTITY.apply(vertexBuffer);
        }
        return vertexBuffer;
    }

    @Override
    public void render(EffectRenderContext effectRenderContext) {
        if (ClientSystem.getInstance().getAuxLevelRenderer().isRendering()) {
            return;
        }
        class_4587 poseStack = effectRenderContext.getPoseStack();
        if (poseStack != null) {
            this.renderWithPose(effectRenderContext);
        } else {
            this.renderWithoutPose(effectRenderContext);
        }
    }

    private void renderWithoutPose(EffectRenderContext effectRenderContext) {
        float progress = effectRenderContext.getProgress();
        if (progress < 0.0f) {
            return;
        }
        if (this.poseProvider != null) {
            class_4587 poseStack = new class_4587();
            poseStack.method_22903();
            this.adjustPose(poseStack, effectRenderContext);
            this.render(effectRenderContext, poseStack, this.getVertextBuffer(effectRenderContext), progress, effectRenderContext.getLightColor());
            poseStack.method_22909();
        }
    }

    private void renderWithPose(EffectRenderContext effectRenderContext) {
        float progress = effectRenderContext.getProgress();
        if (progress < 0.0f) {
            return;
        }
        this.render(effectRenderContext, effectRenderContext.getPoseStack(), this.getVertextBuffer(effectRenderContext), progress, effectRenderContext.getLightColor());
    }

    private void render(EffectRenderContext effectRenderContext, class_4587 poseStack, class_4588 vertexBuffer, float progress, int lightColor) {
        float numRotations = 0.0f;
        float distance = this.distanceProvider.getValue();
        float[][] beamSegments = this.segmentsProvider.getSegments(distance, progress, this.lifetimeNanos);
        float distanceSoFar = beamSegments[0][0] + (beamSegments[0][1] - beamSegments[0][0]) * 0.5f;
        if (distanceSoFar >= distance) {
            return;
        }
        vertexBuffer = this.vertexConsumerTransformer.apply(vertexBuffer);
        float roll = -(effectRenderContext.getInitialAngle() + numRotations * 360.0f * progress);
        if (this.isGlowEnabled) {
            lightColor = 240;
        }
        SpriteUVProvider spriteUVProvider = effectRenderContext.getSpriteUVProvider();
        this.renderBladesWithRotations(poseStack, beamSegments, roll, vertexBuffer, progress, lightColor, spriteUVProvider);
        this.renderFaceWithRotations(poseStack, beamSegments, roll, vertexBuffer, progress, lightColor, spriteUVProvider);
    }

    private void adjustPose(class_4587 poseStack, EffectRenderContext context) {
        class_4587.class_4665 currentItemPose = this.poseProvider.getPose();
        if (currentItemPose != null) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees((float)this.randomPitch * this.randomization));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)this.randomYaw * this.randomization));
            Matrix4f modelMatrixAdjusted = new Matrix4f().mul((Matrix4fc)new Matrix4f((Matrix4fc)RenderUtil.getModelViewMatrixInverted())).mul((Matrix4fc)new Matrix4f((Matrix4fc)RenderUtil.getProjectionMatrixInverted())).mul((Matrix4fc)RenderUtil.getProjectionMatrixNormalFov()).mul((Matrix4fc)new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix()));
            modelMatrixAdjusted = modelMatrixAdjusted.mul((Matrix4fc)currentItemPose.method_23761());
            poseStack.method_34425(modelMatrixAdjusted);
        }
    }

    private void renderFaceWithRotations(class_4587 poseStack, float[][] beamSegments, float rot, class_4588 vertexBuffer, float progress, int lightColor, SpriteUVProvider spriteUVProvider) {
        poseStack.method_22903();
        Quaternionf yQuaternion = class_7833.field_40716.rotationDegrees(0.0f);
        poseStack.method_22907(yQuaternion);
        Quaternionf rollQ = class_7833.field_40714.rotationDegrees(0.0f);
        poseStack.method_22907(rollQ);
        Quaternionf zQuaternion = class_7833.field_40718.rotationDegrees(-rot);
        poseStack.method_22907(zQuaternion);
        Matrix4f poseState = poseStack.method_23760().method_23761();
        if (this.isFaceEnabled) {
            float faceZOffset = beamSegments[0][0] + (beamSegments[0][1] - beamSegments[0][0]) * 0.5f;
            this.renderFace(poseState, faceZOffset, vertexBuffer, progress, lightColor, spriteUVProvider);
        }
        poseStack.method_22909();
    }

    private void renderBladesWithRotations(class_4587 poseStack, float[][] beamSegments, float rot, class_4588 vertexBuffer, float progress, int lightColor, SpriteUVProvider spriteUVProvider) {
        float bladeStep = 180.0f / (float)this.numBlades;
        for (int k = 0; k < this.numBlades; ++k) {
            poseStack.method_22903();
            Quaternionf yQuaternion = class_7833.field_40716.rotationDegrees(90.0f);
            poseStack.method_22907(yQuaternion);
            float xRot = (float)k * bladeStep + rot;
            Quaternionf rollQ = class_7833.field_40714.rotationDegrees(xRot);
            poseStack.method_22907(rollQ);
            Quaternionf zQuaternion = class_7833.field_40718.rotationDegrees(0.0f);
            poseStack.method_22907(zQuaternion);
            Matrix4f poseState = poseStack.method_23760().method_23761();
            this.renderBlade(poseState, beamSegments, vertexBuffer, progress, lightColor, spriteUVProvider);
            poseStack.method_22909();
        }
    }

    private void renderFace(Matrix4f transform, float zOffset, class_4588 vertexBuffer, float progress, int lightColor, SpriteUVProvider spriteUVProvider) {
        float[] uv = spriteUVProvider.getSpriteUV(progress);
        if (uv == null) {
            return;
        }
        float offset = 0.5f * this.faceWidthProvider.getValue(progress);
        float dynamicAlpha = this.alphaProvider.getValue(progress);
        float spriteWidth = uv[2] - uv[0];
        float minU = uv[0] + spriteWidth * this.faceTextureMinU;
        float minV = uv[1];
        float maxU = uv[0] + spriteWidth * this.faceTextureMaxU;
        float maxV = uv[3];
        float[][] texUV = new float[][]{{maxU, maxV}, {minU, maxV}, {minU, minV}, {maxU, minV}};
        float[][] positionOffsets = new float[][]{{offset, -offset, -zOffset}, {-offset, -offset, -zOffset}, {-offset, offset, -zOffset}, {offset, offset, -zOffset}};
        for (int k = 0; k < this.faceBrightness; ++k) {
            for (int i = 0; i < 4; ++i) {
                vertexBuffer.method_22918(transform, positionOffsets[i][0], positionOffsets[i][1], positionOffsets[i][2]).method_22913(texUV[i][0], texUV[i][1]).method_22915(1.0f, 1.0f, 1.0f, dynamicAlpha).method_22922(0).method_22914(0.0f, 1.0f, 0.0f).method_60803(lightColor);
            }
        }
    }

    private void renderBlade(Matrix4f transform, float[][] beamSegments, class_4588 vertexBuffer, float progress, int lightColor, SpriteUVProvider spriteUVProvider) {
        float beamSegmentWidth = 0.5f * this.bladeWidthProvider.getValue(progress);
        float dynamicAlpha = this.alphaProvider.getValue(progress);
        int numBeamSpriteSegments = beamSegments.length;
        float[] uv = spriteUVProvider.getSpriteUV(progress * (float)this.lifetimeNanos);
        float spriteWidth = uv[2] - uv[0];
        float spriteSegmentWidth = spriteWidth * (this.bladeTextureMaxU - this.bladeTextureMinU) / (float)numBeamSpriteSegments;
        for (int beamSegmentIndex = 0; beamSegmentIndex < numBeamSpriteSegments; ++beamSegmentIndex) {
            float minU = uv[0] + spriteWidth * this.bladeTextureMinU + spriteSegmentWidth * (float)beamSegmentIndex;
            float minV = uv[1];
            float maxU = minU + spriteSegmentWidth;
            float maxV = uv[3];
            float[][] texUV = new float[][]{{maxU, maxV}, {minU, maxV}, {minU, minV}, {maxU, minV}};
            float beamSegmentStart = beamSegments[beamSegmentIndex][0];
            float beamSegmentEnd = beamSegments[beamSegmentIndex][1];
            float[][] positionOffsets = new float[][]{{beamSegmentEnd, beamSegmentWidth, 0.0f}, {beamSegmentStart, beamSegmentWidth, 0.0f}, {beamSegmentStart, -beamSegmentWidth, 0.0f}, {beamSegmentEnd, -beamSegmentWidth, 0.0f}};
            for (int k = 0; k < this.bladeBrightness; ++k) {
                for (int i = 0; i < 4; ++i) {
                    vertexBuffer.method_22918(transform, positionOffsets[i][0], positionOffsets[i][1], positionOffsets[i][2]).method_22913(texUV[i][0], texUV[i][1]).method_22915(1.0f, 1.0f, 1.0f, dynamicAlpha).method_22914(0.0f, 1.0f, 0.0f).method_22922(0).method_60803(lightColor);
                }
            }
        }
    }

    @Override
    public void launch(class_1297 player) {
        EffectParticles.EffectParticle particle = new EffectParticles.EffectParticle(player, this);
        class_310 mc = class_310.method_1551();
        mc.field_1713.method_3058((class_703)particle);
    }

    public static class Builder
    extends AbstractEffect.AbstractEffectBuilder<Builder, AttachedProjectileEffect> {
        private static final Set<GunItem.FirePhase> COMPATIBLE_PHASES = Set.of(GunItem.FirePhase.PREPARING, GunItem.FirePhase.FIRING, GunItem.FirePhase.HIT_SCAN_ACQUIRED, GunItem.FirePhase.COMPLETETING);
        public static final long DEFAULT_DURATION = 250L;
        public static final float MAX_DISTANCE = 200.0f;
        public static final int DEFAULT_NUM_BLADES = 0;
        public static final int DEFAULT_NUM_SPRITES = 1;
        public static final int DEFAULT_FACE_BRIGHTNESS = 2;
        public static final int DEFAULT_BLADE_BRIGHTNESS = 2;
        public static final int MAX_SPRITES = 200;
        public static final int MAX_BRIGHTNESS = 5;
        public static final int DEFAULT_SHOTS_PER_TRACE = 1;
        public static final SegmentsProviders.SegmentsProvider DEFAULT_SEGMENTS_PROVIDER = new SegmentsProviders.MovingSegmentsProvider(200.0f, -10.0f);
        private Interpolators.FloatInterpolator bladeWidthProvider;
        private Interpolators.FloatInterpolator faceWidthProvider;
        private Interpolators.FloatProvider bladeLengthProvider;
        private int bladeBrightness;
        private int faceBrightness;
        private SegmentsProviders.SegmentsProvider segmentsProvider;
        private int numBlades;
        private boolean isFaceEnabled;
        private float faceTextureMinU;
        private float faceTextureMaxU;
        private float bladeTextureMinU;
        private float bladeTextureMaxU;

        public Builder() {
            this.duration = 250L;
            this.numBlades = 0;
            this.faceBrightness = 2;
            this.bladeBrightness = 2;
            this.segmentsProvider = DEFAULT_SEGMENTS_PROVIDER;
        }

        @Override
        public Builder withDuration(long durationMillis) {
            this.duration = durationMillis;
            return this;
        }

        public Builder withWidth(double width) {
            this.bladeWidthProvider = new Interpolators.EaseInEaseOutFloatProvider((float)width);
            this.faceWidthProvider = new Interpolators.EaseInEaseOutFloatProvider((float)width);
            return this;
        }

        public Builder withBladeWidthProvider(Interpolators.FloatInterpolator widthProvider) {
            this.bladeWidthProvider = widthProvider;
            return this;
        }

        public Builder withFaceWidthProvider(Interpolators.FloatInterpolator widthProvider) {
            this.faceWidthProvider = widthProvider;
            return this;
        }

        public Builder withBladeLengthProvider(Interpolators.FloatProvider bladeLengthProvider) {
            this.bladeLengthProvider = bladeLengthProvider;
            return this;
        }

        public Builder withBlades(int numBlades, float bladeTextureMinU, float bladeTextureMaxU) {
            this.numBlades = numBlades;
            this.bladeTextureMinU = bladeTextureMinU;
            this.bladeTextureMaxU = bladeTextureMaxU;
            return this;
        }

        public Builder withBlade(float bladeTextureMinU, float bladeTextureMaxU) {
            return this.withBlades(1, bladeTextureMinU, bladeTextureMaxU);
        }

        public Builder withBlades(int numBlades) {
            return this.withBlades(numBlades, 0.0f, 1.0f);
        }

        public Builder withFace(float faceTextureMinU, float faceTextureMaxU) {
            this.faceTextureMinU = faceTextureMinU;
            this.faceTextureMaxU = faceTextureMaxU;
            this.isFaceEnabled = true;
            return this;
        }

        @Override
        public Builder withBrightness(int brightness) {
            this.faceBrightness = brightness;
            this.bladeBrightness = brightness;
            return this;
        }

        public Builder withFaceBrightness(int brightness) {
            this.faceBrightness = class_3532.method_15340((int)brightness, (int)0, (int)5);
            return this;
        }

        public Builder withBladeBrightness(int brightness) {
            this.bladeBrightness = class_3532.method_15340((int)brightness, (int)0, (int)5);
            return this;
        }

        public Builder withSegmentsProvider(SegmentsProviders.SegmentsProvider segmentsProvider) {
            this.segmentsProvider = segmentsProvider;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            JsonObject bladeObj;
            super.withJsonObject(obj);
            JsonObject faceObj = obj.getAsJsonObject("face");
            if (faceObj != null) {
                float minU = JsonUtil.getJsonFloat(faceObj, "minU", 0.0f);
                float maxU = JsonUtil.getJsonFloat(faceObj, "maxU", 1.0f);
                this.withFace(minU, maxU);
                int brightness = JsonUtil.getJsonInt(faceObj, "brightness", 1);
                this.withFaceBrightness(brightness);
                Interpolators.FloatInterpolator widthInt = JsonUtil.getJsonInterpolator(faceObj, "width");
                if (widthInt != null) {
                    this.withFaceWidthProvider(widthInt);
                }
            }
            if ((bladeObj = obj.getAsJsonObject("blade")) != null) {
                int count = JsonUtil.getJsonInt(bladeObj, "count", 1);
                float minU = JsonUtil.getJsonFloat(bladeObj, "minU", 0.0f);
                float maxU = JsonUtil.getJsonFloat(bladeObj, "maxU", 1.0f);
                this.withBlades(count, minU, maxU);
                int brightness = JsonUtil.getJsonInt(bladeObj, "brightness", 1);
                this.withBladeBrightness(brightness);
                Interpolators.FloatInterpolator widthInt = JsonUtil.getJsonInterpolator(bladeObj, "width");
                if (widthInt != null) {
                    this.withBladeWidthProvider(widthInt);
                }
            }
            this.withRotations(JsonUtil.getJsonFloat(obj, "numRotations", 0.0f));
            float initialSpeed = JsonUtil.getJsonFloat(obj, "initialSpeed", 0.0f);
            float acceleration = JsonUtil.getJsonFloat(obj, "acceleration", 0.0f);
            if (this.numBlades > 0) {
                if (!MiscUtil.isNearlyZero(initialSpeed) || !MiscUtil.isNearlyZero(acceleration)) {
                    this.withSegmentsProvider(new SegmentsProviders.MovingSegmentsProvider(initialSpeed, acceleration));
                } else {
                    this.withSegmentsProvider(new SegmentsProviders.StaticBeamSegmentsProvider());
                }
            } else if (!MiscUtil.isNearlyZero(initialSpeed) || !MiscUtil.isNearlyZero(acceleration)) {
                this.withSegmentsProvider(new SegmentsProviders.MovingPointProvider(initialSpeed, acceleration));
            } else {
                this.withSegmentsProvider(SegmentsProviders.ZERO_PROVIDER);
            }
            return this;
        }

        @Override
        public boolean isEffectAttached() {
            return true;
        }

        @Override
        public AttachedProjectileEffect build(EffectBuilder.Context context) {
            AttachedProjectileEffect effect = new AttachedProjectileEffect();
            super.apply(effect, context);
            effect.randomization = 0.0f;
            effect.faceWidthProvider = this.faceWidthProvider;
            effect.bladeWidthProvider = this.bladeWidthProvider;
            effect.distanceProvider = !MiscUtil.isNearlyZero(context.getDistance()) ? () -> context.getDistance() : this.bladeLengthProvider;
            effect.isFaceEnabled = this.isFaceEnabled;
            effect.numBlades = this.numBlades;
            effect.bladeTextureMinU = this.bladeTextureMinU;
            effect.bladeTextureMaxU = this.bladeTextureMaxU;
            effect.faceTextureMinU = this.faceTextureMinU;
            effect.faceTextureMaxU = this.faceTextureMaxU;
            effect.faceBrightness = this.faceBrightness;
            effect.bladeBrightness = this.bladeBrightness;
            effect.segmentsProvider = this.segmentsProvider;
            Function<class_4588, class_4588> contextVertexConsumerTransformer = context.getVertexConsumerTransformer();
            effect.vertexConsumerTransformer = contextVertexConsumerTransformer != null ? contextVertexConsumerTransformer : VertexConsumers.PARTICLE;
            PoseProvider poseProvider = context.getPoseProvider();
            if (poseProvider != null && effect.poseProvider == null) {
                effect.poseProvider = poseProvider;
            }
            return effect;
        }

        @Override
        public Collection<GunItem.FirePhase> getCompatiblePhases() {
            return COMPATIBLE_PHASES;
        }
    }
}

