/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.effect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mod.pbj.Config;
import mod.pbj.Platform;
import mod.pbj.client.GunClientState;
import mod.pbj.client.GunStateListener;
import mod.pbj.client.GunStatePoseProvider;
import mod.pbj.client.PoseProvider;
import mod.pbj.client.PositionProvider;
import mod.pbj.client.VertexConsumers;
import mod.pbj.client.effect.EffectBuilder;
import mod.pbj.feature.Features;
import mod.pbj.item.GunItem;
import mod.pbj.network.EffectBroadcastPacket;
import mod.pbj.registry.EffectRegistry;
import mod.pbj.util.MiscUtil;
import mod.pbj.util.SimpleHitResult;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5498;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.util.ClientUtil;

public class EffectLauncher
implements GunStateListener {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static final int MAX_DISTANCE_SQR = 22500;
    private Map<GunItem.FirePhase, List<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>>> effectBuilders;

    public EffectLauncher(Map<GunItem.FirePhase, List<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>>> effectBuilders) {
        this.effectBuilders = effectBuilders;
    }

    @Override
    public void onPrepareFiring(class_1309 player, GunClientState gunClientState, class_1799 itemStack) {
        this.applyPhaseEffects(GunItem.FirePhase.PREPARING, player, gunClientState, itemStack, null, 0.0f, false);
    }

    @Override
    public void onStartFiring(class_1309 player, GunClientState state, class_1799 itemStack) {
        this.applyPhaseEffects(GunItem.FirePhase.FIRING, player, state, itemStack, null, 0.0f, false);
    }

    @Override
    public void onCompleteFiring(class_1309 player, GunClientState state, class_1799 itemStack) {
        this.applyPhaseEffects(GunItem.FirePhase.COMPLETETING, player, state, itemStack, null, 0.0f, false);
    }

    @Override
    public void onHitScanTargetAcquired(class_1309 player, GunClientState state, class_1799 itemStack, class_239 hitResult) {
        this.applyPhaseEffects(GunItem.FirePhase.HIT_SCAN_ACQUIRED, player, state, itemStack, hitResult, 0.0f, false);
    }

    @Override
    public void onHitScanTargetConfirmed(class_1309 player, GunClientState state, class_1799 itemStack, class_239 hitResult, float damage) {
        this.applyPhaseEffects(GunItem.FirePhase.HIT_TARGET, player, state, itemStack, hitResult, damage, false);
    }

    private static List<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>> getGlobalEffectBuilders(GunItem.FirePhase phase, class_1309 player, GunClientState gunClientState, class_1799 itemStack, class_239 hitResult, boolean thirdPersonOnly) {
        class_1297 entity;
        SimpleHitResult simpleHitResult;
        int entityId;
        if (phase == GunItem.FirePhase.HIT_TARGET && hitResult.method_17783() == class_239.class_240.field_1331 && hitResult instanceof SimpleHitResult && (entityId = (simpleHitResult = (SimpleHitResult)hitResult).getEntityId()) > 0 && (entity = ClientUtil.getLevel().method_8469(entityId)) instanceof class_1309) {
            return EffectRegistry.getEntityHitEffects(entity);
        }
        return Collections.emptyList();
    }

    private void applyPhaseEffects(GunItem.FirePhase phase, class_1309 player, GunClientState gunClientState, class_1799 itemStack, class_239 hitResult, float damage, boolean thirdPersonOnly) {
        if (!Config.particleEffectsEnabled) {
            return;
        }
        class_1792 item = itemStack.method_7909();
        if (!(item instanceof GunItem)) {
            return;
        }
        List mainPhaseEffectBuilders = this.effectBuilders.computeIfAbsent(phase, k -> new ArrayList());
        List<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>> featurePhaseEffectBuilders = Features.getEnabledPhaseEffects(itemStack, phase);
        ArrayList phaseEffectBuilders = new ArrayList(mainPhaseEffectBuilders);
        phaseEffectBuilders.addAll(featurePhaseEffectBuilders);
        phaseEffectBuilders.addAll(EffectLauncher.getGlobalEffectBuilders(phase, player, gunClientState, itemStack, hitResult, thirdPersonOnly));
        if (phaseEffectBuilders.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        float maxDistance = Math.min((float)(mc.field_1690.method_38521() * 16), 200.0f);
        if (mc.field_1690.method_31044() != class_5498.field_26664) {
            thirdPersonOnly = true;
        }
        float distanceToTarget = 0.0f;
        distanceToTarget = hitResult != null ? class_3532.method_15363((float)((float)Math.sqrt(hitResult.method_24801((class_1297)player)) - 0.5f), (float)0.0f, (float)maxDistance) : maxDistance;
        GunStatePoseProvider gunStatePoseProvider = GunStatePoseProvider.getInstance();
        class_243 startPosition = null;
        if (!thirdPersonOnly) {
            startPosition = gunStatePoseProvider.getPosition(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE);
            if (startPosition == null) {
                startPosition = gunStatePoseProvider.getPosition(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH);
            }
            if (startPosition == null) {
                startPosition = gunStatePoseProvider.getPosition(gunClientState, GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE);
            }
        }
        if (startPosition == null) {
            startPosition = gunStatePoseProvider.getPosition(gunClientState, GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE_FLASH);
        }
        for (Supplier supplier : phaseEffectBuilders) {
            EffectBuilder builder = (EffectBuilder)supplier.get();
            if (builder.getCompatiblePhases().contains((Object)phase)) {
                boolean isEffectAttached = builder.isEffectAttached();
                PoseProvider poseProvider = null;
                PositionProvider positionProvider = null;
                if (isEffectAttached) {
                    if (!thirdPersonOnly && gunStatePoseProvider.getPose(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH) != null) {
                        poseProvider = () -> gunStatePoseProvider.getPose(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH);
                    } else if (!thirdPersonOnly && gunStatePoseProvider.getPose(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE) != null) {
                        poseProvider = () -> gunStatePoseProvider.getPose(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE);
                    } else if (gunStatePoseProvider.getPose(gunClientState, GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE_FLASH) != null) {
                        poseProvider = () -> gunStatePoseProvider.getPose(gunClientState, GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE_FLASH);
                    } else if (gunStatePoseProvider.getPose(gunClientState, GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE) != null) {
                        poseProvider = () -> gunStatePoseProvider.getPose(gunClientState, GunStatePoseProvider.PoseContext.THIRD_PERSON_MUZZLE);
                    }
                    if (!thirdPersonOnly && gunStatePoseProvider.getPositionAndDirection(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH) != null) {
                        positionProvider = () -> gunStatePoseProvider.getPositionAndDirection(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH);
                    } else if (!thirdPersonOnly && gunStatePoseProvider.getPositionAndDirection(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE) != null) {
                        positionProvider = () -> gunStatePoseProvider.getPositionAndDirection(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE);
                    }
                } else {
                    if (!thirdPersonOnly && gunStatePoseProvider.getPose(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE) != null) {
                        poseProvider = () -> gunStatePoseProvider.getPose(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE);
                    } else if (!thirdPersonOnly && gunStatePoseProvider.getPose(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH) != null) {
                        poseProvider = () -> gunStatePoseProvider.getPose(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH);
                    }
                    if (!thirdPersonOnly && gunStatePoseProvider.getPositionAndDirection(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE) != null) {
                        positionProvider = () -> gunStatePoseProvider.getPositionAndDirection(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE);
                    } else if (!thirdPersonOnly && gunStatePoseProvider.getPositionAndDirection(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH) != null) {
                        positionProvider = () -> gunStatePoseProvider.getPositionAndDirection(gunClientState, GunStatePoseProvider.PoseContext.FIRST_PERSON_MUZZLE_FLASH);
                    }
                }
                EffectBuilder.Context effectBuilderContext = new EffectBuilder.Context().withGunState(gunClientState).withStartPosition(startPosition).withDistance(distanceToTarget).withRandomization(0.0f).withVertexConsumerTransformer(VertexConsumers.PARTICLE).withPoseProvider(poseProvider).withPositionProvider(positionProvider).withDamage(damage).withHitResult(hitResult);
                Object effect = builder.build(effectBuilderContext);
                LOGGER.debug("Launching effect {}", (Object)effect.getName());
                effect.launch((class_1297)player);
                continue;
            }
            throw new IllegalStateException("Effect builder " + String.valueOf(builder) + " is not compatible with phase '" + String.valueOf((Object)phase) + "'. Check how you construct item: " + String.valueOf(item.method_7864(itemStack)));
        }
    }

    public static void broadcast(Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> effectSupplier, class_1657 sourcePlayer, GunClientState state, class_1309 targetEntity, SimpleHitResult hitResult) {
        class_1937 level = MiscUtil.getLevel((class_1297)sourcePlayer);
        if (level.field_9236) {
            return;
        }
        class_243 targetPos = targetEntity.method_5829().method_1005();
        for (class_3222 nearbyPlayer : ((class_3218)level).method_18766(p -> true)) {
            if (!(nearbyPlayer.method_5707(targetPos) < 22500.0)) continue;
            Platform.getInstance().getNetworkService().sendToClient(new EffectBroadcastPacket(sourcePlayer.method_5628(), state.getId(), EffectRegistry.getEffectId(effectSupplier.get().getName()), targetPos, hitResult, false), (class_1657)nearbyPlayer);
        }
    }
}

