/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import mod.pbj.client.effect.Effect;
import mod.pbj.client.effect.EffectRenderContext;
import mod.pbj.client.uv.SpriteUVProvider;
import mod.pbj.util.MiscUtil;
import mod.pbj.util.TimeUnit;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_238;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffectParticles {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private static Function<EffectRenderKey, class_3999> effectRenderTypes = class_156.method_34866(key -> new EffectParticleRenderType(key.texture, key.blendMode, key.isDepthTestEnabled));

    public static class EffectParticleRenderType
    implements class_3999 {
        private class_2960 texture;
        private Effect.BlendMode blendMode;
        private boolean isDepthTestEnabled;

        public EffectParticleRenderType(class_2960 texture, Effect.BlendMode blendMode, boolean isDepthTestEnabled) {
            this.texture = texture;
            this.blendMode = blendMode;
            this.isDepthTestEnabled = isDepthTestEnabled;
        }

        public class_287 method_18130(class_289 tesselator, class_1060 textureManager) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
            RenderSystem.enableBlend();
            if (this.isDepthTestEnabled) {
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
            } else {
                RenderSystem.depthMask((boolean)false);
                RenderSystem.disableDepthTest();
            }
            RenderSystem.disableCull();
            switch (this.blendMode) {
                case ADDITIVE: {
                    RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                    break;
                }
                default: {
                    RenderSystem.defaultBlendFunc();
                }
            }
            class_310 mc = class_310.method_1551();
            mc.field_1773.method_22974().method_3316();
            return tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1584);
        }
    }

    private static class EffectRenderKey {
        class_2960 texture;
        Effect.BlendMode blendMode;
        boolean isDepthTestEnabled;

        EffectRenderKey(class_2960 texture, Effect.BlendMode blendMode, boolean isDepthTestEnabled) {
            this.texture = texture;
            this.blendMode = blendMode;
            this.isDepthTestEnabled = isDepthTestEnabled;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.blendMode, this.isDepthTestEnabled, this.texture});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EffectRenderKey other = (EffectRenderKey)obj;
            return this.blendMode == other.blendMode && this.isDepthTestEnabled == other.isDepthTestEnabled && Objects.equals(this.texture, other.texture);
        }
    }

    public static class EffectParticleProvider
    implements class_707<class_2400> {
        public EffectParticleProvider(class_4002 spriteSet) {
        }

        public class_703 createParticle(class_2400 particleType, class_638 level, double posX, double posY, double posZ, double xd, double yd, double zd) {
            EffectParticle particle = new EffectParticle(level, posX, posY, posZ);
            return particle;
        }
    }

    public static class EffectParticle
    extends class_703 {
        public static final class_238 INFINITE_EXTENT_AABB = new class_238(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        private class_3999 renderType;
        private class_1297 owner;
        private float initialRoll;
        protected Effect effect;
        private boolean hasInfiniteBounds;
        protected SpriteUVProvider spriteUVProvider;
        private int delay;

        protected EffectParticle(class_638 level, double x, double y, double z) {
            super(level, x, y, z);
        }

        public EffectParticle(class_1297 owner, Effect effect) {
            super((class_638)MiscUtil.getLevel(owner), 0.0, 0.0, 0.0);
            this.effect = effect;
            this.hasInfiniteBounds = effect.hasInfiniteBounds();
            class_243 startPosition = effect.getStartPositionProvider().get();
            Random random = new Random();
            this.method_3063(startPosition.field_1352 + (double)(random.nextFloat() * 0.01f), startPosition.field_1351 + (double)(random.nextFloat() * 0.01f), startPosition.field_1350 + (double)(random.nextFloat() * 0.01f));
            this.field_3858 = this.field_3874;
            this.field_3838 = this.field_3854;
            this.field_3856 = this.field_3871;
            this.field_3852 *= (double)0.1f;
            this.field_3869 *= (double)0.1f;
            this.field_3850 *= (double)0.1f;
            class_243 velocity = effect.getVelocityProvider().get();
            float c = 1.0f;
            this.field_3852 += velocity.field_1352 * (double)c;
            this.field_3869 += velocity.field_1351 * (double)c;
            this.field_3850 += velocity.field_1350 * (double)c;
            this.field_3862 = effect.hasPhysics();
            this.owner = owner;
            this.delay = (int)TimeUnit.MILLISECOND.toTicks(effect.getDelay());
            this.field_3847 = (int)TimeUnit.MILLISECOND.toTicks(effect.getDuration()) + this.delay;
            this.renderType = effectRenderTypes.apply(new EffectRenderKey(effect.getTexture(), effect.getBlendMode(), effect.isDepthTestEnabled()));
            this.initialRoll = effect.getInitialRoll();
            this.field_28786 = effect.getFriction();
            this.field_3844 = effect.getGravity();
            this.field_28787 = true;
            this.spriteUVProvider = effect.getSpriteUVProvider();
        }

        public boolean shouldCull() {
            return true;
        }

        protected float getProgress(float partialTick) {
            int adjustedAge = this.field_3866 - this.delay;
            float elapsedTimeTicks = (float)adjustedAge + partialTick;
            float progress = adjustedAge < 0 ? elapsedTimeTicks / (float)this.delay : elapsedTimeTicks / (float)(this.field_3847 - this.delay);
            return class_3532.method_15363((float)progress, (float)-1.0f, (float)1.0f);
        }

        public void method_3074(class_4588 vertexConsumer, class_4184 camera, float partialTick) {
            try {
                if (camera.method_19331() != this.owner) {
                    // empty if block
                }
                int lightColor = this.method_3068(partialTick);
                double posX = class_3532.method_16436((double)partialTick, (double)this.field_3858, (double)this.field_3874);
                double posY = class_3532.method_16436((double)partialTick, (double)this.field_3838, (double)this.field_3854);
                double posZ = class_3532.method_16436((double)partialTick, (double)this.field_3856, (double)this.field_3871);
                float progress = this.getProgress(partialTick);
                EffectRenderContext effectRenderContext = new EffectRenderContext().withCamera(camera).withRotation(this.effect.getRotation()).withPosition(new class_243(posX, posY, posZ)).withInitialAngle(this.initialRoll).withVertexBuffer(vertexConsumer).withProgress(progress).withLightColor(lightColor).withSpriteUVProvider(this.spriteUVProvider);
                this.effect.render(effectRenderContext);
            }
            catch (Exception e) {
                LOGGER.error("Failed to render effect particle: {}", (Throwable)e);
            }
        }

        public class_3999 method_18122() {
            return this.renderType;
        }

        public class_238 method_3064() {
            if (this.hasInfiniteBounds) {
                return INFINITE_EXTENT_AABB;
            }
            return super.method_3064();
        }

        public void method_3070() {
            super.method_3070();
        }
    }
}

