/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntIterator;
import mod.pbj.Config;
import mod.pbj.client.ClientSystem;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import net.minecraft.class_7836;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;

public class RenderUtil {
    private static final double FOV_NORMAL_DEGREES = 70.0;
    private static Matrix4f projectionMatrix;
    private static Matrix4f projectionMatrixInverted;
    private static Matrix4f modelViewMatrix;
    private static Matrix4f modelViewMatrixInverted;

    public static void renderQuad(class_4587 poseStack, GeoQuad quad, class_4588 buffer, float dx, float dy, int color) {
        Matrix4f poseState = poseStack.method_23760().method_23761();
        float[][] texUV = new float[][]{{1.0f + dx, 0.0f + dy}, {0.0f + dx, 0.0f + dy}, {0.0f + dx, 1.0f + dy}, {1.0f + dx, 1.0f + dy}};
        for (int i = 0; i < 4; ++i) {
            GeoVertex vertex = quad.vertices()[i];
            float u = class_3532.method_15363((float)texUV[i][0], (float)0.0f, (float)1.0f);
            float v = class_3532.method_15363((float)texUV[i][1], (float)0.0f, (float)1.0f);
            buffer.method_22918(poseState, vertex.position().x, vertex.position().y, vertex.position().z).method_22913(u, v).method_39415(color);
        }
    }

    public static void renderColoredQuad(class_4587 poseStack, GeoQuad quad, class_4588 buffer, float red, float green, float blue, float alpha) {
        Matrix4f poseState = poseStack.method_23760().method_23761();
        for (int i = 0; i < 4; ++i) {
            GeoVertex v = quad.vertices()[i];
            buffer.method_22918(poseState, v.position().x, v.position().y, v.position().z).method_22915(red, green, blue, alpha);
        }
    }

    public static void blit(class_332 guiGraphics, class_2960 textureResource, float posX, float posY, int zLevel, float minU, float minV, int width, int height, int actualWidth, int actualHeight) {
        RenderUtil.blit(guiGraphics, textureResource, posX, posX + (float)width, posY, posY + (float)height, zLevel, width, height, minU, minV, actualWidth, actualHeight);
    }

    public static void blit(class_332 guiGraphics, class_2960 textureResource, float posXStart, float posXEnd, float posYStart, float posYEnd, int zLevel, int width, int height, float minU, float minV, int actualWidth, int actualHeight) {
        RenderUtil.blit(guiGraphics, textureResource, posXStart, posXEnd, posYStart, posYEnd, (float)zLevel, (minU + 0.0f) / (float)actualWidth, (minU + (float)width) / (float)actualWidth, (minV + 0.0f) / (float)actualHeight, (minV + (float)height) / (float)actualHeight);
    }

    public static void blit(class_332 guiGraphics, class_2960 textureResource, float posXStart, float posXEnd, float posYStart, float posYEnd, float zLevel, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShaderTexture((int)0, (class_2960)textureResource);
        RenderSystem.setShader(class_757::method_34542);
        Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
        class_287 bufferbuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferbuilder.method_22918(matrix4f, posXStart, posYStart, zLevel).method_22913(minU, minV);
        bufferbuilder.method_22918(matrix4f, posXStart, posYEnd, zLevel).method_22913(minU, maxV);
        bufferbuilder.method_22918(matrix4f, posXEnd, posYEnd, zLevel).method_22913(maxU, maxV);
        bufferbuilder.method_22918(matrix4f, posXEnd, posYStart, zLevel).method_22913(maxU, minV);
        class_286.method_43433((class_9801)bufferbuilder.method_60800());
    }

    public static void blit(class_332 guiGraphics, class_2960 resourceLocation, int startX, int endX, int startY, int endY, int zLevel, float minU, float maxU, float minV, float maxV, float colorR, float colorG, float colorB, float alpha) {
        RenderSystem.setShaderTexture((int)0, (class_2960)resourceLocation);
        RenderSystem.setShader(Config.customShadersEnabled ? ClientSystem.getInstance()::getTexColorShaderInstance : class_757::method_34543);
        RenderSystem.enableBlend();
        Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22918(matrix4f, (float)startX, (float)startY, (float)zLevel).method_22913(minU, minV).method_22915(colorR, colorG, colorB, alpha);
        bufferBuilder.method_22918(matrix4f, (float)startX, (float)endY, (float)zLevel).method_22913(minU, maxV).method_22915(colorR, colorG, colorB, alpha);
        bufferBuilder.method_22918(matrix4f, (float)endX, (float)endY, (float)zLevel).method_22913(maxU, maxV).method_22915(colorR, colorG, colorB, alpha);
        bufferBuilder.method_22918(matrix4f, (float)endX, (float)startY, (float)zLevel).method_22913(maxU, minV).method_22915(colorR, colorG, colorB, alpha);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static Matrix4f getProjectionMatrixInverted() {
        Matrix4f projectionMatrixNew = RenderSystem.getProjectionMatrix();
        if (projectionMatrixNew == null || projectionMatrixNew != projectionMatrix) {
            projectionMatrix = projectionMatrixNew;
            projectionMatrixInverted = new Matrix4f((Matrix4fc)projectionMatrixNew).invert();
        }
        return projectionMatrixInverted;
    }

    public static Matrix4f getModelViewMatrixInverted() {
        Matrix4f modelViewMatrixNew = RenderSystem.getModelViewMatrix();
        if (modelViewMatrixNew == null || modelViewMatrixNew != modelViewMatrix) {
            modelViewMatrix = modelViewMatrixNew;
            modelViewMatrixInverted = new Matrix4f((Matrix4fc)modelViewMatrixNew).invert();
        }
        return modelViewMatrixInverted;
    }

    public static Matrix4f getProjectionMatrixNormalFov() {
        class_310 mc = class_310.method_1551();
        return mc.field_1773.method_22973(70.0);
    }

    public static void blitNineSliced(class_332 guiGraphics, class_2960 p_282543_, int p_281513_, int p_281865_, int p_282482_, int p_282661_, int p_282068_, int p_281294_, int p_281681_, int p_281957_, int p_282300_, int p_282769_) {
        RenderUtil.blitNineSliced(guiGraphics, p_282543_, p_281513_, p_281865_, p_282482_, p_282661_, p_282068_, p_281294_, p_282068_, p_281294_, p_281681_, p_281957_, p_282300_, p_282769_);
    }

    public static void blitNineSliced(class_332 guiGraphics, class_2960 p_282712_, int p_283509_, int p_283259_, int p_283273_, int p_282043_, int p_281430_, int p_281412_, int p_282566_, int p_281971_, int p_282879_, int p_281529_, int p_281924_, int p_281407_) {
        p_281430_ = Math.min(p_281430_, p_283273_ / 2);
        p_282566_ = Math.min(p_282566_, p_283273_ / 2);
        p_281412_ = Math.min(p_281412_, p_282043_ / 2);
        p_281971_ = Math.min(p_281971_, p_282043_ / 2);
        if (p_283273_ == p_282879_ && p_282043_ == p_281529_) {
            guiGraphics.method_25302(p_282712_, p_283509_, p_283259_, p_281924_, p_281407_, p_283273_, p_282043_);
        } else if (p_282043_ == p_281529_) {
            guiGraphics.method_25302(p_282712_, p_283509_, p_283259_, p_281924_, p_281407_, p_281430_, p_282043_);
            RenderUtil.blitRepeating(guiGraphics, p_282712_, p_283509_ + p_281430_, p_283259_, p_283273_ - p_282566_ - p_281430_, p_282043_, p_281924_ + p_281430_, p_281407_, p_282879_ - p_282566_ - p_281430_, p_281529_);
            guiGraphics.method_25302(p_282712_, p_283509_ + p_283273_ - p_282566_, p_283259_, p_281924_ + p_282879_ - p_282566_, p_281407_, p_282566_, p_282043_);
        } else if (p_283273_ == p_282879_) {
            guiGraphics.method_25302(p_282712_, p_283509_, p_283259_, p_281924_, p_281407_, p_283273_, p_281412_);
            RenderUtil.blitRepeating(guiGraphics, p_282712_, p_283509_, p_283259_ + p_281412_, p_283273_, p_282043_ - p_281971_ - p_281412_, p_281924_, p_281407_ + p_281412_, p_282879_, p_281529_ - p_281971_ - p_281412_);
            guiGraphics.method_25302(p_282712_, p_283509_, p_283259_ + p_282043_ - p_281971_, p_281924_, p_281407_ + p_281529_ - p_281971_, p_283273_, p_281971_);
        } else {
            guiGraphics.method_25302(p_282712_, p_283509_, p_283259_, p_281924_, p_281407_, p_281430_, p_281412_);
            RenderUtil.blitRepeating(guiGraphics, p_282712_, p_283509_ + p_281430_, p_283259_, p_283273_ - p_282566_ - p_281430_, p_281412_, p_281924_ + p_281430_, p_281407_, p_282879_ - p_282566_ - p_281430_, p_281412_);
            guiGraphics.method_25302(p_282712_, p_283509_ + p_283273_ - p_282566_, p_283259_, p_281924_ + p_282879_ - p_282566_, p_281407_, p_282566_, p_281412_);
            guiGraphics.method_25302(p_282712_, p_283509_, p_283259_ + p_282043_ - p_281971_, p_281924_, p_281407_ + p_281529_ - p_281971_, p_281430_, p_281971_);
            RenderUtil.blitRepeating(guiGraphics, p_282712_, p_283509_ + p_281430_, p_283259_ + p_282043_ - p_281971_, p_283273_ - p_282566_ - p_281430_, p_281971_, p_281924_ + p_281430_, p_281407_ + p_281529_ - p_281971_, p_282879_ - p_282566_ - p_281430_, p_281971_);
            guiGraphics.method_25302(p_282712_, p_283509_ + p_283273_ - p_282566_, p_283259_ + p_282043_ - p_281971_, p_281924_ + p_282879_ - p_282566_, p_281407_ + p_281529_ - p_281971_, p_282566_, p_281971_);
            RenderUtil.blitRepeating(guiGraphics, p_282712_, p_283509_, p_283259_ + p_281412_, p_281430_, p_282043_ - p_281971_ - p_281412_, p_281924_, p_281407_ + p_281412_, p_281430_, p_281529_ - p_281971_ - p_281412_);
            RenderUtil.blitRepeating(guiGraphics, p_282712_, p_283509_ + p_281430_, p_283259_ + p_281412_, p_283273_ - p_282566_ - p_281430_, p_282043_ - p_281971_ - p_281412_, p_281924_ + p_281430_, p_281407_ + p_281412_, p_282879_ - p_282566_ - p_281430_, p_281529_ - p_281971_ - p_281412_);
            RenderUtil.blitRepeating(guiGraphics, p_282712_, p_283509_ + p_283273_ - p_282566_, p_283259_ + p_281412_, p_281430_, p_282043_ - p_281971_ - p_281412_, p_281924_ + p_282879_ - p_282566_, p_281407_ + p_281412_, p_282566_, p_281529_ - p_281971_ - p_281412_);
        }
    }

    public static void blitRepeating(class_332 guiGraphics, class_2960 p_283059_, int p_283575_, int p_283192_, int p_281790_, int p_283642_, int p_282691_, int p_281912_, int p_281728_, int p_282324_) {
        RenderUtil.blitRepeating(guiGraphics, p_283059_, p_283575_, p_283192_, p_281790_, p_283642_, p_282691_, p_281912_, p_281728_, p_282324_, 256, 256);
    }

    public static void blitRepeating(class_332 guiGraphics, class_2960 p_283059_, int p_283575_, int p_283192_, int p_281790_, int p_283642_, int p_282691_, int p_281912_, int p_281728_, int p_282324_, int textureWidth, int textureHeight) {
        int i = p_283575_;
        IntIterator intiterator = RenderUtil.slices(p_281790_, p_281728_);
        while (intiterator.hasNext()) {
            int j = intiterator.nextInt();
            int k = (p_281728_ - j) / 2;
            int l = p_283192_;
            IntIterator intiterator1 = RenderUtil.slices(p_283642_, p_282324_);
            while (intiterator1.hasNext()) {
                int i1 = intiterator1.nextInt();
                int j1 = (p_282324_ - i1) / 2;
                guiGraphics.method_25290(p_283059_, i, l, (float)(p_282691_ + k), (float)(p_281912_ + j1), j, i1, textureWidth, textureHeight);
                l += i1;
            }
            i += j;
        }
    }

    private static IntIterator slices(int p_282197_, int p_282161_) {
        int i = class_3532.method_38788((int)p_282197_, (int)p_282161_);
        return new class_7836(p_282197_, i);
    }

    public static void renderTooltipBackground(class_332 p_282666_, int p_281901_, int p_281846_, int p_281559_, int p_283336_, int p_283422_, int backgroundTop, int backgroundBottom, int borderTop, int borderBottom) {
        int i = p_281901_ - 3;
        int j = p_281846_ - 3;
        int k = p_281559_ + 3 + 3;
        int l = p_283336_ + 3 + 3;
        RenderUtil.renderHorizontalLine(p_282666_, i, j - 1, k, p_283422_, backgroundTop);
        RenderUtil.renderHorizontalLine(p_282666_, i, j + l, k, p_283422_, backgroundBottom);
        RenderUtil.renderRectangleGradient(p_282666_, i, j, k, l, p_283422_, backgroundTop, backgroundBottom);
        RenderUtil.renderVerticalLineGradient(p_282666_, i - 1, j, l, p_283422_, backgroundTop, backgroundBottom);
        RenderUtil.renderVerticalLineGradient(p_282666_, i + k, j, l, p_283422_, backgroundTop, backgroundBottom);
        RenderUtil.renderFrameGradient(p_282666_, i, j + 1, k, l, p_283422_, borderTop, borderBottom);
    }

    public static void renderHorizontalLine(class_332 guiGraphics, int p_282028_, int p_282141_, int p_281771_, int p_282734_, int p_281979_) {
        guiGraphics.method_51737(p_282028_, p_282141_, p_282028_ + p_281771_, p_282141_ + 1, p_282734_, p_281979_);
    }

    public static void renderVerticalLineGradient(class_332 guiGraphics, int $$1, int $$2, int $$3, int $$4, int $$5, int $$6) {
        guiGraphics.method_33284($$1, $$2, $$1 + 1, $$2 + $$3, $$4, $$5, $$6);
    }

    public static void renderFrameGradient(class_332 guiGraphics, int $$1, int $$2, int $$3, int $$4, int $$5, int $$6, int $$7) {
        RenderUtil.renderVerticalLineGradient(guiGraphics, $$1, $$2, $$4 - 2, $$5, $$6, $$7);
        RenderUtil.renderVerticalLineGradient(guiGraphics, $$1 + $$3 - 1, $$2, $$4 - 2, $$5, $$6, $$7);
        RenderUtil.renderHorizontalLine(guiGraphics, $$1, $$2 - 1, $$3, $$5, $$6);
        RenderUtil.renderHorizontalLine(guiGraphics, $$1, $$2 - 1 + $$4 - 1, $$3, $$5, $$7);
    }

    private static void renderRectangleGradient(class_332 guiGraphics, int p_282294_, int p_283353_, int p_282640_, int p_281964_, int p_283211_, int p_282349_, int colorTo) {
        guiGraphics.method_33284(p_282294_, p_283353_, p_282294_ + p_282640_, p_283353_ + p_281964_, p_283211_, p_282349_, colorTo);
    }
}

