/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.render.layer;

import mod.pbj.client.render.HierarchicalRenderContext;
import mod.pbj.client.render.RenderPass;
import mod.pbj.client.render.RenderTypeProvider;
import mod.pbj.client.render.layer.FeaturePassLayer;
import mod.pbj.feature.GlowFeature;
import mod.pbj.item.GunItem;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;

public class GlowingItemLayer<T extends GeoAnimatable>
extends FeaturePassLayer<T> {
    public static final String HRC_ATTRIBUTE_GLOW_ENABLED = "isGlowEnabled";
    private class_1921 renderType;

    public GlowingItemLayer(GeoRenderer<T> renderer, int effectId, class_2960 texture) {
        super(renderer, GlowFeature.class, RenderPass.GLOW, ALL_PARTS, true, effectId);
        RenderTypeProvider renderTypeProvider = RenderTypeProvider.getInstance();
        this.renderType = renderTypeProvider.getGlowRenderType(texture);
    }

    protected class_1921 getRenderType(GunItem animatable) {
        return this.renderType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(BakedGeoModel attachmentModel, class_4587 poseStack, class_4597 bufferSource, T animatable, class_1921 renderType, class_4588 buffer, float partialTick, int packedLight, int overlay, float red, float green, float blue, float alpha) {
        RenderPass.push(this.getRenderPass());
        try {
            RenderPass.setEffectId(this.effectId);
            RenderTypeProvider renderTypeProvider = RenderTypeProvider.getInstance();
            float glowBrightness = renderTypeProvider.getGlowBrightness();
            super.render(attachmentModel, poseStack, bufferSource, animatable, renderType, buffer, partialTick, packedLight, overlay, glowBrightness, glowBrightness, glowBrightness, 1.0f);
        }
        finally {
            RenderPass.pop();
        }
    }

    @Override
    public class_1921 getRenderType() {
        return this.renderType;
    }

    @Override
    public boolean isSupportedItemDisplayContext(class_811 context) {
        return true;
    }

    @Override
    public boolean approveRendering(RenderPass renderPass, String partName, class_1799 rootStack, class_1799 currentStack, String path, class_811 itemDisplayContext) {
        if (GlowingItemLayer.isGlowEnabled()) {
            return true;
        }
        return super.approveRendering(renderPass, partName, rootStack, currentStack, path, itemDisplayContext);
    }

    public static boolean isGlowEnabled() {
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        Boolean isGlowEnabled = (Boolean)current.getAttribute(HRC_ATTRIBUTE_GLOW_ENABLED);
        return isGlowEnabled != null && isGlowEnabled != false;
    }

    public static void setGlowEnabled(boolean isGlowEnabled) {
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        current.setAttribute(HRC_ATTRIBUTE_GLOW_ENABLED, isGlowEnabled);
    }
}

