/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.client.render.layer;

import java.util.List;
import mod.pbj.client.render.GunItemRenderer;
import mod.pbj.client.render.HierarchicalRenderContext;
import mod.pbj.client.render.RenderPass;
import mod.pbj.client.render.RenderTypeProvider;
import mod.pbj.client.render.layer.FeaturePassLayer;
import mod.pbj.feature.FeatureProvider;
import mod.pbj.feature.ReticleFeature;
import mod.pbj.item.GunItem;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;

public class ReticleItemLayer
extends FeaturePassLayer<GunItem> {
    public static final String HRC_ATTRIBUTE_PARALLAX_ENABLED = "is_parallax_enabled";
    public static final String HRC_ATTRIBUTE_MAX_ANGULAR_OFFSET_COS = "max_angular_offset_cos";

    public ReticleItemLayer(GunItemRenderer renderer) {
        super(renderer, ReticleFeature.class, RenderPass.RETICLE, List.of("scope", "reticle"), true, null);
    }

    @Override
    public void render(BakedGeoModel attachmentModel, class_4587 poseStack, class_4597 bufferSource, GunItem animatable, class_1921 origRenderType, class_4588 origBuffer, float partialTick, int packedLight, int overlay, float red, float green, float blue, float alpha) {
        FeatureProvider fp;
        ReticleFeature feature;
        class_1792 class_17922;
        boolean isParallaxEnabled = false;
        float maxAngularOffsetCos = ReticleFeature.DEFAULT_MAX_ANGULAR_OFFSET_COS;
        class_1921 renderType = null;
        HierarchicalRenderContext hrc = HierarchicalRenderContext.current();
        if (hrc != null && (class_17922 = hrc.getItemStack().method_7909()) instanceof FeatureProvider && (feature = (fp = (FeatureProvider)class_17922).getFeature(ReticleFeature.class)) != null && feature.isEnabled(hrc.getItemStack())) {
            isParallaxEnabled = feature.isParallaxEnabled();
            maxAngularOffsetCos = feature.getMaxAngularOffsetCos();
            RenderTypeProvider renderTypeProvider = RenderTypeProvider.getInstance();
            renderType = renderTypeProvider.getReticleRenderType(feature.getTexture(), isParallaxEnabled);
        }
        if (renderType == null) {
            return;
        }
        class_4588 buffer = bufferSource.getBuffer(renderType);
        RenderTypeProvider renderTypeProvider = RenderTypeProvider.getInstance();
        float reticleBrightness = renderTypeProvider.getReticleBrightness();
        try (HierarchicalRenderContext subHrc = HierarchicalRenderContext.push();){
            subHrc.setAttribute(HRC_ATTRIBUTE_PARALLAX_ENABLED, isParallaxEnabled);
            subHrc.setAttribute(HRC_ATTRIBUTE_MAX_ANGULAR_OFFSET_COS, Float.valueOf(maxAngularOffsetCos));
            RenderPass renderPass = RenderPass.current();
            super.render(attachmentModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType, buffer, partialTick, packedLight, overlay, reticleBrightness, reticleBrightness, reticleBrightness, 1.0f);
        }
    }

    @Override
    public class_1921 getRenderType() {
        return RenderTypeProvider.NO_RENDER_TYPE;
    }

    @Override
    public boolean isSupportedItemDisplayContext(class_811 context) {
        return context == class_811.field_4321 || context == class_811.field_4322;
    }

    public static boolean isParallaxEnabled() {
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        Boolean isParallaxEnabled = (Boolean)current.getAttribute(HRC_ATTRIBUTE_PARALLAX_ENABLED);
        return isParallaxEnabled != null && isParallaxEnabled != false;
    }
}

