/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.compat.iris;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.FileNotFoundException;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.pbj.client.ClientSystem;
import mod.pbj.client.render.Flushable;
import mod.pbj.client.render.RenderTypeProvider;
import mod.pbj.compat.iris.IrisAuxShaderProvider;
import net.irisshaders.batchedentityrendering.impl.FullyBufferedMultiBufferSource;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5944;
import net.minecraft.class_757;

public class IrisRenderTypeProvider
extends class_4668
implements RenderTypeProvider {
    private Function<Boolean, class_1921> pipRenderTypes = class_156.method_34866(isMasked -> this.createPipRenderType((boolean)isMasked));
    private final Function<class_2960, class_1921> pipMaskRenderTypes = class_156.method_34866(texture -> this.createPipMaskRenderType(IrisRenderTypeProvider.getIrisTexture(texture), this::getPipMaskShader));
    private final Function<class_2960, class_1921> pipOverlayRenderTypes = class_156.method_34866(texture -> IrisRenderTypeProvider.createPipOverlayRenderType(IrisRenderTypeProvider.getIrisTexture(texture), class_757::method_34543, false));
    private final Function<class_2960, class_1921> pipOverlayMaskedRenderTypes = class_156.method_34866(texture -> IrisRenderTypeProvider.createPipOverlayRenderType(IrisRenderTypeProvider.getIrisTexture(texture), this::getPipOverlayShader, true));
    private final Function<class_2960, class_1921> reticleRenderTypes = class_156.method_34866(texture -> IrisRenderTypeProvider.createReticleRenderType(IrisRenderTypeProvider.getIrisTexture(texture)));
    private final Function<class_2960, class_1921> reticleRenderTypesWithParallax = class_156.method_34866(texture -> IrisRenderTypeProvider.createReticleRenderType(IrisRenderTypeProvider.getIrisTexture(texture), class_757::method_34543));
    private final Function<class_2960, class_1921> glowRenderTypes = class_156.method_34866(texture -> GlowRenderType.createRenderType(IrisRenderTypeProvider.getIrisTexture(texture)));

    public IrisRenderTypeProvider() {
        super(null, null, null);
    }

    @Override
    public class_4597 wrapBufferSource(class_4597 source) {
        return new WrappedBufferSource(source);
    }

    @Override
    public class_1921 getPipRenderType(boolean isMasked) {
        return this.pipRenderTypes.apply(isMasked);
    }

    private class_5944 getPipShader() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipeline().orElse(null);
        class_5944 shader = null;
        if (pipeline instanceof IrisAuxShaderProvider) {
            IrisAuxShaderProvider auxShaderProvider = (IrisAuxShaderProvider)pipeline;
            shader = auxShaderProvider.getPointblankAuxShader();
        }
        if (shader == null) {
            shader = class_757.method_34543();
        }
        return shader;
    }

    private class_5944 getPipOverlayShader() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipeline().orElse(null);
        class_5944 shader = null;
        if (pipeline instanceof IrisAuxShaderProvider) {
            IrisAuxShaderProvider auxShaderProvider = (IrisAuxShaderProvider)pipeline;
            shader = auxShaderProvider.getPointblankAuxPlainShader();
        }
        if (shader == null) {
            shader = class_757.method_34543();
        }
        return shader;
    }

    private class_5944 getPipMaskShader() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipeline().orElse(null);
        class_5944 shader = null;
        if (pipeline instanceof IrisAuxShaderProvider) {
            IrisAuxShaderProvider auxShaderProvider = (IrisAuxShaderProvider)pipeline;
            shader = auxShaderProvider.getPointblankMaskShader();
        }
        if (shader == null) {
            shader = class_757.method_34543();
        }
        return shader;
    }

    @Override
    public class_1921 getPipOverlayRenderType(class_2960 texture, boolean isMasked) {
        return isMasked ? this.pipOverlayMaskedRenderTypes.apply(texture) : this.pipOverlayRenderTypes.apply(texture);
    }

    @Override
    public class_1921 getPipMaskRenderType(class_2960 texture) {
        return this.pipMaskRenderTypes.apply(texture);
    }

    @Override
    public class_1921 getGlowRenderType(class_2960 texture) {
        return this.glowRenderTypes.apply(texture);
    }

    @Override
    public class_1921 getGlowBlockEntityRenderType(class_2960 texture) {
        return class_1921.method_23580((class_2960)texture);
    }

    @Override
    public class_1921 getMuzzleFlashRenderType(class_2960 texture) {
        return class_1921.method_42600((class_2960)texture);
    }

    @Override
    public class_1921 getReticleRenderType(class_2960 texture, boolean isParallaxEnabled) {
        return isParallaxEnabled ? this.reticleRenderTypesWithParallax.apply(texture) : this.reticleRenderTypes.apply(texture);
    }

    private static class_2960 getIrisTexture(class_2960 originalTexture) {
        class_310 mc = class_310.method_1551();
        class_3300 resourceManager = mc.method_1478();
        String path = originalTexture.method_12832();
        if (path.endsWith(".png")) {
            String modifiedPath = path.replace(".png", "_iris.png");
            class_2960 irisTexture = class_2960.method_60655((String)originalTexture.method_12836(), (String)modifiedPath);
            try {
                resourceManager.getResourceOrThrow(irisTexture);
                return irisTexture;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return originalTexture;
    }

    private static class_1921 createReticleRenderType(class_2960 texture, Supplier<class_5944> shaderSupplier) {
        return class_1921.method_24049((String)"pointblank:reticle_iris_with_parallax", (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23615(class_4668.field_21370).method_23603(field_21345).method_23604(field_21348).method_23608(field_21384).method_23611(field_21386).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_34578(new class_4668.class_5942(shaderSupplier::get)).method_23617(false));
    }

    private static class_1921 createReticleRenderType(class_2960 texture) {
        class_1921.class_4688 compositeState = class_1921.class_4688.method_23598().method_34578(field_38344).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23615(field_21370).method_23603(field_21345).method_23617(true);
        return class_1921.method_24049((String)"pointblank:reticle_iris", (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)compositeState);
    }

    private class_1921 createPipRenderType(boolean isMasked) {
        class_1921.class_4688 compositeState = class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(this::getPipShader)).method_34577((class_4668.class_5939)new PipTextureStateShard()).method_23615(field_21364).method_23608(field_21384).method_23611(field_21386).method_23617(true);
        Runnable setup = isMasked ? SETUP_STENCIL_RENDER : () -> {};
        Runnable clear = isMasked ? CLEAR_STENCIL_RENDER : () -> {};
        return RenderTypeProvider.wrapRenderType((class_1921)class_1921.method_24049((String)("pointblank:pip_iris_" + isMasked), (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)compositeState), setup, clear);
    }

    private class_1921 createPipMaskRenderType(class_2960 maskTexture, Supplier<class_5944> shaderSupplier) {
        return RenderTypeProvider.wrapRenderType((class_1921)class_1921.method_24049((String)"pointblank:pip_mask_iris", (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23604(field_21346).method_23608(field_21384).method_23611(field_21386).method_23615(field_21364).method_34577((class_4668.class_5939)new class_4668.class_4683(maskTexture, false, false)).method_34578(new class_4668.class_5942(shaderSupplier::get)).method_23617(false)), RenderTypeProvider.SETUP_STENCIL_MASK_RENDER, RenderTypeProvider.CLEAR_STENCIL_MASK_RENDER);
    }

    private static class_1921 createPipOverlayRenderType(class_2960 overlayTexture, Supplier<class_5944> shaderSupplier, boolean isMasked) {
        Runnable setup = isMasked ? SETUP_STENCIL_RENDER : () -> {};
        Runnable clear = isMasked ? CLEAR_STENCIL_RENDER : () -> {};
        return RenderTypeProvider.wrapRenderType((class_1921)class_1921.method_24049((String)("pointblank:pip_overlay_iris_" + isMasked), (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23615(class_4668.field_21370).method_23603(field_21345).method_23604(field_21348).method_23608(field_21384).method_23611(field_21386).method_34577((class_4668.class_5939)new class_4668.class_4683(overlayTexture, false, false)).method_34578(new class_4668.class_5942(shaderSupplier::get)).method_23617(false)), setup, clear);
    }

    @Override
    public float getReticleBrightness() {
        return 0.6f;
    }

    @Override
    public float getGlowBrightness() {
        return 0.6f;
    }

    private static class WrappedBufferSource
    implements class_4597,
    Flushable {
        private final class_4597 delegate;

        WrappedBufferSource(class_4597 delegate) {
            this.delegate = delegate;
        }

        @Override
        public void flush() {
            class_4597 class_45972 = this.delegate;
            if (class_45972 instanceof FullyBufferedMultiBufferSource) {
                FullyBufferedMultiBufferSource fbmbs = (FullyBufferedMultiBufferSource)class_45972;
                fbmbs.method_22993();
            }
        }

        public class_4588 getBuffer(class_1921 renderType) {
            if (renderType == RenderTypeProvider.NO_RENDER_TYPE) {
                return null;
            }
            return this.delegate.getBuffer(renderType);
        }
    }

    private static class PipTextureStateShard
    extends class_4668.class_5939 {
        public PipTextureStateShard() {
            super(() -> {
                int textureId = ClientSystem.getInstance().getAuxLevelRenderer().getRenderTarget().method_30277();
                RenderSystem.setShaderTexture((int)0, (int)textureId);
            }, () -> {});
        }
    }

    private static final class GlowRenderType
    extends class_1921 {
        public GlowRenderType(String renderTypeName, class_293 vertexFormat, class_293.class_5596 mode, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
            super(renderTypeName, vertexFormat, mode, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
        }

        private static class_1921 createRenderType(class_2960 glowTexture) {
            return class_1921.method_24049((String)"pointblank:glow_iris", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23615(class_4668.field_21370).method_23603(field_21345).method_23604(field_21348).method_23608(field_21383).method_23611(field_21386).method_34577((class_4668.class_5939)new class_4668.class_4683(glowTexture, false, false)).method_34578(class_4668.field_38344).method_23617(false));
        }
    }
}

