/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mod.pbj.Platform;
import net.minecraft.class_151;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;

public interface PointBlankIngredient {
    public static final PointBlankIngredient EMPTY = new PointBlankIngredient(){

        @Override
        public List<class_1799> getItemStacks() {
            return Collections.emptyList();
        }

        @Override
        public int getCount() {
            return 0;
        }

        @Override
        public void toNetwork(class_9129 byteBuf) {
        }
    };
    public static final Codec<PointBlankIngredient> CODEC = Codec.xor(ItemIngredient.CODEC, TagIngredient.CODEC).xmap(p_300070_ -> (PointBlankIngredient)p_300070_.map(p_301348_ -> p_301348_, p_298354_ -> p_298354_), p_299608_ -> {
        if (p_299608_ instanceof TagIngredient) {
            TagIngredient tagIngredient = (TagIngredient)p_299608_;
            return Either.right((Object)tagIngredient);
        }
        if (p_299608_ instanceof ItemIngredient) {
            ItemIngredient itemIngredient = (ItemIngredient)p_299608_;
            return Either.left((Object)itemIngredient);
        }
        throw new UnsupportedOperationException("This is neither an item value nor a tag value.");
    });

    public List<class_1799> getItemStacks();

    public int getCount();

    default public boolean matches(class_1799 itemStack) {
        if (itemStack == null) {
            return false;
        }
        return this.getItemStacks().stream().anyMatch(ingredientStack -> ingredientStack.method_31574(itemStack.method_7909()));
    }

    public void toNetwork(class_9129 var1);

    public static PointBlankIngredient of(class_6862<class_1792> tagKey, int count) {
        return new TagIngredient(tagKey, count);
    }

    public static PointBlankIngredient of(class_1935 itemLike, int count) {
        return new ItemIngredient(itemLike, count);
    }

    public static PointBlankIngredient fromNetwork(class_9129 byteBuf) {
        boolean isItem = byteBuf.readBoolean();
        if (isItem) {
            return ItemIngredient.fromNetwork(byteBuf);
        }
        return TagIngredient.fromNetwork((class_2540)byteBuf);
    }

    public static class TagIngredient
    implements PointBlankIngredient {
        private static final Codec<class_2960> RESOURCE_LOCATION_CODEC = Codec.STRING.comapFlatMap(TagIngredient::readResourceLocation, class_2960::toString).stable();
        static final Codec<TagIngredient> CODEC = RecordCodecBuilder.create(p_300241_ -> p_300241_.group((App)TagIngredient.TAG_KEY_CODEC(class_7924.field_41197).fieldOf("tag").forGetter(ii -> ii.tagKey), (App)class_5699.method_48766((int)1, (int)99).fieldOf("count").orElse((Object)1).forGetter(TagIngredient::getCount)).apply((Applicative)p_300241_, TagIngredient::new));
        private final class_6862<class_1792> tagKey;
        private final int count;
        private final List<class_1799> itemStacks;

        private static DataResult<class_2960> readResourceLocation(String s) {
            try {
                return DataResult.success((Object)Platform.getInstance().parseRecipeResourceLocation(s));
            }
            catch (class_151 var2) {
                return DataResult.error(() -> "Not a valid resource location: " + s + " " + var2.getMessage());
            }
        }

        public static <T> Codec<class_6862<T>> TAG_KEY_CODEC(class_5321<? extends class_2378<T>> resourceKey) {
            return RESOURCE_LOCATION_CODEC.xmap(resourceLocation -> class_6862.method_40092((class_5321)resourceKey, (class_2960)resourceLocation), class_6862::comp_327);
        }

        private TagIngredient(class_6862<class_1792> tagKey, int count) {
            this.tagKey = tagKey;
            this.count = count;
            this.itemStacks = new ArrayList<class_1799>();
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public List<class_1799> getItemStacks() {
            if (this.itemStacks.isEmpty()) {
                for (class_6880 holder : class_7923.field_41178.method_40286(this.tagKey)) {
                    this.itemStacks.add(new class_1799((class_1935)holder.comp_349(), this.count));
                }
            }
            return this.itemStacks;
        }

        @Override
        public final void toNetwork(class_9129 byteBuf) {
            byteBuf.method_52964(false);
            byteBuf.method_10812(this.tagKey.comp_327());
            byteBuf.method_53002(this.count);
        }

        public static PointBlankIngredient fromNetwork(class_2540 byteBuf) {
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)byteBuf.method_10810());
            int count = byteBuf.readInt();
            return new TagIngredient((class_6862<class_1792>)tagKey, count);
        }
    }

    public static class ItemIngredient
    implements PointBlankIngredient {
        static final Codec<ItemIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_47312.fieldOf("item").forGetter(ii -> class_6880.method_40223((Object)ii.getItem())), (App)class_5699.method_48766((int)1, (int)99).fieldOf("count").orElse((Object)1).forGetter(ii -> ii.getCount())).apply((Applicative)instance, (holder, count) -> new ItemIngredient((class_1935)holder.comp_349(), (int)count)));
        private class_1799 itemStack;

        public ItemIngredient(class_1935 itemLike, int count) {
            this.itemStack = new class_1799(itemLike, count);
        }

        public class_1792 getItem() {
            return this.itemStack.method_7909();
        }

        @Override
        public int getCount() {
            return this.itemStack.method_7947();
        }

        @Override
        public List<class_1799> getItemStacks() {
            return Collections.singletonList(this.itemStack);
        }

        @Override
        public final void toNetwork(class_9129 byteBuf) {
            byteBuf.method_52964(true);
            class_1799.field_49268.encode((Object)byteBuf, (Object)this.itemStack);
        }

        public static PointBlankIngredient fromNetwork(class_9129 byteBuf) {
            class_1799 itemStack = (class_1799)class_1799.field_49268.decode((Object)byteBuf);
            return new ItemIngredient((class_1935)itemStack.method_7909(), itemStack.method_7947());
        }
    }
}

