/*
 * Decompiled with CFR 0.152.
 */
package mod.pbj.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.pbj.crafting.Codecs;
import mod.pbj.crafting.PointBlankIngredient;
import mod.pbj.item.GunItem;
import mod.pbj.registry.RecipeTypeRegistry;
import mod.pbj.util.InventoryUtils;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;

public class PointBlankRecipe
implements class_1860<class_9694> {
    private static final int MAX_INGREDIENTS = 10;
    private static Function<class_1937, Map<class_1792, class_8786<PointBlankRecipe>>> levelRecipesByItem = class_156.method_34866(level -> level.method_8433().method_30027(RecipeTypeRegistry.DEFAULT_RECIPE_TYPE.get()).stream().collect(Collectors.toMap(recipeHolder -> ((PointBlankRecipe)recipeHolder.comp_1933()).method_8110(null).method_7909(), recipeHolder -> recipeHolder)));
    private static Function<class_1937, Map<class_2960, PointBlankRecipe>> levelRecipesById = class_156.method_34866(level -> level.method_8433().method_30027(RecipeTypeRegistry.DEFAULT_RECIPE_TYPE.get()).stream().collect(Collectors.toMap(recipeHolder -> recipeHolder.comp_1932(), recipeHolder -> (PointBlankRecipe)recipeHolder.comp_1933())));
    private final String group;
    private final class_1799 result;
    private final class_1799 initializedItemStack;
    private final class_2371<PointBlankIngredient> ingredients;
    private static class_2371<class_1856> defaultIngredients = class_2371.method_10212((Object)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620}), (Object[])new class_1856[0]);

    public static PointBlankRecipe getRecipe(class_1937 level, class_1792 item) {
        class_8786<PointBlankRecipe> holder = levelRecipesByItem.apply(level).get(item);
        return holder != null ? (PointBlankRecipe)holder.comp_1933() : null;
    }

    public static PointBlankRecipe getRecipe(class_1937 level, class_2960 recipeId) {
        return levelRecipesById.apply(level).get(recipeId);
    }

    public static List<PointBlankRecipe> getRecipes(class_1937 level) {
        return new ArrayList<PointBlankRecipe>(levelRecipesById.apply(level).values());
    }

    public PointBlankRecipe(String group, class_1799 resultItemStack, List<PointBlankIngredient> ingredients) {
        this.group = group;
        this.result = resultItemStack;
        this.initializedItemStack = resultItemStack.method_7972();
        if (this.initializedItemStack.method_7909() instanceof GunItem) {
            GunItem.initStackForCrafting(this.initializedItemStack);
        }
        if (ingredients == null || ingredients.isEmpty()) {
            throw new IllegalArgumentException("Recipe ingredients are not set for item " + String.valueOf(resultItemStack));
        }
        if (ingredients.size() > 10) {
            throw new IllegalArgumentException("Recipe ingredients for item " + String.valueOf(resultItemStack) + " exceed maximum allowed count of 10");
        }
        this.ingredients = class_2371.method_10211();
        this.ingredients.addAll(ingredients);
    }

    public class_2960 getId(class_1937 level) {
        class_8786<PointBlankRecipe> holder = levelRecipesByItem.apply(level).get(this.result.method_7909());
        return holder != null ? holder.comp_1932() : null;
    }

    public class_1865<?> method_8119() {
        return RecipeTypeRegistry.DEFAULT_SERIALIZER.get();
    }

    public String method_8112() {
        return this.group;
    }

    public class_1799 method_8110(class_7225.class_7874 p_331967_) {
        return this.result.method_7972();
    }

    public class_1799 getInitializedStack() {
        return this.initializedItemStack;
    }

    public class_2371<class_1856> method_8117() {
        return defaultIngredients;
    }

    public List<PointBlankIngredient> getPointBlankIngredients() {
        return this.ingredients;
    }

    public boolean matches(class_9694 p_343697_, class_1937 p_44003_) {
        throw new UnsupportedOperationException("Implement me!");
    }

    public boolean canBeCrafted(class_1657 player) {
        return this.ingredients.stream().anyMatch(ingredient -> InventoryUtils.hasIngredient(player, ingredient));
    }

    public void removeIngredients(class_1657 player) {
        this.ingredients.stream().forEach(ingredient -> InventoryUtils.removeItem(player, ingredient::matches, ingredient.getCount()));
    }

    public class_1799 assemble(class_8566 craftingContainer, class_5455 registryAccess) {
        return this.result.method_7972();
    }

    public boolean method_8113(int m, int n) {
        return false;
    }

    public class_1799 assemble(class_9694 p_343633_, class_7225.class_7874 p_332698_) {
        throw new UnsupportedOperationException("Implement me!");
    }

    public class_3956<?> method_17716() {
        return RecipeTypeRegistry.DEFAULT_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements class_1865<PointBlankRecipe> {
        public static final MapCodec<PointBlankRecipe> CODEC = RecordCodecBuilder.mapCodec(p_327208_ -> p_327208_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"test").forGetter(recipe -> recipe.group), (App)Codecs.ITEM_STACK_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)PointBlankIngredient.CODEC.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] aingredient = (PointBlankIngredient[])ingredients.stream().toArray(PointBlankIngredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > 10 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)class_2371.method_10212((Object)PointBlankIngredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(p_298509_ -> p_298509_.ingredients)).apply((Applicative)p_327208_, PointBlankRecipe::new));
        public static final class_9139<class_9129, PointBlankRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        private static PointBlankRecipe fromNetwork(class_9129 byteBuf) {
            String recipeGroup = byteBuf.method_19772();
            int ingredientSize = byteBuf.method_10816();
            class_2371 ingredients = class_2371.method_10211();
            for (int j = 0; j < ingredientSize; ++j) {
                ingredients.add((Object)PointBlankIngredient.fromNetwork(byteBuf));
            }
            class_1799 itemStack = (class_1799)class_1799.field_49268.decode((Object)byteBuf);
            return new PointBlankRecipe(recipeGroup, itemStack, (List<PointBlankIngredient>)ingredients);
        }

        private static void toNetwork(class_9129 byteBuf, PointBlankRecipe recipe) {
            byteBuf.method_10814(recipe.group);
            byteBuf.method_10804(recipe.ingredients.size());
            for (PointBlankIngredient ingredient : recipe.ingredients) {
                ingredient.toNetwork(byteBuf);
            }
            class_1799.field_49268.encode((Object)byteBuf, (Object)recipe.result);
        }

        public MapCodec<PointBlankRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, PointBlankRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

